% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_stop_training_document_classifier}
\alias{comprehend_stop_training_document_classifier}
\title{Stops a document classifier training job while in progress}
\usage{
comprehend_stop_training_document_classifier(DocumentClassifierArn)
}
\arguments{
\item{DocumentClassifierArn}{[required] The Amazon Resource Name (ARN) that identifies the document classifier
currently being trained.}
}
\value{
An empty list.
}
\description{
Stops a document classifier training job while in progress.

If the training job state is \code{TRAINING}, the job is marked for
termination and put into the \code{STOP_REQUESTED} state. If the training job
completes before it can be stopped, it is put into the \code{TRAINED};
otherwise the training job is stopped and put into the \code{STOPPED} state
and the service sends back an HTTP 200 response with an empty HTTP body.
}
\section{Request syntax}{
\preformatted{svc$stop_training_document_classifier(
  DocumentClassifierArn = "string"
)
}
}

\keyword{internal}
