% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_experiment}
\alias{sagemaker_create_experiment}
\title{Creates an Amazon SageMaker \emph{experiment}}
\usage{
sagemaker_create_experiment(ExperimentName, DisplayName, Description,
  Tags)
}
\arguments{
\item{ExperimentName}{[required] The name of the experiment. The name must be unique in your AWS account
and is not case-sensitive.}

\item{DisplayName}{The name of the experiment as displayed. The name doesn\'t need to be
unique. If you don\'t specify \code{DisplayName}, the value in
\code{ExperimentName} is displayed.}

\item{Description}{The description of the experiment.}

\item{Tags}{A list of tags to associate with the experiment. You can use Search API
to search on the tags.}
}
\description{
Creates an Amazon SageMaker \emph{experiment}. An experiment is a collection
of \emph{trials} that are observed, compared and evaluated as a group. A
trial is a set of steps, called \emph{trial components}, that produce a
machine learning model.
}
\details{
The goal of an experiment is to determine the components that produce
the best model. Multiple trials are performed, each one isolating and
measuring the impact of a change to one or more inputs, while keeping
the remaining inputs constant.

When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK,
all experiments, trials, and trial components are automatically tracked,
logged, and indexed. When you use the AWS SDK for Python (Boto), you
must use the logging APIs provided by the SDK.

You can add tags to experiments, trials, trial components and then use
the Search API to search for the tags.

To add a description to an experiment, specify the optional
\code{Description} parameter. To add a description later, or to change the
description, call the UpdateExperiment API.

To get a list of all your experiments, call the ListExperiments API. To
view an experiment\'s properties, call the DescribeExperiment API. To
get a list of all the trials associated with an experiment, call the
ListTrials API. To create a trial call the CreateTrial API.
}
\section{Request syntax}{
\preformatted{svc$create_experiment(
  ExperimentName = "string",
  DisplayName = "string",
  Description = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
