% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_update_medical_vocabulary}
\alias{transcribeservice_update_medical_vocabulary}
\title{Updates an existing vocabulary with new values in a different text file}
\usage{
transcribeservice_update_medical_vocabulary(VocabularyName,
  LanguageCode, VocabularyFileUri)
}
\arguments{
\item{VocabularyName}{[required] The name of the vocabulary to update. The name is case-sensitive. If you
try to update a vocabulary with the same name as a previous vocabulary
you will receive a \code{ConflictException} error.}

\item{LanguageCode}{[required] The language code of the entries in the updated vocabulary. US English
(en-US) is the only valid language code in Amazon Transcribe Medical.}

\item{VocabularyFileUri}{The Amazon S3 location of the text file containing the definition of the
custom vocabulary. The URI must be in the same AWS region as the API
endpoint you are calling. You can see the fields you need to enter for
you Amazon S3 location in the example URI here:

\verb{https://s3.&lt;aws-region&gt;.amazonaws.com/&lt;bucket-name&gt;/&lt;keyprefix&gt;/&lt;objectkey&gt;}

For example:

\verb{https://s3.us-east-1.amazonaws.com/AWSDOC-EXAMPLE-BUCKET/vocab.txt}

For more information about S3 object names, see \href{http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys}{Object Keys}
in the \emph{Amazon S3 Developer Guide}.

For more information about custom vocabularies in Amazon Transcribe
Medical, see \href{http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary}{Medical Custom Vocabularies}.}
}
\description{
Updates an existing vocabulary with new values in a different text file.
The \code{UpdateMedicalVocabulary} operation overwrites all of the existing
information with the values that you provide in the request.
}
\section{Request syntax}{
\preformatted{svc$update_medical_vocabulary(
  VocabularyName = "string",
  LanguageCode = "en-US"|"es-US"|"en-AU"|"fr-CA"|"en-GB"|"de-DE"|"pt-BR"|"fr-FR"|"it-IT"|"ko-KR"|"es-ES"|"en-IN"|"hi-IN"|"ar-SA"|"ru-RU"|"zh-CN"|"nl-NL"|"id-ID"|"ta-IN"|"fa-IR"|"en-IE"|"en-AB"|"en-WL"|"pt-PT"|"te-IN"|"tr-TR"|"de-CH"|"he-IL"|"ms-MY"|"ja-JP"|"ar-AE",
  VocabularyFileUri = "string"
)
}
}

\keyword{internal}
