% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_get_bot_channel_associations}
\alias{lexmodelbuildingservice_get_bot_channel_associations}
\title{Returns a list of all of the channels associated with the specified bot}
\usage{
lexmodelbuildingservice_get_bot_channel_associations(
  botName,
  botAlias,
  nextToken = NULL,
  maxResults = NULL,
  nameContains = NULL
)
}
\arguments{
\item{botName}{[required] The name of the Amazon Lex bot in the association.}

\item{botAlias}{[required] An alias pointing to the specific version of the Amazon Lex bot to which
this association is being made.}

\item{nextToken}{A pagination token for fetching the next page of associations. If the
response to this call is truncated, Amazon Lex returns a pagination
token in the response. To fetch the next page of associations, specify
the pagination token in the next request.}

\item{maxResults}{The maximum number of associations to return in the response. The
default is 50.}

\item{nameContains}{Substring to match in channel association names. An association will be
returned if any part of its name matches the substring. For example,
"xyz" matches both "xyzabc" and "abcxyz." To return all bot channel
associations, use a hyphen ("-") as the \code{nameContains} parameter.}
}
\description{
Returns a list of all of the channels associated with the specified bot.

See \url{https://www.paws-r-sdk.com/docs/lexmodelbuildingservice_get_bot_channel_associations/} for full documentation.
}
\keyword{internal}
