# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include elasticinference_service.R
NULL

#' Describes the locations in which a given accelerator type or set of
#' types is present in a given region
#'
#' @description
#' Describes the locations in which a given accelerator type or set of types is present in a given region.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticinference_describe_accelerator_offerings/](https://www.paws-r-sdk.com/docs/elasticinference_describe_accelerator_offerings/) for full documentation.
#'
#' @param locationType &#91;required&#93; The location type that you want to describe accelerator type offerings
#' for. It can assume the following values: region: will return the
#' accelerator type offering at the regional level. availability-zone: will
#' return the accelerator type offering at the availability zone level.
#' availability-zone-id: will return the accelerator type offering at the
#' availability zone level returning the availability zone id.
#' @param acceleratorTypes The list of accelerator types to describe.
#'
#' @keywords internal
#'
#' @rdname elasticinference_describe_accelerator_offerings
elasticinference_describe_accelerator_offerings <- function(locationType, acceleratorTypes = NULL) {
  op <- new_operation(
    name = "DescribeAcceleratorOfferings",
    http_method = "POST",
    http_path = "/describe-accelerator-offerings",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticinference$describe_accelerator_offerings_input(locationType = locationType, acceleratorTypes = acceleratorTypes)
  output <- .elasticinference$describe_accelerator_offerings_output()
  config <- get_config()
  svc <- .elasticinference$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticinference$operations$describe_accelerator_offerings <- elasticinference_describe_accelerator_offerings

#' Describes the accelerator types available in a given region, as well as
#' their characteristics, such as memory and throughput
#'
#' @description
#' Describes the accelerator types available in a given region, as well as their characteristics, such as memory and throughput.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticinference_describe_accelerator_types/](https://www.paws-r-sdk.com/docs/elasticinference_describe_accelerator_types/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname elasticinference_describe_accelerator_types
elasticinference_describe_accelerator_types <- function() {
  op <- new_operation(
    name = "DescribeAcceleratorTypes",
    http_method = "GET",
    http_path = "/describe-accelerator-types",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticinference$describe_accelerator_types_input()
  output <- .elasticinference$describe_accelerator_types_output()
  config <- get_config()
  svc <- .elasticinference$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticinference$operations$describe_accelerator_types <- elasticinference_describe_accelerator_types

#' Describes information over a provided set of accelerators belonging to
#' an account
#'
#' @description
#' Describes information over a provided set of accelerators belonging to an account.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticinference_describe_accelerators/](https://www.paws-r-sdk.com/docs/elasticinference_describe_accelerators/) for full documentation.
#'
#' @param acceleratorIds The IDs of the accelerators to describe.
#' @param filters One or more filters. Filter names and values are case-sensitive. Valid
#' filter names are: accelerator-types: can provide a list of accelerator
#' type names to filter for. instance-id: can provide a list of EC2
#' instance ids to filter for.
#' @param maxResults The total number of items to return in the command's output. If the
#' total number of items available is more than the value specified, a
#' NextToken is provided in the command's output. To resume pagination,
#' provide the NextToken value in the starting-token argument of a
#' subsequent command. Do not use the NextToken response element directly
#' outside of the AWS CLI.
#' @param nextToken A token to specify where to start paginating. This is the NextToken from
#' a previously truncated response.
#'
#' @keywords internal
#'
#' @rdname elasticinference_describe_accelerators
elasticinference_describe_accelerators <- function(acceleratorIds = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeAccelerators",
    http_method = "POST",
    http_path = "/describe-accelerators",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "acceleratorSet")
  )
  input <- .elasticinference$describe_accelerators_input(acceleratorIds = acceleratorIds, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .elasticinference$describe_accelerators_output()
  config <- get_config()
  svc <- .elasticinference$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticinference$operations$describe_accelerators <- elasticinference_describe_accelerators

#' Returns all tags of an Elastic Inference Accelerator
#'
#' @description
#' Returns all tags of an Elastic Inference Accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticinference_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/elasticinference_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the Elastic Inference Accelerator to list the tags for.
#'
#' @keywords internal
#'
#' @rdname elasticinference_list_tags_for_resource
elasticinference_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticinference$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .elasticinference$list_tags_for_resource_output()
  config <- get_config()
  svc <- .elasticinference$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticinference$operations$list_tags_for_resource <- elasticinference_list_tags_for_resource

#' Adds the specified tags to an Elastic Inference Accelerator
#'
#' @description
#' Adds the specified tags to an Elastic Inference Accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticinference_tag_resource/](https://www.paws-r-sdk.com/docs/elasticinference_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the Elastic Inference Accelerator to tag.
#' @param tags &#91;required&#93; The tags to add to the Elastic Inference Accelerator.
#'
#' @keywords internal
#'
#' @rdname elasticinference_tag_resource
elasticinference_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticinference$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .elasticinference$tag_resource_output()
  config <- get_config()
  svc <- .elasticinference$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticinference$operations$tag_resource <- elasticinference_tag_resource

#' Removes the specified tags from an Elastic Inference Accelerator
#'
#' @description
#' Removes the specified tags from an Elastic Inference Accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticinference_untag_resource/](https://www.paws-r-sdk.com/docs/elasticinference_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the Elastic Inference Accelerator to untag.
#' @param tagKeys &#91;required&#93; The list of tags to remove from the Elastic Inference Accelerator.
#'
#' @keywords internal
#'
#' @rdname elasticinference_untag_resource
elasticinference_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .elasticinference$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .elasticinference$untag_resource_output()
  config <- get_config()
  svc <- .elasticinference$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticinference$operations$untag_resource <- elasticinference_untag_resource
