% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_create_guardrail}
\alias{bedrock_create_guardrail}
\title{Creates a guardrail to block topics and to implement safeguards for your
generative AI applications}
\usage{
bedrock_create_guardrail(
  name,
  description = NULL,
  topicPolicyConfig = NULL,
  contentPolicyConfig = NULL,
  wordPolicyConfig = NULL,
  sensitiveInformationPolicyConfig = NULL,
  contextualGroundingPolicyConfig = NULL,
  blockedInputMessaging,
  blockedOutputsMessaging,
  kmsKeyId = NULL,
  tags = NULL,
  clientRequestToken = NULL
)
}
\arguments{
\item{name}{[required] The name to give the guardrail.}

\item{description}{A description of the guardrail.}

\item{topicPolicyConfig}{The topic policies to configure for the guardrail.}

\item{contentPolicyConfig}{The content filter policies to configure for the guardrail.}

\item{wordPolicyConfig}{The word policy you configure for the guardrail.}

\item{sensitiveInformationPolicyConfig}{The sensitive information policy to configure for the guardrail.}

\item{contextualGroundingPolicyConfig}{The contextual grounding policy configuration used to create a
guardrail.}

\item{blockedInputMessaging}{[required] The message to return when the guardrail blocks a prompt.}

\item{blockedOutputsMessaging}{[required] The message to return when the guardrail blocks a model response.}

\item{kmsKeyId}{The ARN of the KMS key that you use to encrypt the guardrail.}

\item{tags}{The tags that you want to attach to the guardrail.}

\item{clientRequestToken}{A unique, case-sensitive identifier to ensure that the API request
completes no more than once. If this token matches a previous request,
Amazon Bedrock ignores the request, but does not return an error. For
more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}
in the \emph{Amazon S3 User Guide}.}
}
\description{
Creates a guardrail to block topics and to implement safeguards for your generative AI applications.

See \url{https://www.paws-r-sdk.com/docs/bedrock_create_guardrail/} for full documentation.
}
\keyword{internal}
