% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_start_bot_resource_generation}
\alias{lexmodelsv2_start_bot_resource_generation}
\title{Starts a request for the descriptive bot builder to generate a bot
locale configuration based on the prompt you provide it}
\usage{
lexmodelsv2_start_bot_resource_generation(
  generationInputPrompt,
  botId,
  botVersion,
  localeId
)
}
\arguments{
\item{generationInputPrompt}{[required] The prompt to generate intents and slot types for the bot locale. Your
description should be both \emph{detailed} and \emph{precise} to help generate
appropriate and sufficient intents for your bot. Include a list of
actions to improve the intent creation process.}

\item{botId}{[required] The unique identifier of the bot for which to generate intents and slot
types.}

\item{botVersion}{[required] The version of the bot for which to generate intents and slot types.}

\item{localeId}{[required] The locale of the bot for which to generate intents and slot types.}
}
\description{
Starts a request for the descriptive bot builder to generate a bot locale configuration based on the prompt you provide it. After you make this call, use the \code{\link[=lexmodelsv2_describe_bot_resource_generation]{describe_bot_resource_generation}} operation to check on the status of the generation and for the \code{generatedBotLocaleUrl} when the generation is complete. Use that value to retrieve the Amazon S3 object containing the bot locale configuration. You can then modify and import this configuration.

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_start_bot_resource_generation/} for full documentation.
}
\keyword{internal}
