% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_associate_elastic_ip}
\alias{opsworks_associate_elastic_ip}
\title{Associates one of the stack's registered Elastic IP addresses with a
specified instance}
\usage{
opsworks_associate_elastic_ip(ElasticIp, InstanceId)
}
\arguments{
\item{ElasticIp}{[required] The Elastic IP address.}

\item{InstanceId}{The instance ID.}
}
\description{
Associates one of the stack's registered Elastic IP addresses with a
specified instance. The address must first be registered with the stack
by calling RegisterElasticIp. For more information, see \href{http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html}{Resource Management}.
}
\details{
\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$associate_elastic_ip(
  ElasticIp = "string",
  InstanceId = "string"
)
}
}

\keyword{internal}
