% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_delete_policy}
\alias{organizations_delete_policy}
\title{Deletes the specified policy from your organization}
\usage{
organizations_delete_policy(PolicyId)
}
\arguments{
\item{PolicyId}{[required] The unique identifier (ID) of the policy that you want to delete. You
can get the ID from the ListPolicies or ListPoliciesForTarget
operations.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for a policy ID
string requires "p-" followed by from 8 to 128 lower-case letters or
digits.}
}
\description{
Deletes the specified policy from your organization. Before you perform
this operation, you must first detach the policy from all organizational
units (OUs), roots, and accounts.
}
\details{
This operation can be called only from the organization's master
account.
}
\section{Request syntax}{
\preformatted{svc$delete_policy(
  PolicyId = "string"
)
}
}

\examples{
# The following example shows how to delete a policy from an organization.
# The example assumes that you previously detached the policy from all
# entities:
# 
# 
\donttest{svc$delete_policy(
  PolicyId = "p-examplepolicyid111"
)}

}
\keyword{internal}
