% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_create_resource_data_sync}
\alias{ssm_create_resource_data_sync}
\title{Creates a resource data sync configuration to a single bucket in Amazon
S3}
\usage{
ssm_create_resource_data_sync(SyncName, S3Destination)
}
\arguments{
\item{SyncName}{[required] A name for the configuration.}

\item{S3Destination}{[required] Amazon S3 configuration details for the sync.}
}
\description{
Creates a resource data sync configuration to a single bucket in Amazon
S3. This is an asynchronous operation that returns immediately. After a
successful initial sync is completed, the system continuously syncs data
to the Amazon S3 bucket. To check the status of the sync, use the
ListResourceDataSync.
}
\details{
By default, data is not encrypted in Amazon S3. We strongly recommend
that you enable encryption in Amazon S3 to ensure secure data storage.
We also recommend that you secure access to the Amazon S3 bucket by
creating a restrictive bucket policy. For more information, see
\href{http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html}{Configuring Resource Data Sync for Inventory}
in the \emph{AWS Systems Manager User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_resource_data_sync(
  SyncName = "string",
  S3Destination = list(
    BucketName = "string",
    Prefix = "string",
    SyncFormat = "JsonSerDe",
    Region = "string",
    AWSKMSKeyARN = "string"
  )
)
}
}

\keyword{internal}
