# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include health_service.R
NULL

#' Returns a list of entities that have been affected by the specified
#' events, based on the specified filter criteria
#'
#' Returns a list of entities that have been affected by the specified
#' events, based on the specified filter criteria. Entities can refer to
#' individual customer resources, groups of customer resources, or any
#' other construct, depending on the AWS service. Events that have impact
#' beyond that of the affected entities, or where the extent of impact is
#' unknown, include at least one entity indicating this.
#' 
#' At least one event ARN is required. Results are sorted by the
#' `lastUpdatedTime` of the entity, starting with the most recent.
#'
#' @usage
#' health_describe_affected_entities(filter, locale, nextToken, maxResults)
#'
#' @param filter &#91;required&#93; Values to narrow the results returned. At least one event ARN is
#' required.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#'
#' @section Request syntax:
#' ```
#' svc$describe_affected_entities(
#'   filter = list(
#'     eventArns = list(
#'       "string"
#'     ),
#'     entityArns = list(
#'       "string"
#'     ),
#'     entityValues = list(
#'       "string"
#'     ),
#'     lastUpdatedTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     tags = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     statusCodes = list(
#'       "IMPAIRED"|"UNIMPAIRED"|"UNKNOWN"
#'     )
#'   ),
#'   locale = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_affected_entities
health_describe_affected_entities <- function(filter, locale = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeAffectedEntities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_affected_entities_input(filter = filter, locale = locale, nextToken = nextToken, maxResults = maxResults)
  output <- .health$describe_affected_entities_output()
  svc <- .health$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_affected_entities <- health_describe_affected_entities

#' Returns the number of entities that are affected by each of the
#' specified events
#'
#' Returns the number of entities that are affected by each of the
#' specified events. If no events are specified, the counts of all affected
#' entities are returned.
#'
#' @usage
#' health_describe_entity_aggregates(eventArns)
#'
#' @param eventArns A list of event ARNs (unique identifiers). For example:
#' `"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"`
#'
#' @section Request syntax:
#' ```
#' svc$describe_entity_aggregates(
#'   eventArns = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_entity_aggregates
health_describe_entity_aggregates <- function(eventArns = NULL) {
  op <- new_operation(
    name = "DescribeEntityAggregates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_entity_aggregates_input(eventArns = eventArns)
  output <- .health$describe_entity_aggregates_output()
  svc <- .health$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_entity_aggregates <- health_describe_entity_aggregates

#' Returns the number of events of each event type (issue, scheduled
#' change, and account notification)
#'
#' Returns the number of events of each event type (issue, scheduled
#' change, and account notification). If no filter is specified, the counts
#' of all events in each category are returned.
#'
#' @usage
#' health_describe_event_aggregates(filter, aggregateField, maxResults,
#'   nextToken)
#'
#' @param filter Values to narrow the results returned.
#' @param aggregateField &#91;required&#93; The only currently supported value is `eventTypeCategory`.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_aggregates(
#'   filter = list(
#'     eventArns = list(
#'       "string"
#'     ),
#'     eventTypeCodes = list(
#'       "string"
#'     ),
#'     services = list(
#'       "string"
#'     ),
#'     regions = list(
#'       "string"
#'     ),
#'     availabilityZones = list(
#'       "string"
#'     ),
#'     startTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     endTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     lastUpdatedTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     entityArns = list(
#'       "string"
#'     ),
#'     entityValues = list(
#'       "string"
#'     ),
#'     eventTypeCategories = list(
#'       "issue"|"accountNotification"|"scheduledChange"
#'     ),
#'     tags = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     eventStatusCodes = list(
#'       "open"|"closed"|"upcoming"
#'     )
#'   ),
#'   aggregateField = "eventTypeCategory",
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_event_aggregates
health_describe_event_aggregates <- function(filter = NULL, aggregateField, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeEventAggregates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_event_aggregates_input(filter = filter, aggregateField = aggregateField, maxResults = maxResults, nextToken = nextToken)
  output <- .health$describe_event_aggregates_output()
  svc <- .health$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_event_aggregates <- health_describe_event_aggregates

#' Returns detailed information about one or more specified events
#'
#' Returns detailed information about one or more specified events.
#' Information includes standard event data (region, service, etc., as
#' returned by DescribeEvents), a detailed event description, and possible
#' additional metadata that depends upon the nature of the event. Affected
#' entities are not included; to retrieve those, use the
#' DescribeAffectedEntities operation.
#' 
#' If a specified event cannot be retrieved, an error message is returned
#' for that event.
#'
#' @usage
#' health_describe_event_details(eventArns, locale)
#'
#' @param eventArns &#91;required&#93; A list of event ARNs (unique identifiers). For example:
#' `"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"`
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_details(
#'   eventArns = list(
#'     "string"
#'   ),
#'   locale = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_event_details
health_describe_event_details <- function(eventArns, locale = NULL) {
  op <- new_operation(
    name = "DescribeEventDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_event_details_input(eventArns = eventArns, locale = locale)
  output <- .health$describe_event_details_output()
  svc <- .health$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_event_details <- health_describe_event_details

#' Returns the event types that meet the specified filter criteria
#'
#' Returns the event types that meet the specified filter criteria. If no
#' filter criteria are specified, all event types are returned, in no
#' particular order.
#'
#' @usage
#' health_describe_event_types(filter, locale, nextToken, maxResults)
#'
#' @param filter Values to narrow the results returned.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_types(
#'   filter = list(
#'     eventTypeCodes = list(
#'       "string"
#'     ),
#'     services = list(
#'       "string"
#'     ),
#'     eventTypeCategories = list(
#'       "issue"|"accountNotification"|"scheduledChange"
#'     )
#'   ),
#'   locale = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_event_types
health_describe_event_types <- function(filter = NULL, locale = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeEventTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_event_types_input(filter = filter, locale = locale, nextToken = nextToken, maxResults = maxResults)
  output <- .health$describe_event_types_output()
  svc <- .health$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_event_types <- health_describe_event_types

#' Returns information about events that meet the specified filter criteria
#'
#' Returns information about events that meet the specified filter
#' criteria. Events are returned in a summary form and do not include the
#' detailed description, any additional metadata that depends on the event
#' type, or any affected resources. To retrieve that information, use the
#' DescribeEventDetails and DescribeAffectedEntities operations.
#' 
#' If no filter criteria are specified, all events are returned. Results
#' are sorted by `lastModifiedTime`, starting with the most recent.
#'
#' @usage
#' health_describe_events(filter, nextToken, maxResults, locale)
#'
#' @param filter Values to narrow the results returned.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#'
#' @section Request syntax:
#' ```
#' svc$describe_events(
#'   filter = list(
#'     eventArns = list(
#'       "string"
#'     ),
#'     eventTypeCodes = list(
#'       "string"
#'     ),
#'     services = list(
#'       "string"
#'     ),
#'     regions = list(
#'       "string"
#'     ),
#'     availabilityZones = list(
#'       "string"
#'     ),
#'     startTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     endTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     lastUpdatedTimes = list(
#'       list(
#'         from = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         to = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     entityArns = list(
#'       "string"
#'     ),
#'     entityValues = list(
#'       "string"
#'     ),
#'     eventTypeCategories = list(
#'       "issue"|"accountNotification"|"scheduledChange"
#'     ),
#'     tags = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     eventStatusCodes = list(
#'       "open"|"closed"|"upcoming"
#'     )
#'   ),
#'   nextToken = "string",
#'   maxResults = 123,
#'   locale = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname health_describe_events
health_describe_events <- function(filter = NULL, nextToken = NULL, maxResults = NULL, locale = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .health$describe_events_input(filter = filter, nextToken = nextToken, maxResults = maxResults, locale = locale)
  output <- .health$describe_events_output()
  svc <- .health$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_events <- health_describe_events
