% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_register_rds_db_instance}
\alias{opsworks_register_rds_db_instance}
\title{Registers an Amazon RDS instance with a stack}
\usage{
opsworks_register_rds_db_instance(StackId, RdsDbInstanceArn, DbUser,
  DbPassword)
}
\arguments{
\item{StackId}{[required] The stack ID.}

\item{RdsDbInstanceArn}{[required] The Amazon RDS instance's ARN.}

\item{DbUser}{[required] The database's master user name.}

\item{DbPassword}{[required] The database password.}
}
\description{
Registers an Amazon RDS instance with a stack.
}
\details{
\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$register_rds_db_instance(
  StackId = "string",
  RdsDbInstanceArn = "string",
  DbUser = "string",
  DbPassword = "string"
)
}
}

\keyword{internal}
