# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include applicationinsights_service.R
NULL

#' Adds an application that is created from a resource group
#'
#' @description
#' Adds an application that is created from a resource group.
#'
#' @usage
#' applicationinsights_create_application(ResourceGroupName,
#'   OpsCenterEnabled, CWEMonitorEnabled, OpsItemSNSTopicArn, Tags)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param OpsCenterEnabled When set to `true`, creates opsItems for any problems detected on an
#' application.
#' @param CWEMonitorEnabled Indicates whether Application Insights can listen to CloudWatch events
#' for the application resources, such as `instance terminated`,
#' `failed deployment`, and others.
#' @param OpsItemSNSTopicArn The SNS topic provided to Application Insights that is associated to the
#' created opsItem. Allows you to receive notifications for updates to the
#' opsItem.
#' @param Tags List of tags to add to the application. tag key (`Key`) and an
#' associated tag value (`Value`). The maximum length of a tag key is 128
#' characters. The maximum length of a tag value is 256 characters.
#'
#' @section Request syntax:
#' ```
#' svc$create_application(
#'   ResourceGroupName = "string",
#'   OpsCenterEnabled = TRUE|FALSE,
#'   CWEMonitorEnabled = TRUE|FALSE,
#'   OpsItemSNSTopicArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_create_application
applicationinsights_create_application <- function(ResourceGroupName, OpsCenterEnabled = NULL, CWEMonitorEnabled = NULL, OpsItemSNSTopicArn = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$create_application_input(ResourceGroupName = ResourceGroupName, OpsCenterEnabled = OpsCenterEnabled, CWEMonitorEnabled = CWEMonitorEnabled, OpsItemSNSTopicArn = OpsItemSNSTopicArn, Tags = Tags)
  output <- .applicationinsights$create_application_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$create_application <- applicationinsights_create_application

#' Creates a custom component by grouping similar standalone instances to
#' monitor
#'
#' @description
#' Creates a custom component by grouping similar standalone instances to
#' monitor.
#'
#' @usage
#' applicationinsights_create_component(ResourceGroupName, ComponentName,
#'   ResourceList)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param ResourceList &#91;required&#93; The list of resource ARNs that belong to the component.
#'
#' @section Request syntax:
#' ```
#' svc$create_component(
#'   ResourceGroupName = "string",
#'   ComponentName = "string",
#'   ResourceList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_create_component
applicationinsights_create_component <- function(ResourceGroupName, ComponentName, ResourceList) {
  op <- new_operation(
    name = "CreateComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$create_component_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, ResourceList = ResourceList)
  output <- .applicationinsights$create_component_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$create_component <- applicationinsights_create_component

#' Adds an log pattern to a LogPatternSet
#'
#' @description
#' Adds an log pattern to a `LogPatternSet`.
#'
#' @usage
#' applicationinsights_create_log_pattern(ResourceGroupName,
#'   PatternSetName, PatternName, Pattern, Rank)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param PatternSetName &#91;required&#93; The name of the log pattern set.
#' @param PatternName &#91;required&#93; The name of the log pattern.
#' @param Pattern &#91;required&#93; The log pattern. The pattern must be DFA compatible. Patterns that
#' utilize forward lookahead or backreference constructions are not
#' supported.
#' @param Rank &#91;required&#93; Rank of the log pattern. Must be a value between `1` and `1,000,000`.
#' The patterns are sorted by rank, so we recommend that you set your
#' highest priority patterns with the lowest rank. A pattern of rank `1`
#' will be the first to get matched to a log line. A pattern of rank
#' `1,000,000` will be last to get matched. When you configure custom log
#' patterns from the console, a `Low` severity pattern translates to a
#' `750,000` rank. A `Medium` severity pattern translates to a `500,000`
#' rank. And a `High` severity pattern translates to a `250,000` rank. Rank
#' values less than `1` or greater than `1,000,000` are reserved for
#' AWS-provided patterns.
#'
#' @section Request syntax:
#' ```
#' svc$create_log_pattern(
#'   ResourceGroupName = "string",
#'   PatternSetName = "string",
#'   PatternName = "string",
#'   Pattern = "string",
#'   Rank = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_create_log_pattern
applicationinsights_create_log_pattern <- function(ResourceGroupName, PatternSetName, PatternName, Pattern, Rank) {
  op <- new_operation(
    name = "CreateLogPattern",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$create_log_pattern_input(ResourceGroupName = ResourceGroupName, PatternSetName = PatternSetName, PatternName = PatternName, Pattern = Pattern, Rank = Rank)
  output <- .applicationinsights$create_log_pattern_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$create_log_pattern <- applicationinsights_create_log_pattern

#' Removes the specified application from monitoring
#'
#' @description
#' Removes the specified application from monitoring. Does not delete the
#' application.
#'
#' @usage
#' applicationinsights_delete_application(ResourceGroupName)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application(
#'   ResourceGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_delete_application
applicationinsights_delete_application <- function(ResourceGroupName) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$delete_application_input(ResourceGroupName = ResourceGroupName)
  output <- .applicationinsights$delete_application_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$delete_application <- applicationinsights_delete_application

#' Ungroups a custom component
#'
#' @description
#' Ungroups a custom component. When you ungroup custom components, all
#' applicable monitors that are set up for the component are removed and
#' the instances revert to their standalone status.
#'
#' @usage
#' applicationinsights_delete_component(ResourceGroupName, ComponentName)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#'
#' @section Request syntax:
#' ```
#' svc$delete_component(
#'   ResourceGroupName = "string",
#'   ComponentName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_delete_component
applicationinsights_delete_component <- function(ResourceGroupName, ComponentName) {
  op <- new_operation(
    name = "DeleteComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$delete_component_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName)
  output <- .applicationinsights$delete_component_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$delete_component <- applicationinsights_delete_component

#' Removes the specified log pattern from a LogPatternSet
#'
#' @description
#' Removes the specified log pattern from a `LogPatternSet`.
#'
#' @usage
#' applicationinsights_delete_log_pattern(ResourceGroupName,
#'   PatternSetName, PatternName)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param PatternSetName &#91;required&#93; The name of the log pattern set.
#' @param PatternName &#91;required&#93; The name of the log pattern.
#'
#' @section Request syntax:
#' ```
#' svc$delete_log_pattern(
#'   ResourceGroupName = "string",
#'   PatternSetName = "string",
#'   PatternName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_delete_log_pattern
applicationinsights_delete_log_pattern <- function(ResourceGroupName, PatternSetName, PatternName) {
  op <- new_operation(
    name = "DeleteLogPattern",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$delete_log_pattern_input(ResourceGroupName = ResourceGroupName, PatternSetName = PatternSetName, PatternName = PatternName)
  output <- .applicationinsights$delete_log_pattern_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$delete_log_pattern <- applicationinsights_delete_log_pattern

#' Describes the application
#'
#' @description
#' Describes the application.
#'
#' @usage
#' applicationinsights_describe_application(ResourceGroupName)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#'
#' @section Request syntax:
#' ```
#' svc$describe_application(
#'   ResourceGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_application
applicationinsights_describe_application <- function(ResourceGroupName) {
  op <- new_operation(
    name = "DescribeApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_application_input(ResourceGroupName = ResourceGroupName)
  output <- .applicationinsights$describe_application_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_application <- applicationinsights_describe_application

#' Describes a component and lists the resources that are grouped together
#' in a component
#'
#' @description
#' Describes a component and lists the resources that are grouped together
#' in a component.
#'
#' @usage
#' applicationinsights_describe_component(ResourceGroupName, ComponentName)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#'
#' @section Request syntax:
#' ```
#' svc$describe_component(
#'   ResourceGroupName = "string",
#'   ComponentName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_component
applicationinsights_describe_component <- function(ResourceGroupName, ComponentName) {
  op <- new_operation(
    name = "DescribeComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_component_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName)
  output <- .applicationinsights$describe_component_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_component <- applicationinsights_describe_component

#' Describes the monitoring configuration of the component
#'
#' @description
#' Describes the monitoring configuration of the component.
#'
#' @usage
#' applicationinsights_describe_component_configuration(ResourceGroupName,
#'   ComponentName)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#'
#' @section Request syntax:
#' ```
#' svc$describe_component_configuration(
#'   ResourceGroupName = "string",
#'   ComponentName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_component_configuration
applicationinsights_describe_component_configuration <- function(ResourceGroupName, ComponentName) {
  op <- new_operation(
    name = "DescribeComponentConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_component_configuration_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName)
  output <- .applicationinsights$describe_component_configuration_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_component_configuration <- applicationinsights_describe_component_configuration

#' Describes the recommended monitoring configuration of the component
#'
#' @description
#' Describes the recommended monitoring configuration of the component.
#'
#' @usage
#' applicationinsights_describe_component_configuration_recommendation(
#'   ResourceGroupName, ComponentName, Tier)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param Tier &#91;required&#93; The tier of the application component. Supported tiers include
#' `DOT_NET_CORE`, `DOT_NET_WORKER`, `DOT_NET_WEB`, `SQL_SERVER`, and
#' `DEFAULT`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_component_configuration_recommendation(
#'   ResourceGroupName = "string",
#'   ComponentName = "string",
#'   Tier = "CUSTOM"|"DEFAULT"|"DOT_NET_CORE"|"DOT_NET_WORKER"|"DOT_NET_WEB_TIER"|"DOT_NET_WEB"|"SQL_SERVER"|"SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP"|"MYSQL"|"POSTGRESQL"|"JAVA_JMX"|"ORACLE"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_component_configuration_recommendation
applicationinsights_describe_component_configuration_recommendation <- function(ResourceGroupName, ComponentName, Tier) {
  op <- new_operation(
    name = "DescribeComponentConfigurationRecommendation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_component_configuration_recommendation_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, Tier = Tier)
  output <- .applicationinsights$describe_component_configuration_recommendation_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_component_configuration_recommendation <- applicationinsights_describe_component_configuration_recommendation

#' Describe a specific log pattern from a LogPatternSet
#'
#' @description
#' Describe a specific log pattern from a `LogPatternSet`.
#'
#' @usage
#' applicationinsights_describe_log_pattern(ResourceGroupName,
#'   PatternSetName, PatternName)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param PatternSetName &#91;required&#93; The name of the log pattern set.
#' @param PatternName &#91;required&#93; The name of the log pattern.
#'
#' @section Request syntax:
#' ```
#' svc$describe_log_pattern(
#'   ResourceGroupName = "string",
#'   PatternSetName = "string",
#'   PatternName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_log_pattern
applicationinsights_describe_log_pattern <- function(ResourceGroupName, PatternSetName, PatternName) {
  op <- new_operation(
    name = "DescribeLogPattern",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_log_pattern_input(ResourceGroupName = ResourceGroupName, PatternSetName = PatternSetName, PatternName = PatternName)
  output <- .applicationinsights$describe_log_pattern_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_log_pattern <- applicationinsights_describe_log_pattern

#' Describes an anomaly or error with the application
#'
#' @description
#' Describes an anomaly or error with the application.
#'
#' @usage
#' applicationinsights_describe_observation(ObservationId)
#'
#' @param ObservationId &#91;required&#93; The ID of the observation.
#'
#' @section Request syntax:
#' ```
#' svc$describe_observation(
#'   ObservationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_observation
applicationinsights_describe_observation <- function(ObservationId) {
  op <- new_operation(
    name = "DescribeObservation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_observation_input(ObservationId = ObservationId)
  output <- .applicationinsights$describe_observation_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_observation <- applicationinsights_describe_observation

#' Describes an application problem
#'
#' @description
#' Describes an application problem.
#'
#' @usage
#' applicationinsights_describe_problem(ProblemId)
#'
#' @param ProblemId &#91;required&#93; The ID of the problem.
#'
#' @section Request syntax:
#' ```
#' svc$describe_problem(
#'   ProblemId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_problem
applicationinsights_describe_problem <- function(ProblemId) {
  op <- new_operation(
    name = "DescribeProblem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_problem_input(ProblemId = ProblemId)
  output <- .applicationinsights$describe_problem_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_problem <- applicationinsights_describe_problem

#' Describes the anomalies or errors associated with the problem
#'
#' @description
#' Describes the anomalies or errors associated with the problem.
#'
#' @usage
#' applicationinsights_describe_problem_observations(ProblemId)
#'
#' @param ProblemId &#91;required&#93; The ID of the problem.
#'
#' @section Request syntax:
#' ```
#' svc$describe_problem_observations(
#'   ProblemId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_describe_problem_observations
applicationinsights_describe_problem_observations <- function(ProblemId) {
  op <- new_operation(
    name = "DescribeProblemObservations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$describe_problem_observations_input(ProblemId = ProblemId)
  output <- .applicationinsights$describe_problem_observations_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$describe_problem_observations <- applicationinsights_describe_problem_observations

#' Lists the IDs of the applications that you are monitoring
#'
#' @description
#' Lists the IDs of the applications that you are monitoring.
#'
#' @usage
#' applicationinsights_list_applications(MaxResults, NextToken)
#'
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_applications(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_applications
applicationinsights_list_applications <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$list_applications_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationinsights$list_applications_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_applications <- applicationinsights_list_applications

#' Lists the auto-grouped, standalone, and custom components of the
#' application
#'
#' @description
#' Lists the auto-grouped, standalone, and custom components of the
#' application.
#'
#' @usage
#' applicationinsights_list_components(ResourceGroupName, MaxResults,
#'   NextToken)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_components(
#'   ResourceGroupName = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_components
applicationinsights_list_components <- function(ResourceGroupName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListComponents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$list_components_input(ResourceGroupName = ResourceGroupName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationinsights$list_components_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_components <- applicationinsights_list_components

#' Lists the INFO, WARN, and ERROR events for periodic configuration
#' updates performed by Application Insights
#'
#' @description
#' Lists the INFO, WARN, and ERROR events for periodic configuration
#' updates performed by Application Insights. Examples of events
#' represented are:
#' 
#' -   INFO: creating a new alarm or updating an alarm threshold.
#' 
#' -   WARN: alarm not created due to insufficient data points used to
#'     predict thresholds.
#' 
#' -   ERROR: alarm not created due to permission errors or exceeding
#'     quotas.
#'
#' @usage
#' applicationinsights_list_configuration_history(ResourceGroupName,
#'   StartTime, EndTime, EventStatus, MaxResults, NextToken)
#'
#' @param ResourceGroupName Resource group to which the application belongs.
#' @param StartTime The start time of the event.
#' @param EndTime The end time of the event.
#' @param EventStatus The status of the configuration update event. Possible values include
#' INFO, WARN, and ERROR.
#' @param MaxResults The maximum number of results returned by `ListConfigurationHistory` in
#' paginated output. When this parameter is used,
#' `ListConfigurationHistory` returns only `MaxResults` in a single page
#' along with a `NextToken` response element. The remaining results of the
#' initial request can be seen by sending another
#' `ListConfigurationHistory` request with the returned `NextToken` value.
#' If this parameter is not used, then `ListConfigurationHistory` returns
#' all results.
#' @param NextToken The `NextToken` value returned from a previous paginated
#' `ListConfigurationHistory` request where `MaxResults` was used and the
#' results exceeded the value of that parameter. Pagination continues from
#' the end of the previous results that returned the `NextToken` value.
#' This value is `null` when there are no more results to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_configuration_history(
#'   ResourceGroupName = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EventStatus = "INFO"|"WARN"|"ERROR",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_configuration_history
applicationinsights_list_configuration_history <- function(ResourceGroupName = NULL, StartTime = NULL, EndTime = NULL, EventStatus = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConfigurationHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$list_configuration_history_input(ResourceGroupName = ResourceGroupName, StartTime = StartTime, EndTime = EndTime, EventStatus = EventStatus, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationinsights$list_configuration_history_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_configuration_history <- applicationinsights_list_configuration_history

#' Lists the log pattern sets in the specific application
#'
#' @description
#' Lists the log pattern sets in the specific application.
#'
#' @usage
#' applicationinsights_list_log_pattern_sets(ResourceGroupName, MaxResults,
#'   NextToken)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_log_pattern_sets(
#'   ResourceGroupName = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_log_pattern_sets
applicationinsights_list_log_pattern_sets <- function(ResourceGroupName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListLogPatternSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$list_log_pattern_sets_input(ResourceGroupName = ResourceGroupName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationinsights$list_log_pattern_sets_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_log_pattern_sets <- applicationinsights_list_log_pattern_sets

#' Lists the log patterns in the specific log LogPatternSet
#'
#' @description
#' Lists the log patterns in the specific log `LogPatternSet`.
#'
#' @usage
#' applicationinsights_list_log_patterns(ResourceGroupName, PatternSetName,
#'   MaxResults, NextToken)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param PatternSetName The name of the log pattern set.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_log_patterns(
#'   ResourceGroupName = "string",
#'   PatternSetName = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_log_patterns
applicationinsights_list_log_patterns <- function(ResourceGroupName, PatternSetName = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListLogPatterns",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$list_log_patterns_input(ResourceGroupName = ResourceGroupName, PatternSetName = PatternSetName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationinsights$list_log_patterns_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_log_patterns <- applicationinsights_list_log_patterns

#' Lists the problems with your application
#'
#' @description
#' Lists the problems with your application.
#'
#' @usage
#' applicationinsights_list_problems(ResourceGroupName, StartTime, EndTime,
#'   MaxResults, NextToken)
#'
#' @param ResourceGroupName The name of the resource group.
#' @param StartTime The time when the problem was detected, in epoch seconds. If you don't
#' specify a time frame for the request, problems within the past seven
#' days are returned.
#' @param EndTime The time when the problem ended, in epoch seconds. If not specified,
#' problems within the past seven days are returned.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_problems(
#'   ResourceGroupName = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_problems
applicationinsights_list_problems <- function(ResourceGroupName = NULL, StartTime = NULL, EndTime = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListProblems",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$list_problems_input(ResourceGroupName = ResourceGroupName, StartTime = StartTime, EndTime = EndTime, MaxResults = MaxResults, NextToken = NextToken)
  output <- .applicationinsights$list_problems_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_problems <- applicationinsights_list_problems

#' Retrieve a list of the tags (keys and values) that are associated with a
#' specified application
#'
#' @description
#' Retrieve a list of the tags (keys and values) that are associated with a
#' specified application. A *tag* is a label that you optionally define and
#' associate with an application. Each tag consists of a required *tag key*
#' and an optional associated *tag value*. A tag key is a general label
#' that acts as a category for more specific tag values. A tag value acts
#' as a descriptor within a tag key.
#'
#' @usage
#' applicationinsights_list_tags_for_resource(ResourceARN)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the application that you want to
#' retrieve tag information for.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_list_tags_for_resource
applicationinsights_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .applicationinsights$list_tags_for_resource_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$list_tags_for_resource <- applicationinsights_list_tags_for_resource

#' Add one or more tags (keys and values) to a specified application
#'
#' @description
#' Add one or more tags (keys and values) to a specified application. A
#' *tag* is a label that you optionally define and associate with an
#' application. Tags can help you categorize and manage application in
#' different ways, such as by purpose, owner, environment, or other
#' criteria.
#' 
#' Each tag consists of a required *tag key* and an associated *tag value*,
#' both of which you define. A tag key is a general label that acts as a
#' category for more specific tag values. A tag value acts as a descriptor
#' within a tag key.
#'
#' @usage
#' applicationinsights_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the application that you want to add
#' one or more tags to.
#' @param Tags &#91;required&#93; A list of tags that to add to the application. A tag consists of a
#' required tag key (`Key`) and an associated tag value (`Value`). The
#' maximum length of a tag key is 128 characters. The maximum length of a
#' tag value is 256 characters.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_tag_resource
applicationinsights_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .applicationinsights$tag_resource_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$tag_resource <- applicationinsights_tag_resource

#' Remove one or more tags (keys and values) from a specified application
#'
#' @description
#' Remove one or more tags (keys and values) from a specified application.
#'
#' @usage
#' applicationinsights_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the application that you want to
#' remove one or more tags from.
#' @param TagKeys &#91;required&#93; The tags (tag keys) that you want to remove from the resource. When you
#' specify a tag key, the action removes both that key and its associated
#' tag value.
#' 
#' To remove more than one tag from the application, append the `TagKeys`
#' parameter and argument for each additional tag to remove, separated by
#' an ampersand.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_untag_resource
applicationinsights_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .applicationinsights$untag_resource_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$untag_resource <- applicationinsights_untag_resource

#' Updates the application
#'
#' @description
#' Updates the application.
#'
#' @usage
#' applicationinsights_update_application(ResourceGroupName,
#'   OpsCenterEnabled, CWEMonitorEnabled, OpsItemSNSTopicArn, RemoveSNSTopic)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param OpsCenterEnabled When set to `true`, creates opsItems for any problems detected on an
#' application.
#' @param CWEMonitorEnabled Indicates whether Application Insights can listen to CloudWatch events
#' for the application resources, such as `instance terminated`,
#' `failed deployment`, and others.
#' @param OpsItemSNSTopicArn The SNS topic provided to Application Insights that is associated to the
#' created opsItem. Allows you to receive notifications for updates to the
#' opsItem.
#' @param RemoveSNSTopic Disassociates the SNS topic from the opsItem created for detected
#' problems.
#'
#' @section Request syntax:
#' ```
#' svc$update_application(
#'   ResourceGroupName = "string",
#'   OpsCenterEnabled = TRUE|FALSE,
#'   CWEMonitorEnabled = TRUE|FALSE,
#'   OpsItemSNSTopicArn = "string",
#'   RemoveSNSTopic = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_update_application
applicationinsights_update_application <- function(ResourceGroupName, OpsCenterEnabled = NULL, CWEMonitorEnabled = NULL, OpsItemSNSTopicArn = NULL, RemoveSNSTopic = NULL) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$update_application_input(ResourceGroupName = ResourceGroupName, OpsCenterEnabled = OpsCenterEnabled, CWEMonitorEnabled = CWEMonitorEnabled, OpsItemSNSTopicArn = OpsItemSNSTopicArn, RemoveSNSTopic = RemoveSNSTopic)
  output <- .applicationinsights$update_application_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$update_application <- applicationinsights_update_application

#' Updates the custom component name and/or the list of resources that make
#' up the component
#'
#' @description
#' Updates the custom component name and/or the list of resources that make
#' up the component.
#'
#' @usage
#' applicationinsights_update_component(ResourceGroupName, ComponentName,
#'   NewComponentName, ResourceList)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param NewComponentName The new name of the component.
#' @param ResourceList The list of resource ARNs that belong to the component.
#'
#' @section Request syntax:
#' ```
#' svc$update_component(
#'   ResourceGroupName = "string",
#'   ComponentName = "string",
#'   NewComponentName = "string",
#'   ResourceList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_update_component
applicationinsights_update_component <- function(ResourceGroupName, ComponentName, NewComponentName = NULL, ResourceList = NULL) {
  op <- new_operation(
    name = "UpdateComponent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$update_component_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, NewComponentName = NewComponentName, ResourceList = ResourceList)
  output <- .applicationinsights$update_component_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$update_component <- applicationinsights_update_component

#' Updates the monitoring configurations for the component
#'
#' @description
#' Updates the monitoring configurations for the component. The
#' configuration input parameter is an escaped JSON of the configuration
#' and should match the schema of what is returned by
#' `DescribeComponentConfigurationRecommendation`.
#'
#' @usage
#' applicationinsights_update_component_configuration(ResourceGroupName,
#'   ComponentName, Monitor, Tier, ComponentConfiguration)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param ComponentName &#91;required&#93; The name of the component.
#' @param Monitor Indicates whether the application component is monitored.
#' @param Tier The tier of the application component. Supported tiers include
#' `DOT_NET_WORKER`, `DOT_NET_WEB`, `DOT_NET_CORE`, `SQL_SERVER`, and
#' `DEFAULT`.
#' @param ComponentConfiguration The configuration settings of the component. The value is the escaped
#' JSON of the configuration. For more information about the JSON format,
#' see [Working with
#' JSON](https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html).
#' You can send a request to `DescribeComponentConfigurationRecommendation`
#' to see the recommended configuration for a component. For the complete
#' format of the component configuration file, see [Component
#' Configuration](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html).
#'
#' @section Request syntax:
#' ```
#' svc$update_component_configuration(
#'   ResourceGroupName = "string",
#'   ComponentName = "string",
#'   Monitor = TRUE|FALSE,
#'   Tier = "CUSTOM"|"DEFAULT"|"DOT_NET_CORE"|"DOT_NET_WORKER"|"DOT_NET_WEB_TIER"|"DOT_NET_WEB"|"SQL_SERVER"|"SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP"|"MYSQL"|"POSTGRESQL"|"JAVA_JMX"|"ORACLE",
#'   ComponentConfiguration = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_update_component_configuration
applicationinsights_update_component_configuration <- function(ResourceGroupName, ComponentName, Monitor = NULL, Tier = NULL, ComponentConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateComponentConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$update_component_configuration_input(ResourceGroupName = ResourceGroupName, ComponentName = ComponentName, Monitor = Monitor, Tier = Tier, ComponentConfiguration = ComponentConfiguration)
  output <- .applicationinsights$update_component_configuration_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$update_component_configuration <- applicationinsights_update_component_configuration

#' Adds a log pattern to a LogPatternSet
#'
#' @description
#' Adds a log pattern to a `LogPatternSet`.
#'
#' @usage
#' applicationinsights_update_log_pattern(ResourceGroupName,
#'   PatternSetName, PatternName, Pattern, Rank)
#'
#' @param ResourceGroupName &#91;required&#93; The name of the resource group.
#' @param PatternSetName &#91;required&#93; The name of the log pattern set.
#' @param PatternName &#91;required&#93; The name of the log pattern.
#' @param Pattern The log pattern. The pattern must be DFA compatible. Patterns that
#' utilize forward lookahead or backreference constructions are not
#' supported.
#' @param Rank Rank of the log pattern. Must be a value between `1` and `1,000,000`.
#' The patterns are sorted by rank, so we recommend that you set your
#' highest priority patterns with the lowest rank. A pattern of rank `1`
#' will be the first to get matched to a log line. A pattern of rank
#' `1,000,000` will be last to get matched. When you configure custom log
#' patterns from the console, a `Low` severity pattern translates to a
#' `750,000` rank. A `Medium` severity pattern translates to a `500,000`
#' rank. And a `High` severity pattern translates to a `250,000` rank. Rank
#' values less than `1` or greater than `1,000,000` are reserved for
#' AWS-provided patterns.
#'
#' @section Request syntax:
#' ```
#' svc$update_log_pattern(
#'   ResourceGroupName = "string",
#'   PatternSetName = "string",
#'   PatternName = "string",
#'   Pattern = "string",
#'   Rank = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname applicationinsights_update_log_pattern
applicationinsights_update_log_pattern <- function(ResourceGroupName, PatternSetName, PatternName, Pattern = NULL, Rank = NULL) {
  op <- new_operation(
    name = "UpdateLogPattern",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .applicationinsights$update_log_pattern_input(ResourceGroupName = ResourceGroupName, PatternSetName = PatternSetName, PatternName = PatternName, Pattern = Pattern, Rank = Rank)
  output <- .applicationinsights$update_log_pattern_output()
  config <- get_config()
  svc <- .applicationinsights$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.applicationinsights$operations$update_log_pattern <- applicationinsights_update_log_pattern
