# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudformation_service.R
NULL

#' Cancels an update on the specified stack
#'
#' @description
#' Cancels an update on the specified stack. If the call completes
#' successfully, the stack rolls back the update and reverts to the
#' previous stack configuration.
#' 
#' You can cancel only stacks that are in the UPDATE\\_IN\\_PROGRESS state.
#'
#' @usage
#' cloudformation_cancel_update_stack(StackName, ClientRequestToken)
#'
#' @param StackName &#91;required&#93; The name or the unique stack ID that is associated with the stack.
#' @param ClientRequestToken A unique identifier for this `CancelUpdateStack` request. Specify this
#' token if you plan to retry requests so that AWS CloudFormation knows
#' that you're not attempting to cancel an update on a stack with the same
#' name. You might retry `CancelUpdateStack` requests to ensure that AWS
#' CloudFormation successfully received them.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_update_stack(
#'   StackName = "string",
#'   ClientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_cancel_update_stack
cloudformation_cancel_update_stack <- function(StackName, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "CancelUpdateStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$cancel_update_stack_input(StackName = StackName, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$cancel_update_stack_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$cancel_update_stack <- cloudformation_cancel_update_stack

#' For a specified stack that is in the UPDATE_ROLLBACK_FAILED state,
#' continues rolling it back to the UPDATE_ROLLBACK_COMPLETE state
#'
#' @description
#' For a specified stack that is in the `UPDATE_ROLLBACK_FAILED` state,
#' continues rolling it back to the `UPDATE_ROLLBACK_COMPLETE` state.
#' Depending on the cause of the failure, you can manually [fix the
#' error](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed)
#' and continue the rollback. By continuing the rollback, you can return
#' your stack to a working state (the `UPDATE_ROLLBACK_COMPLETE` state),
#' and then try to update the stack again.
#' 
#' A stack goes into the `UPDATE_ROLLBACK_FAILED` state when AWS
#' CloudFormation cannot roll back all changes after a failed stack update.
#' For example, you might have a stack that is rolling back to an old
#' database instance that was deleted outside of AWS CloudFormation.
#' Because AWS CloudFormation doesn't know the database was deleted, it
#' assumes that the database instance still exists and attempts to roll
#' back to it, causing the update rollback to fail.
#'
#' @usage
#' cloudformation_continue_update_rollback(StackName, RoleARN,
#'   ResourcesToSkip, ClientRequestToken)
#'
#' @param StackName &#91;required&#93; The name or the unique ID of the stack that you want to continue rolling
#' back.
#' 
#' Don't specify the name of a nested stack (a stack that was created by
#' using the `AWS::CloudFormation::Stack` resource). Instead, use this
#' operation on the parent stack (the stack that contains the
#' `AWS::CloudFormation::Stack` resource).
#' @param RoleARN The Amazon Resource Name (ARN) of an AWS Identity and Access Management
#' (IAM) role that AWS CloudFormation assumes to roll back the stack. AWS
#' CloudFormation uses the role's credentials to make calls on your behalf.
#' AWS CloudFormation always uses this role for all future operations on
#' the stack. As long as users have permission to operate on the stack, AWS
#' CloudFormation uses this role even if the users don't have permission to
#' pass it. Ensure that the role grants least privilege.
#' 
#' If you don't specify a value, AWS CloudFormation uses the role that was
#' previously associated with the stack. If no role is available, AWS
#' CloudFormation uses a temporary session that is generated from your user
#' credentials.
#' @param ResourcesToSkip A list of the logical IDs of the resources that AWS CloudFormation skips
#' during the continue update rollback operation. You can specify only
#' resources that are in the `UPDATE_FAILED` state because a rollback
#' failed. You can't specify resources that are in the `UPDATE_FAILED`
#' state for other reasons, for example, because an update was cancelled.
#' To check why a resource update failed, use the DescribeStackResources
#' action, and view the resource status reason.
#' 
#' Specify this property to skip rolling back resources that AWS
#' CloudFormation can't successfully roll back. We recommend that you
#' [troubleshoot](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed)
#' resources before skipping them. AWS CloudFormation sets the status of
#' the specified resources to `UPDATE_COMPLETE` and continues to roll back
#' the stack. After the rollback is complete, the state of the skipped
#' resources will be inconsistent with the state of the resources in the
#' stack template. Before performing another stack update, you must update
#' the stack or resources to be consistent with each other. If you don't,
#' subsequent stack updates might fail, and the stack will become
#' unrecoverable.
#' 
#' Specify the minimum number of resources required to successfully roll
#' back your stack. For example, a failed resource update might cause
#' dependent resources to fail. In this case, it might not be necessary to
#' skip the dependent resources.
#' 
#' To skip resources that are part of nested stacks, use the following
#' format: `NestedStackName.ResourceLogicalID`. If you want to specify the
#' logical ID of a stack resource (`Type: AWS::CloudFormation::Stack`) in
#' the `ResourcesToSkip` list, then its corresponding embedded stack must
#' be in one of the following states: `DELETE_IN_PROGRESS`,
#' `DELETE_COMPLETE`, or `DELETE_FAILED`.
#' 
#' Don't confuse a child stack's name with its corresponding logical ID
#' defined in the parent stack. For an example of a continue update
#' rollback operation with nested stacks, see [Using ResourcesToSkip to
#' recover a nested stacks
#' hierarchy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html#nested-stacks).
#' @param ClientRequestToken A unique identifier for this `ContinueUpdateRollback` request. Specify
#' this token if you plan to retry requests so that AWS CloudFormation
#' knows that you're not attempting to continue the rollback to a stack
#' with the same name. You might retry `ContinueUpdateRollback` requests to
#' ensure that AWS CloudFormation successfully received them.
#'
#' @section Request syntax:
#' ```
#' svc$continue_update_rollback(
#'   StackName = "string",
#'   RoleARN = "string",
#'   ResourcesToSkip = list(
#'     "string"
#'   ),
#'   ClientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_continue_update_rollback
cloudformation_continue_update_rollback <- function(StackName, RoleARN = NULL, ResourcesToSkip = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "ContinueUpdateRollback",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$continue_update_rollback_input(StackName = StackName, RoleARN = RoleARN, ResourcesToSkip = ResourcesToSkip, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$continue_update_rollback_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$continue_update_rollback <- cloudformation_continue_update_rollback

#' Creates a list of changes that will be applied to a stack so that you
#' can review the changes before executing them
#'
#' @description
#' Creates a list of changes that will be applied to a stack so that you
#' can review the changes before executing them. You can create a change
#' set for a stack that doesn't exist or an existing stack. If you create a
#' change set for a stack that doesn't exist, the change set shows all of
#' the resources that AWS CloudFormation will create. If you create a
#' change set for an existing stack, AWS CloudFormation compares the
#' stack's information with the information that you submit in the change
#' set and lists the differences. Use change sets to understand which
#' resources AWS CloudFormation will create or change, and how it will
#' change resources in an existing stack, before you create or update a
#' stack.
#' 
#' To create a change set for a stack that doesn't exist, for the
#' `ChangeSetType` parameter, specify `CREATE`. To create a change set for
#' an existing stack, specify `UPDATE` for the `ChangeSetType` parameter.
#' To create a change set for an import operation, specify `IMPORT` for the
#' `ChangeSetType` parameter. After the `CreateChangeSet` call successfully
#' completes, AWS CloudFormation starts creating the change set. To check
#' the status of the change set or to review it, use the DescribeChangeSet
#' action.
#' 
#' When you are satisfied with the changes the change set will make,
#' execute the change set by using the ExecuteChangeSet action. AWS
#' CloudFormation doesn't make changes until you execute the change set.
#' 
#' To create a change set for the entire stack hierachy, set
#' `IncludeNestedStacks` to `True`.
#'
#' @usage
#' cloudformation_create_change_set(StackName, TemplateBody, TemplateURL,
#'   UsePreviousTemplate, Parameters, Capabilities, ResourceTypes, RoleARN,
#'   RollbackConfiguration, NotificationARNs, Tags, ChangeSetName,
#'   ClientToken, Description, ChangeSetType, ResourcesToImport,
#'   IncludeNestedStacks)
#'
#' @param StackName &#91;required&#93; The name or the unique ID of the stack for which you are creating a
#' change set. AWS CloudFormation generates the change set by comparing
#' this stack's information with the information that you submit, such as a
#' modified template or different parameter input values.
#' @param TemplateBody A structure that contains the body of the revised template, with a
#' minimum length of 1 byte and a maximum length of 51,200 bytes. AWS
#' CloudFormation generates the change set by comparing this template with
#' the template of the stack that you specified.
#' 
#' Conditional: You must specify only `TemplateBody` or `TemplateURL`.
#' @param TemplateURL The location of the file that contains the revised template. The URL
#' must point to a template (max size: 460,800 bytes) that is located in an
#' S3 bucket. AWS CloudFormation generates the change set by comparing this
#' template with the stack that you specified.
#' 
#' Conditional: You must specify only `TemplateBody` or `TemplateURL`.
#' @param UsePreviousTemplate Whether to reuse the template that is associated with the stack to
#' create the change set.
#' @param Parameters A list of `Parameter` structures that specify input parameters for the
#' change set. For more information, see the Parameter data type.
#' @param Capabilities In some cases, you must explicitly acknowledge that your stack template
#' contains certain capabilities in order for AWS CloudFormation to create
#' the stack.
#' 
#' -   `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`
#' 
#'     Some stack templates might include resources that can affect
#'     permissions in your AWS account; for example, by creating new AWS
#'     Identity and Access Management (IAM) users. For those stacks, you
#'     must explicitly acknowledge this by specifying one of these
#'     capabilities.
#' 
#'     The following IAM resources require you to specify either the
#'     `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
#' 
#'     -   If you have IAM resources, you can specify either capability.
#' 
#'     -   If you have IAM resources with custom names, you *must* specify
#'         `CAPABILITY_NAMED_IAM`.
#' 
#'     -   If you don't specify either of these capabilities, AWS
#'         CloudFormation returns an `InsufficientCapabilities` error.
#' 
#'     If your stack template contains these resources, we recommend that
#'     you review all permissions associated with them and edit their
#'     permissions if necessary.
#' 
#'     -   [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
#' 
#'     -   [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
#' 
#'     -   [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
#' 
#'     -   [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
#' 
#'     -   [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
#' 
#'     -   [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
#' 
#'     -   [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
#' 
#'     For more information, see [Acknowledging IAM Resources in AWS
#'     CloudFormation
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
#' 
#' -   `CAPABILITY_AUTO_EXPAND`
#' 
#'     Some template contain macros. Macros perform custom processing on
#'     templates; this can include simple actions like find-and-replace
#'     operations, all the way to extensive transformations of entire
#'     templates. Because of this, users typically create a change set from
#'     the processed template, so that they can review the changes
#'     resulting from the macros before actually creating the stack. If
#'     your stack template contains one or more macros, and you choose to
#'     create a stack directly from the processed template, without first
#'     reviewing the resulting changes in a change set, you must
#'     acknowledge this capability. This includes the
#'     [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
#'     and
#'     [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
#'     transforms, which are macros hosted by AWS CloudFormation.
#' 
#'     This capacity does not apply to creating change sets, and specifying
#'     it when creating change sets has no effect.
#' 
#'     If you want to create a stack from a stack template that contains
#'     macros *and* nested stacks, you must create or update the stack
#'     directly from the template using the CreateStack or UpdateStack
#'     action, and specifying this capability.
#' 
#'     For more information on macros, see [Using AWS CloudFormation Macros
#'     to Perform Custom Processing on
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
#' @param ResourceTypes The template resource types that you have permissions to work with if
#' you execute this change set, such as `AWS::EC2::Instance`,
#' `AWS::EC2::*`, or `Custom::MyCustomInstance`.
#' 
#' If the list of resource types doesn't include a resource type that
#' you're updating, the stack update fails. By default, AWS CloudFormation
#' grants permissions to all resource types. AWS Identity and Access
#' Management (IAM) uses this parameter for condition keys in IAM policies
#' for AWS CloudFormation. For more information, see [Controlling Access
#' with AWS Identity and Access
#' Management](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html)
#' in the AWS CloudFormation User Guide.
#' @param RoleARN The Amazon Resource Name (ARN) of an AWS Identity and Access Management
#' (IAM) role that AWS CloudFormation assumes when executing the change
#' set. AWS CloudFormation uses the role's credentials to make calls on
#' your behalf. AWS CloudFormation uses this role for all future operations
#' on the stack. As long as users have permission to operate on the stack,
#' AWS CloudFormation uses this role even if the users don't have
#' permission to pass it. Ensure that the role grants least privilege.
#' 
#' If you don't specify a value, AWS CloudFormation uses the role that was
#' previously associated with the stack. If no role is available, AWS
#' CloudFormation uses a temporary session that is generated from your user
#' credentials.
#' @param RollbackConfiguration The rollback triggers for AWS CloudFormation to monitor during stack
#' creation and updating operations, and for the specified monitoring
#' period afterwards.
#' @param NotificationARNs The Amazon Resource Names (ARNs) of Amazon Simple Notification Service
#' (Amazon SNS) topics that AWS CloudFormation associates with the stack.
#' To remove all associated notification topics, specify an empty list.
#' @param Tags Key-value pairs to associate with this stack. AWS CloudFormation also
#' propagates these tags to resources in the stack. You can specify a
#' maximum of 50 tags.
#' @param ChangeSetName &#91;required&#93; The name of the change set. The name must be unique among all change
#' sets that are associated with the specified stack.
#' 
#' A change set name can contain only alphanumeric, case sensitive
#' characters and hyphens. It must start with an alphabetic character and
#' cannot exceed 128 characters.
#' @param ClientToken A unique identifier for this `CreateChangeSet` request. Specify this
#' token if you plan to retry requests so that AWS CloudFormation knows
#' that you're not attempting to create another change set with the same
#' name. You might retry `CreateChangeSet` requests to ensure that AWS
#' CloudFormation successfully received them.
#' @param Description A description to help you identify this change set.
#' @param ChangeSetType The type of change set operation. To create a change set for a new
#' stack, specify `CREATE`. To create a change set for an existing stack,
#' specify `UPDATE`. To create a change set for an import operation,
#' specify `IMPORT`.
#' 
#' If you create a change set for a new stack, AWS Cloudformation creates a
#' stack with a unique stack ID, but no template or resources. The stack
#' will be in the
#' [`REVIEW_IN_PROGRESS`](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-describing-stacks.html#d0e11995)
#' state until you execute the change set.
#' 
#' By default, AWS CloudFormation specifies `UPDATE`. You can't use the
#' `UPDATE` type to create a change set for a new stack or the `CREATE`
#' type to create a change set for an existing stack.
#' @param ResourcesToImport The resources to import into your stack.
#' @param IncludeNestedStacks Creates a change set for the all nested stacks specified in the
#' template. The default behavior of this action is set to `False`. To
#' include nested sets in a change set, specify `True`.
#'
#' @section Request syntax:
#' ```
#' svc$create_change_set(
#'   StackName = "string",
#'   TemplateBody = "string",
#'   TemplateURL = "string",
#'   UsePreviousTemplate = TRUE|FALSE,
#'   Parameters = list(
#'     list(
#'       ParameterKey = "string",
#'       ParameterValue = "string",
#'       UsePreviousValue = TRUE|FALSE,
#'       ResolvedValue = "string"
#'     )
#'   ),
#'   Capabilities = list(
#'     "CAPABILITY_IAM"|"CAPABILITY_NAMED_IAM"|"CAPABILITY_AUTO_EXPAND"
#'   ),
#'   ResourceTypes = list(
#'     "string"
#'   ),
#'   RoleARN = "string",
#'   RollbackConfiguration = list(
#'     RollbackTriggers = list(
#'       list(
#'         Arn = "string",
#'         Type = "string"
#'       )
#'     ),
#'     MonitoringTimeInMinutes = 123
#'   ),
#'   NotificationARNs = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ChangeSetName = "string",
#'   ClientToken = "string",
#'   Description = "string",
#'   ChangeSetType = "CREATE"|"UPDATE"|"IMPORT",
#'   ResourcesToImport = list(
#'     list(
#'       ResourceType = "string",
#'       LogicalResourceId = "string",
#'       ResourceIdentifier = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   IncludeNestedStacks = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_create_change_set
cloudformation_create_change_set <- function(StackName, TemplateBody = NULL, TemplateURL = NULL, UsePreviousTemplate = NULL, Parameters = NULL, Capabilities = NULL, ResourceTypes = NULL, RoleARN = NULL, RollbackConfiguration = NULL, NotificationARNs = NULL, Tags = NULL, ChangeSetName, ClientToken = NULL, Description = NULL, ChangeSetType = NULL, ResourcesToImport = NULL, IncludeNestedStacks = NULL) {
  op <- new_operation(
    name = "CreateChangeSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$create_change_set_input(StackName = StackName, TemplateBody = TemplateBody, TemplateURL = TemplateURL, UsePreviousTemplate = UsePreviousTemplate, Parameters = Parameters, Capabilities = Capabilities, ResourceTypes = ResourceTypes, RoleARN = RoleARN, RollbackConfiguration = RollbackConfiguration, NotificationARNs = NotificationARNs, Tags = Tags, ChangeSetName = ChangeSetName, ClientToken = ClientToken, Description = Description, ChangeSetType = ChangeSetType, ResourcesToImport = ResourcesToImport, IncludeNestedStacks = IncludeNestedStacks)
  output <- .cloudformation$create_change_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$create_change_set <- cloudformation_create_change_set

#' Creates a stack as specified in the template
#'
#' @description
#' Creates a stack as specified in the template. After the call completes
#' successfully, the stack creation starts. You can check the status of the
#' stack via the DescribeStacks API.
#'
#' @usage
#' cloudformation_create_stack(StackName, TemplateBody, TemplateURL,
#'   Parameters, DisableRollback, RollbackConfiguration, TimeoutInMinutes,
#'   NotificationARNs, Capabilities, ResourceTypes, RoleARN, OnFailure,
#'   StackPolicyBody, StackPolicyURL, Tags, ClientRequestToken,
#'   EnableTerminationProtection)
#'
#' @param StackName &#91;required&#93; The name that is associated with the stack. The name must be unique in
#' the Region in which you are creating the stack.
#' 
#' A stack name can contain only alphanumeric characters (case sensitive)
#' and hyphens. It must start with an alphabetic character and cannot be
#' longer than 128 characters.
#' @param TemplateBody Structure containing the template body with a minimum length of 1 byte
#' and a maximum length of 51,200 bytes. For more information, go to
#' [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.
#' 
#' Conditional: You must specify either the `TemplateBody` or the
#' `TemplateURL` parameter, but not both.
#' @param TemplateURL Location of file containing the template body. The URL must point to a
#' template (max size: 460,800 bytes) that is located in an Amazon S3
#' bucket. For more information, go to the [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.
#' 
#' Conditional: You must specify either the `TemplateBody` or the
#' `TemplateURL` parameter, but not both.
#' @param Parameters A list of `Parameter` structures that specify input parameters for the
#' stack. For more information, see the
#' [Parameter](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
#' data type.
#' @param DisableRollback Set to `true` to disable rollback of the stack if stack creation failed.
#' You can specify either `DisableRollback` or `OnFailure`, but not both.
#' 
#' Default: `false`
#' @param RollbackConfiguration The rollback triggers for AWS CloudFormation to monitor during stack
#' creation and updating operations, and for the specified monitoring
#' period afterwards.
#' @param TimeoutInMinutes The amount of time that can pass before the stack status becomes
#' CREATE\\_FAILED; if `DisableRollback` is not set or is set to `false`,
#' the stack will be rolled back.
#' @param NotificationARNs The Simple Notification Service (SNS) topic ARNs to publish stack
#' related events. You can find your SNS topic ARNs using the SNS console
#' or your Command Line Interface (CLI).
#' @param Capabilities In some cases, you must explicitly acknowledge that your stack template
#' contains certain capabilities in order for AWS CloudFormation to create
#' the stack.
#' 
#' -   `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`
#' 
#'     Some stack templates might include resources that can affect
#'     permissions in your AWS account; for example, by creating new AWS
#'     Identity and Access Management (IAM) users. For those stacks, you
#'     must explicitly acknowledge this by specifying one of these
#'     capabilities.
#' 
#'     The following IAM resources require you to specify either the
#'     `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
#' 
#'     -   If you have IAM resources, you can specify either capability.
#' 
#'     -   If you have IAM resources with custom names, you *must* specify
#'         `CAPABILITY_NAMED_IAM`.
#' 
#'     -   If you don't specify either of these capabilities, AWS
#'         CloudFormation returns an `InsufficientCapabilities` error.
#' 
#'     If your stack template contains these resources, we recommend that
#'     you review all permissions associated with them and edit their
#'     permissions if necessary.
#' 
#'     -   [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
#' 
#'     -   [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
#' 
#'     -   [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
#' 
#'     -   [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
#' 
#'     -   [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
#' 
#'     -   [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
#' 
#'     -   [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
#' 
#'     For more information, see [Acknowledging IAM Resources in AWS
#'     CloudFormation
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
#' 
#' -   `CAPABILITY_AUTO_EXPAND`
#' 
#'     Some template contain macros. Macros perform custom processing on
#'     templates; this can include simple actions like find-and-replace
#'     operations, all the way to extensive transformations of entire
#'     templates. Because of this, users typically create a change set from
#'     the processed template, so that they can review the changes
#'     resulting from the macros before actually creating the stack. If
#'     your stack template contains one or more macros, and you choose to
#'     create a stack directly from the processed template, without first
#'     reviewing the resulting changes in a change set, you must
#'     acknowledge this capability. This includes the
#'     [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
#'     and
#'     [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
#'     transforms, which are macros hosted by AWS CloudFormation.
#' 
#'     If you want to create a stack from a stack template that contains
#'     macros *and* nested stacks, you must create the stack directly from
#'     the template using this capability.
#' 
#'     You should only create stacks directly from a stack template that
#'     contains macros if you know what processing the macro performs.
#' 
#'     Each macro relies on an underlying Lambda service function for
#'     processing stack templates. Be aware that the Lambda function owner
#'     can update the function operation without AWS CloudFormation being
#'     notified.
#' 
#'     For more information, see [Using AWS CloudFormation Macros to
#'     Perform Custom Processing on
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
#' @param ResourceTypes The template resource types that you have permissions to work with for
#' this create stack action, such as `AWS::EC2::Instance`, `AWS::EC2::*`,
#' or `Custom::MyCustomInstance`. Use the following syntax to describe
#' template resource types: `AWS::*` (for all AWS resource), `Custom::*`
#' (for all custom resources), `Custom::<i>logical_ID</i> ` (for a specific
#' custom resource), `AWS::<i>service_name</i>::*` (for all resources of a
#' particular AWS service), and
#' `AWS::<i>service_name</i>::<i>resource_logical_ID</i> ` (for a specific
#' AWS resource).
#' 
#' If the list of resource types doesn't include a resource that you're
#' creating, the stack creation fails. By default, AWS CloudFormation
#' grants permissions to all resource types. AWS Identity and Access
#' Management (IAM) uses this parameter for AWS CloudFormation-specific
#' condition keys in IAM policies. For more information, see [Controlling
#' Access with AWS Identity and Access
#' Management](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html).
#' @param RoleARN The Amazon Resource Name (ARN) of an AWS Identity and Access Management
#' (IAM) role that AWS CloudFormation assumes to create the stack. AWS
#' CloudFormation uses the role's credentials to make calls on your behalf.
#' AWS CloudFormation always uses this role for all future operations on
#' the stack. As long as users have permission to operate on the stack, AWS
#' CloudFormation uses this role even if the users don't have permission to
#' pass it. Ensure that the role grants least privilege.
#' 
#' If you don't specify a value, AWS CloudFormation uses the role that was
#' previously associated with the stack. If no role is available, AWS
#' CloudFormation uses a temporary session that is generated from your user
#' credentials.
#' @param OnFailure Determines what action will be taken if stack creation fails. This must
#' be one of: DO\\_NOTHING, ROLLBACK, or DELETE. You can specify either
#' `OnFailure` or `DisableRollback`, but not both.
#' 
#' Default: `ROLLBACK`
#' @param StackPolicyBody Structure containing the stack policy body. For more information, go to
#' [Prevent Updates to Stack
#' Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
#' in the *AWS CloudFormation User Guide*. You can specify either the
#' `StackPolicyBody` or the `StackPolicyURL` parameter, but not both.
#' @param StackPolicyURL Location of a file containing the stack policy. The URL must point to a
#' policy (maximum size: 16 KB) located in an S3 bucket in the same Region
#' as the stack. You can specify either the `StackPolicyBody` or the
#' `StackPolicyURL` parameter, but not both.
#' @param Tags Key-value pairs to associate with this stack. AWS CloudFormation also
#' propagates these tags to the resources created in the stack. A maximum
#' number of 50 tags can be specified.
#' @param ClientRequestToken A unique identifier for this `CreateStack` request. Specify this token
#' if you plan to retry requests so that AWS CloudFormation knows that
#' you're not attempting to create a stack with the same name. You might
#' retry `CreateStack` requests to ensure that AWS CloudFormation
#' successfully received them.
#' 
#' All events triggered by a given stack operation are assigned the same
#' client request token, which you can use to track operations. For
#' example, if you execute a `CreateStack` operation with the token
#' `token1`, then all the `StackEvents` generated by that operation will
#' have `ClientRequestToken` set as `token1`.
#' 
#' In the console, stack operations display the client request token on the
#' Events tab. Stack operations that are initiated from the console use the
#' token format *Console-StackOperation-ID*, which helps you easily
#' identify the stack operation . For example, if you create a stack using
#' the console, each stack event would be assigned the same token in the
#' following format:
#' `Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002`.
#' @param EnableTerminationProtection Whether to enable termination protection on the specified stack. If a
#' user attempts to delete a stack with termination protection enabled, the
#' operation fails and the stack remains unchanged. For more information,
#' see [Protecting a Stack From Being
#' Deleted](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
#' in the *AWS CloudFormation User Guide*. Termination protection is
#' disabled on stacks by default.
#' 
#' For [nested
#' stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
#' termination protection is set on the root stack and cannot be changed
#' directly on the nested stack.
#'
#' @section Request syntax:
#' ```
#' svc$create_stack(
#'   StackName = "string",
#'   TemplateBody = "string",
#'   TemplateURL = "string",
#'   Parameters = list(
#'     list(
#'       ParameterKey = "string",
#'       ParameterValue = "string",
#'       UsePreviousValue = TRUE|FALSE,
#'       ResolvedValue = "string"
#'     )
#'   ),
#'   DisableRollback = TRUE|FALSE,
#'   RollbackConfiguration = list(
#'     RollbackTriggers = list(
#'       list(
#'         Arn = "string",
#'         Type = "string"
#'       )
#'     ),
#'     MonitoringTimeInMinutes = 123
#'   ),
#'   TimeoutInMinutes = 123,
#'   NotificationARNs = list(
#'     "string"
#'   ),
#'   Capabilities = list(
#'     "CAPABILITY_IAM"|"CAPABILITY_NAMED_IAM"|"CAPABILITY_AUTO_EXPAND"
#'   ),
#'   ResourceTypes = list(
#'     "string"
#'   ),
#'   RoleARN = "string",
#'   OnFailure = "DO_NOTHING"|"ROLLBACK"|"DELETE",
#'   StackPolicyBody = "string",
#'   StackPolicyURL = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ClientRequestToken = "string",
#'   EnableTerminationProtection = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_create_stack
cloudformation_create_stack <- function(StackName, TemplateBody = NULL, TemplateURL = NULL, Parameters = NULL, DisableRollback = NULL, RollbackConfiguration = NULL, TimeoutInMinutes = NULL, NotificationARNs = NULL, Capabilities = NULL, ResourceTypes = NULL, RoleARN = NULL, OnFailure = NULL, StackPolicyBody = NULL, StackPolicyURL = NULL, Tags = NULL, ClientRequestToken = NULL, EnableTerminationProtection = NULL) {
  op <- new_operation(
    name = "CreateStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$create_stack_input(StackName = StackName, TemplateBody = TemplateBody, TemplateURL = TemplateURL, Parameters = Parameters, DisableRollback = DisableRollback, RollbackConfiguration = RollbackConfiguration, TimeoutInMinutes = TimeoutInMinutes, NotificationARNs = NotificationARNs, Capabilities = Capabilities, ResourceTypes = ResourceTypes, RoleARN = RoleARN, OnFailure = OnFailure, StackPolicyBody = StackPolicyBody, StackPolicyURL = StackPolicyURL, Tags = Tags, ClientRequestToken = ClientRequestToken, EnableTerminationProtection = EnableTerminationProtection)
  output <- .cloudformation$create_stack_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$create_stack <- cloudformation_create_stack

#' Creates stack instances for the specified accounts, within the specified
#' Regions
#'
#' @description
#' Creates stack instances for the specified accounts, within the specified
#' Regions. A stack instance refers to a stack in a specific account and
#' Region. You must specify at least one value for either `Accounts` or
#' `DeploymentTargets`, and you must specify at least one value for
#' `Regions`.
#'
#' @usage
#' cloudformation_create_stack_instances(StackSetName, Accounts,
#'   DeploymentTargets, Regions, ParameterOverrides, OperationPreferences,
#'   OperationId)
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to create stack
#' instances from.
#' @param Accounts \[`Self-managed` permissions\] The names of one or more AWS accounts
#' that you want to create stack instances in the specified Region(s) for.
#' 
#' You can specify `Accounts` or `DeploymentTargets`, but not both.
#' @param DeploymentTargets \[`Service-managed` permissions\] The AWS Organizations accounts for
#' which to create stack instances in the specified Regions.
#' 
#' You can specify `Accounts` or `DeploymentTargets`, but not both.
#' @param Regions &#91;required&#93; The names of one or more Regions where you want to create stack
#' instances using the specified AWS account(s).
#' @param ParameterOverrides A list of stack set parameters whose values you want to override in the
#' selected stack instances.
#' 
#' Any overridden parameter values will be applied to all stack instances
#' in the specified accounts and Regions. When specifying parameters and
#' their values, be aware of how AWS CloudFormation sets parameter values
#' during stack instance operations:
#' 
#' -   To override the current value for a parameter, include the parameter
#'     and specify its value.
#' 
#' -   To leave a parameter set to its present value, you can do one of the
#'     following:
#' 
#'     -   Do not include the parameter in the list.
#' 
#'     -   Include the parameter and specify `UsePreviousValue` as `true`.
#'         (You cannot specify both a value and set `UsePreviousValue` to
#'         `true`.)
#' 
#' -   To set all overridden parameter back to the values specified in the
#'     stack set, specify a parameter list but do not include any
#'     parameters.
#' 
#' -   To leave all parameters set to their present values, do not specify
#'     this property at all.
#' 
#' During stack set updates, any parameter values overridden for a stack
#' instance are not updated, but retain their overridden value.
#' 
#' You can only override the parameter *values* that are specified in the
#' stack set; to add or delete a parameter itself, use
#' [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
#' to update the stack set template.
#' @param OperationPreferences Preferences for how AWS CloudFormation performs this stack set
#' operation.
#' @param OperationId The unique identifier for this stack set operation.
#' 
#' The operation ID also functions as an idempotency token, to ensure that
#' AWS CloudFormation performs the stack set operation only once, even if
#' you retry the request multiple times. You might retry stack set
#' operation requests to ensure that AWS CloudFormation successfully
#' received them.
#' 
#' If you don't specify an operation ID, the SDK generates one
#' automatically.
#' 
#' Repeating this stack set operation with a new operation ID retries all
#' stack instances whose status is `OUTDATED`.
#'
#' @section Request syntax:
#' ```
#' svc$create_stack_instances(
#'   StackSetName = "string",
#'   Accounts = list(
#'     "string"
#'   ),
#'   DeploymentTargets = list(
#'     Accounts = list(
#'       "string"
#'     ),
#'     OrganizationalUnitIds = list(
#'       "string"
#'     )
#'   ),
#'   Regions = list(
#'     "string"
#'   ),
#'   ParameterOverrides = list(
#'     list(
#'       ParameterKey = "string",
#'       ParameterValue = "string",
#'       UsePreviousValue = TRUE|FALSE,
#'       ResolvedValue = "string"
#'     )
#'   ),
#'   OperationPreferences = list(
#'     RegionOrder = list(
#'       "string"
#'     ),
#'     FailureToleranceCount = 123,
#'     FailureTolerancePercentage = 123,
#'     MaxConcurrentCount = 123,
#'     MaxConcurrentPercentage = 123
#'   ),
#'   OperationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_create_stack_instances
cloudformation_create_stack_instances <- function(StackSetName, Accounts = NULL, DeploymentTargets = NULL, Regions, ParameterOverrides = NULL, OperationPreferences = NULL, OperationId = NULL) {
  op <- new_operation(
    name = "CreateStackInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$create_stack_instances_input(StackSetName = StackSetName, Accounts = Accounts, DeploymentTargets = DeploymentTargets, Regions = Regions, ParameterOverrides = ParameterOverrides, OperationPreferences = OperationPreferences, OperationId = OperationId)
  output <- .cloudformation$create_stack_instances_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$create_stack_instances <- cloudformation_create_stack_instances

#' Creates a stack set
#'
#' @description
#' Creates a stack set.
#'
#' @usage
#' cloudformation_create_stack_set(StackSetName, Description, TemplateBody,
#'   TemplateURL, Parameters, Capabilities, Tags, AdministrationRoleARN,
#'   ExecutionRoleName, PermissionModel, AutoDeployment, ClientRequestToken)
#'
#' @param StackSetName &#91;required&#93; The name to associate with the stack set. The name must be unique in the
#' Region where you create your stack set.
#' 
#' A stack name can contain only alphanumeric characters (case-sensitive)
#' and hyphens. It must start with an alphabetic character and can't be
#' longer than 128 characters.
#' @param Description A description of the stack set. You can use the description to identify
#' the stack set's purpose or other important information.
#' @param TemplateBody The structure that contains the template body, with a minimum length of
#' 1 byte and a maximum length of 51,200 bytes. For more information, see
#' [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.
#' 
#' Conditional: You must specify either the TemplateBody or the TemplateURL
#' parameter, but not both.
#' @param TemplateURL The location of the file that contains the template body. The URL must
#' point to a template (maximum size: 460,800 bytes) that's located in an
#' Amazon S3 bucket. For more information, see [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.
#' 
#' Conditional: You must specify either the TemplateBody or the TemplateURL
#' parameter, but not both.
#' @param Parameters The input parameters for the stack set template.
#' @param Capabilities In some cases, you must explicitly acknowledge that your stack set
#' template contains certain capabilities in order for AWS CloudFormation
#' to create the stack set and related stack instances.
#' 
#' -   `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`
#' 
#'     Some stack templates might include resources that can affect
#'     permissions in your AWS account; for example, by creating new AWS
#'     Identity and Access Management (IAM) users. For those stack sets,
#'     you must explicitly acknowledge this by specifying one of these
#'     capabilities.
#' 
#'     The following IAM resources require you to specify either the
#'     `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
#' 
#'     -   If you have IAM resources, you can specify either capability.
#' 
#'     -   If you have IAM resources with custom names, you *must* specify
#'         `CAPABILITY_NAMED_IAM`.
#' 
#'     -   If you don't specify either of these capabilities, AWS
#'         CloudFormation returns an `InsufficientCapabilities` error.
#' 
#'     If your stack template contains these resources, we recommend that
#'     you review all permissions associated with them and edit their
#'     permissions if necessary.
#' 
#'     -   [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
#' 
#'     -   [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
#' 
#'     -   [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
#' 
#'     -   [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
#' 
#'     -   [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
#' 
#'     -   [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
#' 
#'     -   [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
#' 
#'     For more information, see [Acknowledging IAM Resources in AWS
#'     CloudFormation
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
#' 
#' -   `CAPABILITY_AUTO_EXPAND`
#' 
#'     Some templates contain macros. If your stack template contains one
#'     or more macros, and you choose to create a stack directly from the
#'     processed template, without first reviewing the resulting changes in
#'     a change set, you must acknowledge this capability. For more
#'     information, see [Using AWS CloudFormation Macros to Perform Custom
#'     Processing on
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
#' 
#'     Stack sets do not currently support macros in stack templates. (This
#'     includes the
#'     [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
#'     and
#'     [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
#'     transforms, which are macros hosted by AWS CloudFormation.) Even if
#'     you specify this capability, if you include a macro in your template
#'     the stack set operation will fail.
#' @param Tags The key-value pairs to associate with this stack set and the stacks
#' created from it. AWS CloudFormation also propagates these tags to
#' supported resources that are created in the stacks. A maximum number of
#' 50 tags can be specified.
#' 
#' If you specify tags as part of a `CreateStackSet` action, AWS
#' CloudFormation checks to see if you have the required IAM permission to
#' tag resources. If you don't, the entire `CreateStackSet` action fails
#' with an `access denied` error, and the stack set is not created.
#' @param AdministrationRoleARN The Amazon Resource Number (ARN) of the IAM role to use to create this
#' stack set.
#' 
#' Specify an IAM role only if you are using customized administrator roles
#' to control which users or groups can manage specific stack sets within
#' the same administrator account. For more information, see
#' [Prerequisites: Granting Permissions for Stack Set
#' Operations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
#' in the *AWS CloudFormation User Guide*.
#' @param ExecutionRoleName The name of the IAM execution role to use to create the stack set. If
#' you do not specify an execution role, AWS CloudFormation uses the
#' `AWSCloudFormationStackSetExecutionRole` role for the stack set
#' operation.
#' 
#' Specify an IAM role only if you are using customized execution roles to
#' control which stack resources users and groups can include in their
#' stack sets.
#' @param PermissionModel Describes how the IAM roles required for stack set operations are
#' created. By default, `SELF-MANAGED` is specified.
#' 
#' -   With `self-managed` permissions, you must create the administrator
#'     and execution roles required to deploy to target accounts. For more
#'     information, see [Grant Self-Managed Stack Set
#'     Permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
#' 
#' -   With `service-managed` permissions, StackSets automatically creates
#'     the IAM roles required to deploy to accounts managed by AWS
#'     Organizations. For more information, see [Grant Service-Managed
#'     Stack Set
#'     Permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
#' @param AutoDeployment Describes whether StackSets automatically deploys to AWS Organizations
#' accounts that are added to the target organization or organizational
#' unit (OU). Specify only if `PermissionModel` is `SERVICE_MANAGED`.
#' @param ClientRequestToken A unique identifier for this `CreateStackSet` request. Specify this
#' token if you plan to retry requests so that AWS CloudFormation knows
#' that you're not attempting to create another stack set with the same
#' name. You might retry `CreateStackSet` requests to ensure that AWS
#' CloudFormation successfully received them.
#' 
#' If you don't specify an operation ID, the SDK generates one
#' automatically.
#'
#' @section Request syntax:
#' ```
#' svc$create_stack_set(
#'   StackSetName = "string",
#'   Description = "string",
#'   TemplateBody = "string",
#'   TemplateURL = "string",
#'   Parameters = list(
#'     list(
#'       ParameterKey = "string",
#'       ParameterValue = "string",
#'       UsePreviousValue = TRUE|FALSE,
#'       ResolvedValue = "string"
#'     )
#'   ),
#'   Capabilities = list(
#'     "CAPABILITY_IAM"|"CAPABILITY_NAMED_IAM"|"CAPABILITY_AUTO_EXPAND"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   AdministrationRoleARN = "string",
#'   ExecutionRoleName = "string",
#'   PermissionModel = "SERVICE_MANAGED"|"SELF_MANAGED",
#'   AutoDeployment = list(
#'     Enabled = TRUE|FALSE,
#'     RetainStacksOnAccountRemoval = TRUE|FALSE
#'   ),
#'   ClientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_create_stack_set
cloudformation_create_stack_set <- function(StackSetName, Description = NULL, TemplateBody = NULL, TemplateURL = NULL, Parameters = NULL, Capabilities = NULL, Tags = NULL, AdministrationRoleARN = NULL, ExecutionRoleName = NULL, PermissionModel = NULL, AutoDeployment = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "CreateStackSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$create_stack_set_input(StackSetName = StackSetName, Description = Description, TemplateBody = TemplateBody, TemplateURL = TemplateURL, Parameters = Parameters, Capabilities = Capabilities, Tags = Tags, AdministrationRoleARN = AdministrationRoleARN, ExecutionRoleName = ExecutionRoleName, PermissionModel = PermissionModel, AutoDeployment = AutoDeployment, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$create_stack_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$create_stack_set <- cloudformation_create_stack_set

#' Deletes the specified change set
#'
#' @description
#' Deletes the specified change set. Deleting change sets ensures that no
#' one executes the wrong change set.
#' 
#' If the call successfully completes, AWS CloudFormation successfully
#' deleted the change set.
#' 
#' If `IncludeNestedStacks` specifies `True` during the creation of the
#' nested change set, then `DeleteChangeSet` will delete all change sets
#' that belong to the stacks hierarchy and will also delete all change sets
#' for nested stacks with the status of `REVIEW_IN_PROGRESS`.
#'
#' @usage
#' cloudformation_delete_change_set(ChangeSetName, StackName)
#'
#' @param ChangeSetName &#91;required&#93; The name or Amazon Resource Name (ARN) of the change set that you want
#' to delete.
#' @param StackName If you specified the name of a change set to delete, specify the stack
#' name or ID (ARN) that is associated with it.
#'
#' @section Request syntax:
#' ```
#' svc$delete_change_set(
#'   ChangeSetName = "string",
#'   StackName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_delete_change_set
cloudformation_delete_change_set <- function(ChangeSetName, StackName = NULL) {
  op <- new_operation(
    name = "DeleteChangeSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$delete_change_set_input(ChangeSetName = ChangeSetName, StackName = StackName)
  output <- .cloudformation$delete_change_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$delete_change_set <- cloudformation_delete_change_set

#' Deletes a specified stack
#'
#' @description
#' Deletes a specified stack. Once the call completes successfully, stack
#' deletion starts. Deleted stacks do not show up in the DescribeStacks API
#' if the deletion has been completed successfully.
#'
#' @usage
#' cloudformation_delete_stack(StackName, RetainResources, RoleARN,
#'   ClientRequestToken)
#'
#' @param StackName &#91;required&#93; The name or the unique stack ID that is associated with the stack.
#' @param RetainResources For stacks in the `DELETE_FAILED` state, a list of resource logical IDs
#' that are associated with the resources you want to retain. During
#' deletion, AWS CloudFormation deletes the stack but does not delete the
#' retained resources.
#' 
#' Retaining resources is useful when you cannot delete a resource, such as
#' a non-empty S3 bucket, but you want to delete the stack.
#' @param RoleARN The Amazon Resource Name (ARN) of an AWS Identity and Access Management
#' (IAM) role that AWS CloudFormation assumes to delete the stack. AWS
#' CloudFormation uses the role's credentials to make calls on your behalf.
#' 
#' If you don't specify a value, AWS CloudFormation uses the role that was
#' previously associated with the stack. If no role is available, AWS
#' CloudFormation uses a temporary session that is generated from your user
#' credentials.
#' @param ClientRequestToken A unique identifier for this `DeleteStack` request. Specify this token
#' if you plan to retry requests so that AWS CloudFormation knows that
#' you're not attempting to delete a stack with the same name. You might
#' retry `DeleteStack` requests to ensure that AWS CloudFormation
#' successfully received them.
#' 
#' All events triggered by a given stack operation are assigned the same
#' client request token, which you can use to track operations. For
#' example, if you execute a `CreateStack` operation with the token
#' `token1`, then all the `StackEvents` generated by that operation will
#' have `ClientRequestToken` set as `token1`.
#' 
#' In the console, stack operations display the client request token on the
#' Events tab. Stack operations that are initiated from the console use the
#' token format *Console-StackOperation-ID*, which helps you easily
#' identify the stack operation . For example, if you create a stack using
#' the console, each stack event would be assigned the same token in the
#' following format:
#' `Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_stack(
#'   StackName = "string",
#'   RetainResources = list(
#'     "string"
#'   ),
#'   RoleARN = "string",
#'   ClientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_delete_stack
cloudformation_delete_stack <- function(StackName, RetainResources = NULL, RoleARN = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "DeleteStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$delete_stack_input(StackName = StackName, RetainResources = RetainResources, RoleARN = RoleARN, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$delete_stack_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$delete_stack <- cloudformation_delete_stack

#' Deletes stack instances for the specified accounts, in the specified
#' Regions
#'
#' @description
#' Deletes stack instances for the specified accounts, in the specified
#' Regions.
#'
#' @usage
#' cloudformation_delete_stack_instances(StackSetName, Accounts,
#'   DeploymentTargets, Regions, OperationPreferences, RetainStacks,
#'   OperationId)
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to delete stack
#' instances for.
#' @param Accounts \[`Self-managed` permissions\] The names of the AWS accounts that you
#' want to delete stack instances for.
#' 
#' You can specify `Accounts` or `DeploymentTargets`, but not both.
#' @param DeploymentTargets \[`Service-managed` permissions\] The AWS Organizations accounts from
#' which to delete stack instances.
#' 
#' You can specify `Accounts` or `DeploymentTargets`, but not both.
#' @param Regions &#91;required&#93; The Regions where you want to delete stack set instances.
#' @param OperationPreferences Preferences for how AWS CloudFormation performs this stack set
#' operation.
#' @param RetainStacks &#91;required&#93; Removes the stack instances from the specified stack set, but doesn't
#' delete the stacks. You can't reassociate a retained stack or add an
#' existing, saved stack to a new stack set.
#' 
#' For more information, see [Stack set operation
#' options](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options).
#' @param OperationId The unique identifier for this stack set operation.
#' 
#' If you don't specify an operation ID, the SDK generates one
#' automatically.
#' 
#' The operation ID also functions as an idempotency token, to ensure that
#' AWS CloudFormation performs the stack set operation only once, even if
#' you retry the request multiple times. You can retry stack set operation
#' requests to ensure that AWS CloudFormation successfully received them.
#' 
#' Repeating this stack set operation with a new operation ID retries all
#' stack instances whose status is `OUTDATED`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_stack_instances(
#'   StackSetName = "string",
#'   Accounts = list(
#'     "string"
#'   ),
#'   DeploymentTargets = list(
#'     Accounts = list(
#'       "string"
#'     ),
#'     OrganizationalUnitIds = list(
#'       "string"
#'     )
#'   ),
#'   Regions = list(
#'     "string"
#'   ),
#'   OperationPreferences = list(
#'     RegionOrder = list(
#'       "string"
#'     ),
#'     FailureToleranceCount = 123,
#'     FailureTolerancePercentage = 123,
#'     MaxConcurrentCount = 123,
#'     MaxConcurrentPercentage = 123
#'   ),
#'   RetainStacks = TRUE|FALSE,
#'   OperationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_delete_stack_instances
cloudformation_delete_stack_instances <- function(StackSetName, Accounts = NULL, DeploymentTargets = NULL, Regions, OperationPreferences = NULL, RetainStacks, OperationId = NULL) {
  op <- new_operation(
    name = "DeleteStackInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$delete_stack_instances_input(StackSetName = StackSetName, Accounts = Accounts, DeploymentTargets = DeploymentTargets, Regions = Regions, OperationPreferences = OperationPreferences, RetainStacks = RetainStacks, OperationId = OperationId)
  output <- .cloudformation$delete_stack_instances_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$delete_stack_instances <- cloudformation_delete_stack_instances

#' Deletes a stack set
#'
#' @description
#' Deletes a stack set. Before you can delete a stack set, all of its
#' member stack instances must be deleted. For more information about how
#' to do this, see DeleteStackInstances.
#'
#' @usage
#' cloudformation_delete_stack_set(StackSetName)
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you're deleting. You can
#' obtain this value by running ListStackSets.
#'
#' @section Request syntax:
#' ```
#' svc$delete_stack_set(
#'   StackSetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_delete_stack_set
cloudformation_delete_stack_set <- function(StackSetName) {
  op <- new_operation(
    name = "DeleteStackSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$delete_stack_set_input(StackSetName = StackSetName)
  output <- .cloudformation$delete_stack_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$delete_stack_set <- cloudformation_delete_stack_set

#' Removes a type or type version from active use in the CloudFormation
#' registry
#'
#' @description
#' Removes a type or type version from active use in the CloudFormation
#' registry. If a type or type version is deregistered, it cannot be used
#' in CloudFormation operations.
#' 
#' To deregister a type, you must individually deregister all registered
#' versions of that type. If a type has only a single registered version,
#' deregistering that version results in the type itself being
#' deregistered.
#' 
#' You cannot deregister the default version of a type, unless it is the
#' only registered version of that type, in which case the type itself is
#' deregistered as well.
#'
#' @usage
#' cloudformation_deregister_type(Arn, Type, TypeName, VersionId)
#'
#' @param Arn The Amazon Resource Name (ARN) of the type.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param Type The kind of type.
#' 
#' Currently the only valid value is `RESOURCE`.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param TypeName The name of the type.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param VersionId The ID of a specific version of the type. The version ID is the value at
#' the end of the Amazon Resource Name (ARN) assigned to the type version
#' when it is registered.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_type(
#'   Arn = "string",
#'   Type = "RESOURCE"|"MODULE",
#'   TypeName = "string",
#'   VersionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_deregister_type
cloudformation_deregister_type <- function(Arn = NULL, Type = NULL, TypeName = NULL, VersionId = NULL) {
  op <- new_operation(
    name = "DeregisterType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$deregister_type_input(Arn = Arn, Type = Type, TypeName = TypeName, VersionId = VersionId)
  output <- .cloudformation$deregister_type_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$deregister_type <- cloudformation_deregister_type

#' Retrieves your account's AWS CloudFormation limits, such as the maximum
#' number of stacks that you can create in your account
#'
#' @description
#' Retrieves your account's AWS CloudFormation limits, such as the maximum
#' number of stacks that you can create in your account. For more
#' information about account limits, see [AWS CloudFormation
#' Limits](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cloudformation-limits.html)
#' in the *AWS CloudFormation User Guide*.
#'
#' @usage
#' cloudformation_describe_account_limits(NextToken)
#'
#' @param NextToken A string that identifies the next page of limits that you want to
#' retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$describe_account_limits(
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_account_limits
cloudformation_describe_account_limits <- function(NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAccountLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_account_limits_input(NextToken = NextToken)
  output <- .cloudformation$describe_account_limits_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_account_limits <- cloudformation_describe_account_limits

#' Returns the inputs for the change set and a list of changes that AWS
#' CloudFormation will make if you execute the change set
#'
#' @description
#' Returns the inputs for the change set and a list of changes that AWS
#' CloudFormation will make if you execute the change set. For more
#' information, see [Updating Stacks Using Change
#' Sets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html)
#' in the AWS CloudFormation User Guide.
#'
#' @usage
#' cloudformation_describe_change_set(ChangeSetName, StackName, NextToken)
#'
#' @param ChangeSetName &#91;required&#93; The name or Amazon Resource Name (ARN) of the change set that you want
#' to describe.
#' @param StackName If you specified the name of a change set, specify the stack name or ID
#' (ARN) of the change set you want to describe.
#' @param NextToken A string (provided by the DescribeChangeSet response output) that
#' identifies the next page of information that you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$describe_change_set(
#'   ChangeSetName = "string",
#'   StackName = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_change_set
cloudformation_describe_change_set <- function(ChangeSetName, StackName = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeChangeSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_change_set_input(ChangeSetName = ChangeSetName, StackName = StackName, NextToken = NextToken)
  output <- .cloudformation$describe_change_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_change_set <- cloudformation_describe_change_set

#' Returns information about a stack drift detection operation
#'
#' @description
#' Returns information about a stack drift detection operation. A stack
#' drift detection operation detects whether a stack's actual configuration
#' differs, or has *drifted*, from it's expected configuration, as defined
#' in the stack template and any values specified as template parameters. A
#' stack is considered to have drifted if one or more of its resources have
#' drifted. For more information on stack and resource drift, see
#' [Detecting Unregulated Configuration Changes to Stacks and
#' Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
#' 
#' Use DetectStackDrift to initiate a stack drift detection operation.
#' `DetectStackDrift` returns a `StackDriftDetectionId` you can use to
#' monitor the progress of the operation using
#' `DescribeStackDriftDetectionStatus`. Once the drift detection operation
#' has completed, use DescribeStackResourceDrifts to return drift
#' information about the stack and its resources.
#'
#' @usage
#' cloudformation_describe_stack_drift_detection_status(
#'   StackDriftDetectionId)
#'
#' @param StackDriftDetectionId &#91;required&#93; The ID of the drift detection results of this operation.
#' 
#' AWS CloudFormation generates new results, with a new drift detection ID,
#' each time this operation is run. However, the number of drift results
#' AWS CloudFormation retains for any given stack, and for how long, may
#' vary.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stack_drift_detection_status(
#'   StackDriftDetectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_drift_detection_status
cloudformation_describe_stack_drift_detection_status <- function(StackDriftDetectionId) {
  op <- new_operation(
    name = "DescribeStackDriftDetectionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_drift_detection_status_input(StackDriftDetectionId = StackDriftDetectionId)
  output <- .cloudformation$describe_stack_drift_detection_status_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_drift_detection_status <- cloudformation_describe_stack_drift_detection_status

#' Returns all stack related events for a specified stack in reverse
#' chronological order
#'
#' @description
#' Returns all stack related events for a specified stack in reverse
#' chronological order. For more information about a stack's event history,
#' go to
#' [Stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-whatis-concepts.html)
#' in the AWS CloudFormation User Guide.
#' 
#' You can list events for stacks that have failed to create or have been
#' deleted by specifying the unique stack identifier (stack ID).
#'
#' @usage
#' cloudformation_describe_stack_events(StackName, NextToken)
#'
#' @param StackName The name or the unique stack ID that is associated with the stack, which
#' are not always interchangeable:
#' 
#' -   Running stacks: You can specify either the stack's name or its
#'     unique stack ID.
#' 
#' -   Deleted stacks: You must specify the unique stack ID.
#' 
#' Default: There is no default value.
#' @param NextToken A string that identifies the next page of events that you want to
#' retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stack_events(
#'   StackName = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_events
cloudformation_describe_stack_events <- function(StackName = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeStackEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_events_input(StackName = StackName, NextToken = NextToken)
  output <- .cloudformation$describe_stack_events_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_events <- cloudformation_describe_stack_events

#' Returns the stack instance that's associated with the specified stack
#' set, AWS account, and Region
#'
#' @description
#' Returns the stack instance that's associated with the specified stack
#' set, AWS account, and Region.
#' 
#' For a list of stack instances that are associated with a specific stack
#' set, use ListStackInstances.
#'
#' @usage
#' cloudformation_describe_stack_instance(StackSetName,
#'   StackInstanceAccount, StackInstanceRegion)
#'
#' @param StackSetName &#91;required&#93; The name or the unique stack ID of the stack set that you want to get
#' stack instance information for.
#' @param StackInstanceAccount &#91;required&#93; The ID of an AWS account that's associated with this stack instance.
#' @param StackInstanceRegion &#91;required&#93; The name of a Region that's associated with this stack instance.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stack_instance(
#'   StackSetName = "string",
#'   StackInstanceAccount = "string",
#'   StackInstanceRegion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_instance
cloudformation_describe_stack_instance <- function(StackSetName, StackInstanceAccount, StackInstanceRegion) {
  op <- new_operation(
    name = "DescribeStackInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_instance_input(StackSetName = StackSetName, StackInstanceAccount = StackInstanceAccount, StackInstanceRegion = StackInstanceRegion)
  output <- .cloudformation$describe_stack_instance_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_instance <- cloudformation_describe_stack_instance

#' Returns a description of the specified resource in the specified stack
#'
#' @description
#' Returns a description of the specified resource in the specified stack.
#' 
#' For deleted stacks, DescribeStackResource returns resource information
#' for up to 90 days after the stack has been deleted.
#'
#' @usage
#' cloudformation_describe_stack_resource(StackName, LogicalResourceId)
#'
#' @param StackName &#91;required&#93; The name or the unique stack ID that is associated with the stack, which
#' are not always interchangeable:
#' 
#' -   Running stacks: You can specify either the stack's name or its
#'     unique stack ID.
#' 
#' -   Deleted stacks: You must specify the unique stack ID.
#' 
#' Default: There is no default value.
#' @param LogicalResourceId &#91;required&#93; The logical name of the resource as specified in the template.
#' 
#' Default: There is no default value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stack_resource(
#'   StackName = "string",
#'   LogicalResourceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_resource
cloudformation_describe_stack_resource <- function(StackName, LogicalResourceId) {
  op <- new_operation(
    name = "DescribeStackResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_resource_input(StackName = StackName, LogicalResourceId = LogicalResourceId)
  output <- .cloudformation$describe_stack_resource_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_resource <- cloudformation_describe_stack_resource

#' Returns drift information for the resources that have been checked for
#' drift in the specified stack
#'
#' @description
#' Returns drift information for the resources that have been checked for
#' drift in the specified stack. This includes actual and expected
#' configuration values for resources where AWS CloudFormation detects
#' configuration drift.
#' 
#' For a given stack, there will be one `StackResourceDrift` for each stack
#' resource that has been checked for drift. Resources that have not yet
#' been checked for drift are not included. Resources that do not currently
#' support drift detection are not checked, and so not included. For a list
#' of resources that support drift detection, see [Resources that Support
#' Drift
#' Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html).
#' 
#' Use DetectStackResourceDrift to detect drift on individual resources, or
#' DetectStackDrift to detect drift on all supported resources for a given
#' stack.
#'
#' @usage
#' cloudformation_describe_stack_resource_drifts(StackName,
#'   StackResourceDriftStatusFilters, NextToken, MaxResults)
#'
#' @param StackName &#91;required&#93; The name of the stack for which you want drift information.
#' @param StackResourceDriftStatusFilters The resource drift status values to use as filters for the resource
#' drift results returned.
#' 
#' -   `DELETED`: The resource differs from its expected template
#'     configuration in that the resource has been deleted.
#' 
#' -   `MODIFIED`: One or more resource properties differ from their
#'     expected template values.
#' 
#' -   `IN_SYNC`: The resources's actual configuration matches its expected
#'     template configuration.
#' 
#' -   `NOT_CHECKED`: AWS CloudFormation does not currently return this
#'     value.
#' @param NextToken A string that identifies the next page of stack resource drift results.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stack_resource_drifts(
#'   StackName = "string",
#'   StackResourceDriftStatusFilters = list(
#'     "IN_SYNC"|"MODIFIED"|"DELETED"|"NOT_CHECKED"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_resource_drifts
cloudformation_describe_stack_resource_drifts <- function(StackName, StackResourceDriftStatusFilters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeStackResourceDrifts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_resource_drifts_input(StackName = StackName, StackResourceDriftStatusFilters = StackResourceDriftStatusFilters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudformation$describe_stack_resource_drifts_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_resource_drifts <- cloudformation_describe_stack_resource_drifts

#' Returns AWS resource descriptions for running and deleted stacks
#'
#' @description
#' Returns AWS resource descriptions for running and deleted stacks. If
#' `StackName` is specified, all the associated resources that are part of
#' the stack are returned. If `PhysicalResourceId` is specified, the
#' associated resources of the stack that the resource belongs to are
#' returned.
#' 
#' Only the first 100 resources will be returned. If your stack has more
#' resources than this, you should use `ListStackResources` instead.
#' 
#' For deleted stacks, `DescribeStackResources` returns resource
#' information for up to 90 days after the stack has been deleted.
#' 
#' You must specify either `StackName` or `PhysicalResourceId`, but not
#' both. In addition, you can specify `LogicalResourceId` to filter the
#' returned result. For more information about resources, the
#' `LogicalResourceId` and `PhysicalResourceId`, go to the [AWS
#' CloudFormation User
#' Guide](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
#' 
#' A `ValidationError` is returned if you specify both `StackName` and
#' `PhysicalResourceId` in the same request.
#'
#' @usage
#' cloudformation_describe_stack_resources(StackName, LogicalResourceId,
#'   PhysicalResourceId)
#'
#' @param StackName The name or the unique stack ID that is associated with the stack, which
#' are not always interchangeable:
#' 
#' -   Running stacks: You can specify either the stack's name or its
#'     unique stack ID.
#' 
#' -   Deleted stacks: You must specify the unique stack ID.
#' 
#' Default: There is no default value.
#' 
#' Required: Conditional. If you do not specify `StackName`, you must
#' specify `PhysicalResourceId`.
#' @param LogicalResourceId The logical name of the resource as specified in the template.
#' 
#' Default: There is no default value.
#' @param PhysicalResourceId The name or unique identifier that corresponds to a physical instance ID
#' of a resource supported by AWS CloudFormation.
#' 
#' For example, for an Amazon Elastic Compute Cloud (EC2) instance,
#' `PhysicalResourceId` corresponds to the `InstanceId`. You can pass the
#' EC2 `InstanceId` to `DescribeStackResources` to find which stack the
#' instance belongs to and what other resources are part of the stack.
#' 
#' Required: Conditional. If you do not specify `PhysicalResourceId`, you
#' must specify `StackName`.
#' 
#' Default: There is no default value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stack_resources(
#'   StackName = "string",
#'   LogicalResourceId = "string",
#'   PhysicalResourceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_resources
cloudformation_describe_stack_resources <- function(StackName = NULL, LogicalResourceId = NULL, PhysicalResourceId = NULL) {
  op <- new_operation(
    name = "DescribeStackResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_resources_input(StackName = StackName, LogicalResourceId = LogicalResourceId, PhysicalResourceId = PhysicalResourceId)
  output <- .cloudformation$describe_stack_resources_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_resources <- cloudformation_describe_stack_resources

#' Returns the description of the specified stack set
#'
#' @description
#' Returns the description of the specified stack set.
#'
#' @usage
#' cloudformation_describe_stack_set(StackSetName)
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set whose description you want.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stack_set(
#'   StackSetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_set
cloudformation_describe_stack_set <- function(StackSetName) {
  op <- new_operation(
    name = "DescribeStackSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_set_input(StackSetName = StackSetName)
  output <- .cloudformation$describe_stack_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_set <- cloudformation_describe_stack_set

#' Returns the description of the specified stack set operation
#'
#' @description
#' Returns the description of the specified stack set operation.
#'
#' @usage
#' cloudformation_describe_stack_set_operation(StackSetName, OperationId)
#'
#' @param StackSetName &#91;required&#93; The name or the unique stack ID of the stack set for the stack
#' operation.
#' @param OperationId &#91;required&#93; The unique ID of the stack set operation.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stack_set_operation(
#'   StackSetName = "string",
#'   OperationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stack_set_operation
cloudformation_describe_stack_set_operation <- function(StackSetName, OperationId) {
  op <- new_operation(
    name = "DescribeStackSetOperation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stack_set_operation_input(StackSetName = StackSetName, OperationId = OperationId)
  output <- .cloudformation$describe_stack_set_operation_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stack_set_operation <- cloudformation_describe_stack_set_operation

#' Returns the description for the specified stack; if no stack name was
#' specified, then it returns the description for all the stacks created
#'
#' @description
#' Returns the description for the specified stack; if no stack name was
#' specified, then it returns the description for all the stacks created.
#' 
#' If the stack does not exist, an `AmazonCloudFormationException` is
#' returned.
#'
#' @usage
#' cloudformation_describe_stacks(StackName, NextToken)
#'
#' @param StackName The name or the unique stack ID that is associated with the stack, which
#' are not always interchangeable:
#' 
#' -   Running stacks: You can specify either the stack's name or its
#'     unique stack ID.
#' 
#' -   Deleted stacks: You must specify the unique stack ID.
#' 
#' Default: There is no default value.
#' @param NextToken A string that identifies the next page of stacks that you want to
#' retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stacks(
#'   StackName = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_stacks
cloudformation_describe_stacks <- function(StackName = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeStacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_stacks_input(StackName = StackName, NextToken = NextToken)
  output <- .cloudformation$describe_stacks_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_stacks <- cloudformation_describe_stacks

#' Returns detailed information about a type that has been registered
#'
#' @description
#' Returns detailed information about a type that has been registered.
#' 
#' If you specify a `VersionId`, `DescribeType` returns information about
#' that specific type version. Otherwise, it returns information about the
#' default type version.
#'
#' @usage
#' cloudformation_describe_type(Type, TypeName, Arn, VersionId)
#'
#' @param Type The kind of type.
#' 
#' Currently the only valid value is `RESOURCE`.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param TypeName The name of the type.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param Arn The Amazon Resource Name (ARN) of the type.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param VersionId The ID of a specific version of the type. The version ID is the value at
#' the end of the Amazon Resource Name (ARN) assigned to the type version
#' when it is registered.
#' 
#' If you specify a `VersionId`, `DescribeType` returns information about
#' that specific type version. Otherwise, it returns information about the
#' default type version.
#'
#' @section Request syntax:
#' ```
#' svc$describe_type(
#'   Type = "RESOURCE"|"MODULE",
#'   TypeName = "string",
#'   Arn = "string",
#'   VersionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_type
cloudformation_describe_type <- function(Type = NULL, TypeName = NULL, Arn = NULL, VersionId = NULL) {
  op <- new_operation(
    name = "DescribeType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_type_input(Type = Type, TypeName = TypeName, Arn = Arn, VersionId = VersionId)
  output <- .cloudformation$describe_type_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_type <- cloudformation_describe_type

#' Returns information about a type's registration, including its current
#' status and type and version identifiers
#'
#' @description
#' Returns information about a type's registration, including its current
#' status and type and version identifiers.
#' 
#' When you initiate a registration request using ` <a>RegisterType</a> `,
#' you can then use ` <a>DescribeTypeRegistration</a> ` to monitor the
#' progress of that registration request.
#' 
#' Once the registration request has completed, use ` <a>DescribeType</a> `
#' to return detailed informaiton about a type.
#'
#' @usage
#' cloudformation_describe_type_registration(RegistrationToken)
#'
#' @param RegistrationToken &#91;required&#93; The identifier for this registration request.
#' 
#' This registration token is generated by CloudFormation when you initiate
#' a registration request using ` <a>RegisterType</a> `.
#'
#' @section Request syntax:
#' ```
#' svc$describe_type_registration(
#'   RegistrationToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_describe_type_registration
cloudformation_describe_type_registration <- function(RegistrationToken) {
  op <- new_operation(
    name = "DescribeTypeRegistration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$describe_type_registration_input(RegistrationToken = RegistrationToken)
  output <- .cloudformation$describe_type_registration_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$describe_type_registration <- cloudformation_describe_type_registration

#' Detects whether a stack's actual configuration differs, or has drifted,
#' from it's expected configuration, as defined in the stack template and
#' any values specified as template parameters
#'
#' @description
#' Detects whether a stack's actual configuration differs, or has
#' *drifted*, from it's expected configuration, as defined in the stack
#' template and any values specified as template parameters. For each
#' resource in the stack that supports drift detection, AWS CloudFormation
#' compares the actual configuration of the resource with its expected
#' template configuration. Only resource properties explicitly defined in
#' the stack template are checked for drift. A stack is considered to have
#' drifted if one or more of its resources differ from their expected
#' template configurations. For more information, see [Detecting
#' Unregulated Configuration Changes to Stacks and
#' Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
#' 
#' Use `DetectStackDrift` to detect drift on all supported resources for a
#' given stack, or DetectStackResourceDrift to detect drift on individual
#' resources.
#' 
#' For a list of stack resources that currently support drift detection,
#' see [Resources that Support Drift
#' Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html).
#' 
#' `DetectStackDrift` can take up to several minutes, depending on the
#' number of resources contained within the stack. Use
#' DescribeStackDriftDetectionStatus to monitor the progress of a detect
#' stack drift operation. Once the drift detection operation has completed,
#' use DescribeStackResourceDrifts to return drift information about the
#' stack and its resources.
#' 
#' When detecting drift on a stack, AWS CloudFormation does not detect
#' drift on any nested stacks belonging to that stack. Perform
#' `DetectStackDrift` directly on the nested stack itself.
#'
#' @usage
#' cloudformation_detect_stack_drift(StackName, LogicalResourceIds)
#'
#' @param StackName &#91;required&#93; The name of the stack for which you want to detect drift.
#' @param LogicalResourceIds The logical names of any resources you want to use as filters.
#'
#' @section Request syntax:
#' ```
#' svc$detect_stack_drift(
#'   StackName = "string",
#'   LogicalResourceIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_detect_stack_drift
cloudformation_detect_stack_drift <- function(StackName, LogicalResourceIds = NULL) {
  op <- new_operation(
    name = "DetectStackDrift",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$detect_stack_drift_input(StackName = StackName, LogicalResourceIds = LogicalResourceIds)
  output <- .cloudformation$detect_stack_drift_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$detect_stack_drift <- cloudformation_detect_stack_drift

#' Returns information about whether a resource's actual configuration
#' differs, or has drifted, from it's expected configuration, as defined in
#' the stack template and any values specified as template parameters
#'
#' @description
#' Returns information about whether a resource's actual configuration
#' differs, or has *drifted*, from it's expected configuration, as defined
#' in the stack template and any values specified as template parameters.
#' This information includes actual and expected property values for
#' resources in which AWS CloudFormation detects drift. Only resource
#' properties explicitly defined in the stack template are checked for
#' drift. For more information about stack and resource drift, see
#' [Detecting Unregulated Configuration Changes to Stacks and
#' Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html).
#' 
#' Use `DetectStackResourceDrift` to detect drift on individual resources,
#' or DetectStackDrift to detect drift on all resources in a given stack
#' that support drift detection.
#' 
#' Resources that do not currently support drift detection cannot be
#' checked. For a list of resources that support drift detection, see
#' [Resources that Support Drift
#' Detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html).
#'
#' @usage
#' cloudformation_detect_stack_resource_drift(StackName, LogicalResourceId)
#'
#' @param StackName &#91;required&#93; The name of the stack to which the resource belongs.
#' @param LogicalResourceId &#91;required&#93; The logical name of the resource for which to return drift information.
#'
#' @section Request syntax:
#' ```
#' svc$detect_stack_resource_drift(
#'   StackName = "string",
#'   LogicalResourceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_detect_stack_resource_drift
cloudformation_detect_stack_resource_drift <- function(StackName, LogicalResourceId) {
  op <- new_operation(
    name = "DetectStackResourceDrift",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$detect_stack_resource_drift_input(StackName = StackName, LogicalResourceId = LogicalResourceId)
  output <- .cloudformation$detect_stack_resource_drift_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$detect_stack_resource_drift <- cloudformation_detect_stack_resource_drift

#' Detect drift on a stack set
#'
#' @description
#' Detect drift on a stack set. When CloudFormation performs drift
#' detection on a stack set, it performs drift detection on the stack
#' associated with each stack instance in the stack set. For more
#' information, see [How CloudFormation Performs Drift Detection on a Stack
#' Set](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
#' 
#' `DetectStackSetDrift` returns the `OperationId` of the stack set drift
#' detection operation. Use this operation id with
#' ` <a>DescribeStackSetOperation</a> ` to monitor the progress of the
#' drift detection operation. The drift detection operation may take some
#' time, depending on the number of stack instances included in the stack
#' set, as well as the number of resources included in each stack.
#' 
#' Once the operation has completed, use the following actions to return
#' drift information:
#' 
#' -   Use ` <a>DescribeStackSet</a> ` to return detailed informaiton about
#'     the stack set, including detailed information about the last
#'     *completed* drift operation performed on the stack set. (Information
#'     about drift operations that are in progress is not included.)
#' 
#' -   Use ` <a>ListStackInstances</a> ` to return a list of stack
#'     instances belonging to the stack set, including the drift status and
#'     last drift time checked of each instance.
#' 
#' -   Use ` <a>DescribeStackInstance</a> ` to return detailed information
#'     about a specific stack instance, including its drift status and last
#'     drift time checked.
#' 
#' For more information on performing a drift detection operation on a
#' stack set, see [Detecting Unmanaged Changes in Stack
#' Sets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html).
#' 
#' You can only run a single drift detection operation on a given stack set
#' at one time.
#' 
#' To stop a drift detection stack set operation, use
#' ` <a>StopStackSetOperation</a> `.
#'
#' @usage
#' cloudformation_detect_stack_set_drift(StackSetName,
#'   OperationPreferences, OperationId)
#'
#' @param StackSetName &#91;required&#93; The name of the stack set on which to perform the drift detection
#' operation.
#' @param OperationPreferences 
#' @param OperationId *The ID of the stack set operation.*
#'
#' @section Request syntax:
#' ```
#' svc$detect_stack_set_drift(
#'   StackSetName = "string",
#'   OperationPreferences = list(
#'     RegionOrder = list(
#'       "string"
#'     ),
#'     FailureToleranceCount = 123,
#'     FailureTolerancePercentage = 123,
#'     MaxConcurrentCount = 123,
#'     MaxConcurrentPercentage = 123
#'   ),
#'   OperationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_detect_stack_set_drift
cloudformation_detect_stack_set_drift <- function(StackSetName, OperationPreferences = NULL, OperationId = NULL) {
  op <- new_operation(
    name = "DetectStackSetDrift",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$detect_stack_set_drift_input(StackSetName = StackSetName, OperationPreferences = OperationPreferences, OperationId = OperationId)
  output <- .cloudformation$detect_stack_set_drift_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$detect_stack_set_drift <- cloudformation_detect_stack_set_drift

#' Returns the estimated monthly cost of a template
#'
#' @description
#' Returns the estimated monthly cost of a template. The return value is an
#' AWS Simple Monthly Calculator URL with a query string that describes the
#' resources required to run the template.
#'
#' @usage
#' cloudformation_estimate_template_cost(TemplateBody, TemplateURL,
#'   Parameters)
#'
#' @param TemplateBody Structure containing the template body with a minimum length of 1 byte
#' and a maximum length of 51,200 bytes. (For more information, go to
#' [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.)
#' 
#' Conditional: You must pass `TemplateBody` or `TemplateURL`. If both are
#' passed, only `TemplateBody` is used.
#' @param TemplateURL Location of file containing the template body. The URL must point to a
#' template that is located in an Amazon S3 bucket. For more information,
#' go to [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.
#' 
#' Conditional: You must pass `TemplateURL` or `TemplateBody`. If both are
#' passed, only `TemplateBody` is used.
#' @param Parameters A list of `Parameter` structures that specify input parameters.
#'
#' @section Request syntax:
#' ```
#' svc$estimate_template_cost(
#'   TemplateBody = "string",
#'   TemplateURL = "string",
#'   Parameters = list(
#'     list(
#'       ParameterKey = "string",
#'       ParameterValue = "string",
#'       UsePreviousValue = TRUE|FALSE,
#'       ResolvedValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_estimate_template_cost
cloudformation_estimate_template_cost <- function(TemplateBody = NULL, TemplateURL = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "EstimateTemplateCost",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$estimate_template_cost_input(TemplateBody = TemplateBody, TemplateURL = TemplateURL, Parameters = Parameters)
  output <- .cloudformation$estimate_template_cost_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$estimate_template_cost <- cloudformation_estimate_template_cost

#' Updates a stack using the input information that was provided when the
#' specified change set was created
#'
#' @description
#' Updates a stack using the input information that was provided when the
#' specified change set was created. After the call successfully completes,
#' AWS CloudFormation starts updating the stack. Use the DescribeStacks
#' action to view the status of the update.
#' 
#' When you execute a change set, AWS CloudFormation deletes all other
#' change sets associated with the stack because they aren't valid for the
#' updated stack.
#' 
#' If a stack policy is associated with the stack, AWS CloudFormation
#' enforces the policy during the update. You can't specify a temporary
#' stack policy that overrides the current policy.
#' 
#' To create a change set for the entire stack hierachy,
#' `IncludeNestedStacks` must have been set to `True`.
#'
#' @usage
#' cloudformation_execute_change_set(ChangeSetName, StackName,
#'   ClientRequestToken)
#'
#' @param ChangeSetName &#91;required&#93; The name or ARN of the change set that you want use to update the
#' specified stack.
#' @param StackName If you specified the name of a change set, specify the stack name or ID
#' (ARN) that is associated with the change set you want to execute.
#' @param ClientRequestToken A unique identifier for this `ExecuteChangeSet` request. Specify this
#' token if you plan to retry requests so that AWS CloudFormation knows
#' that you're not attempting to execute a change set to update a stack
#' with the same name. You might retry `ExecuteChangeSet` requests to
#' ensure that AWS CloudFormation successfully received them.
#'
#' @section Request syntax:
#' ```
#' svc$execute_change_set(
#'   ChangeSetName = "string",
#'   StackName = "string",
#'   ClientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_execute_change_set
cloudformation_execute_change_set <- function(ChangeSetName, StackName = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "ExecuteChangeSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$execute_change_set_input(ChangeSetName = ChangeSetName, StackName = StackName, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$execute_change_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$execute_change_set <- cloudformation_execute_change_set

#' Returns the stack policy for a specified stack
#'
#' @description
#' Returns the stack policy for a specified stack. If a stack doesn't have
#' a policy, a null value is returned.
#'
#' @usage
#' cloudformation_get_stack_policy(StackName)
#'
#' @param StackName &#91;required&#93; The name or unique stack ID that is associated with the stack whose
#' policy you want to get.
#'
#' @section Request syntax:
#' ```
#' svc$get_stack_policy(
#'   StackName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_get_stack_policy
cloudformation_get_stack_policy <- function(StackName) {
  op <- new_operation(
    name = "GetStackPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$get_stack_policy_input(StackName = StackName)
  output <- .cloudformation$get_stack_policy_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$get_stack_policy <- cloudformation_get_stack_policy

#' Returns the template body for a specified stack
#'
#' @description
#' Returns the template body for a specified stack. You can get the
#' template for running or deleted stacks.
#' 
#' For deleted stacks, GetTemplate returns the template for up to 90 days
#' after the stack has been deleted.
#' 
#' If the template does not exist, a `ValidationError` is returned.
#'
#' @usage
#' cloudformation_get_template(StackName, ChangeSetName, TemplateStage)
#'
#' @param StackName The name or the unique stack ID that is associated with the stack, which
#' are not always interchangeable:
#' 
#' -   Running stacks: You can specify either the stack's name or its
#'     unique stack ID.
#' 
#' -   Deleted stacks: You must specify the unique stack ID.
#' 
#' Default: There is no default value.
#' @param ChangeSetName The name or Amazon Resource Name (ARN) of a change set for which AWS
#' CloudFormation returns the associated template. If you specify a name,
#' you must also specify the `StackName`.
#' @param TemplateStage For templates that include transforms, the stage of the template that
#' AWS CloudFormation returns. To get the user-submitted template, specify
#' `Original`. To get the template after AWS CloudFormation has processed
#' all transforms, specify `Processed`.
#' 
#' If the template doesn't include transforms, `Original` and `Processed`
#' return the same template. By default, AWS CloudFormation specifies
#' `Original`.
#'
#' @section Request syntax:
#' ```
#' svc$get_template(
#'   StackName = "string",
#'   ChangeSetName = "string",
#'   TemplateStage = "Original"|"Processed"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_get_template
cloudformation_get_template <- function(StackName = NULL, ChangeSetName = NULL, TemplateStage = NULL) {
  op <- new_operation(
    name = "GetTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$get_template_input(StackName = StackName, ChangeSetName = ChangeSetName, TemplateStage = TemplateStage)
  output <- .cloudformation$get_template_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$get_template <- cloudformation_get_template

#' Returns information about a new or existing template
#'
#' @description
#' Returns information about a new or existing template. The
#' `GetTemplateSummary` action is useful for viewing parameter information,
#' such as default parameter values and parameter types, before you create
#' or update a stack or stack set.
#' 
#' You can use the `GetTemplateSummary` action when you submit a template,
#' or you can get template information for a stack set, or a running or
#' deleted stack.
#' 
#' For deleted stacks, `GetTemplateSummary` returns the template
#' information for up to 90 days after the stack has been deleted. If the
#' template does not exist, a `ValidationError` is returned.
#'
#' @usage
#' cloudformation_get_template_summary(TemplateBody, TemplateURL,
#'   StackName, StackSetName)
#'
#' @param TemplateBody Structure containing the template body with a minimum length of 1 byte
#' and a maximum length of 51,200 bytes. For more information about
#' templates, see [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
#' @param TemplateURL Location of file containing the template body. The URL must point to a
#' template (max size: 460,800 bytes) that is located in an Amazon S3
#' bucket. For more information about templates, see [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
#' @param StackName The name or the stack ID that is associated with the stack, which are
#' not always interchangeable. For running stacks, you can specify either
#' the stack's name or its unique stack ID. For deleted stack, you must
#' specify the unique stack ID.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
#' @param StackSetName The name or unique ID of the stack set from which the stack was created.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `StackName`, `StackSetName`, `TemplateBody`, or `TemplateURL`.
#'
#' @section Request syntax:
#' ```
#' svc$get_template_summary(
#'   TemplateBody = "string",
#'   TemplateURL = "string",
#'   StackName = "string",
#'   StackSetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_get_template_summary
cloudformation_get_template_summary <- function(TemplateBody = NULL, TemplateURL = NULL, StackName = NULL, StackSetName = NULL) {
  op <- new_operation(
    name = "GetTemplateSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$get_template_summary_input(TemplateBody = TemplateBody, TemplateURL = TemplateURL, StackName = StackName, StackSetName = StackSetName)
  output <- .cloudformation$get_template_summary_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$get_template_summary <- cloudformation_get_template_summary

#' Returns the ID and status of each active change set for a stack
#'
#' @description
#' Returns the ID and status of each active change set for a stack. For
#' example, AWS CloudFormation lists change sets that are in the
#' `CREATE_IN_PROGRESS` or `CREATE_PENDING` state.
#'
#' @usage
#' cloudformation_list_change_sets(StackName, NextToken)
#'
#' @param StackName &#91;required&#93; The name or the Amazon Resource Name (ARN) of the stack for which you
#' want to list change sets.
#' @param NextToken A string (provided by the ListChangeSets response output) that
#' identifies the next page of change sets that you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$list_change_sets(
#'   StackName = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_change_sets
cloudformation_list_change_sets <- function(StackName, NextToken = NULL) {
  op <- new_operation(
    name = "ListChangeSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_change_sets_input(StackName = StackName, NextToken = NextToken)
  output <- .cloudformation$list_change_sets_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_change_sets <- cloudformation_list_change_sets

#' Lists all exported output values in the account and Region in which you
#' call this action
#'
#' @description
#' Lists all exported output values in the account and Region in which you
#' call this action. Use this action to see the exported output values that
#' you can import into other stacks. To import values, use the
#' [`Fn::ImportValue`](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html)
#' function.
#' 
#' For more information, see [AWS CloudFormation Export Stack Output
#' Values](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-exports.html).
#'
#' @usage
#' cloudformation_list_exports(NextToken)
#'
#' @param NextToken A string (provided by the ListExports response output) that identifies
#' the next page of exported output values that you asked to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$list_exports(
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_exports
cloudformation_list_exports <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListExports",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_exports_input(NextToken = NextToken)
  output <- .cloudformation$list_exports_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_exports <- cloudformation_list_exports

#' Lists all stacks that are importing an exported output value
#'
#' @description
#' Lists all stacks that are importing an exported output value. To modify
#' or remove an exported output value, first use this action to see which
#' stacks are using it. To see the exported output values in your account,
#' see ListExports.
#' 
#' For more information about importing an exported output value, see the
#' [`Fn::ImportValue`](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-importvalue.html)
#' function.
#'
#' @usage
#' cloudformation_list_imports(ExportName, NextToken)
#'
#' @param ExportName &#91;required&#93; The name of the exported output value. AWS CloudFormation returns the
#' stack names that are importing this value.
#' @param NextToken A string (provided by the ListImports response output) that identifies
#' the next page of stacks that are importing the specified exported output
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$list_imports(
#'   ExportName = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_imports
cloudformation_list_imports <- function(ExportName, NextToken = NULL) {
  op <- new_operation(
    name = "ListImports",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_imports_input(ExportName = ExportName, NextToken = NextToken)
  output <- .cloudformation$list_imports_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_imports <- cloudformation_list_imports

#' Returns summary information about stack instances that are associated
#' with the specified stack set
#'
#' @description
#' Returns summary information about stack instances that are associated
#' with the specified stack set. You can filter for stack instances that
#' are associated with a specific AWS account name or Region, or that have
#' a specific status.
#'
#' @usage
#' cloudformation_list_stack_instances(StackSetName, NextToken, MaxResults,
#'   Filters, StackInstanceAccount, StackInstanceRegion)
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to list stack
#' instances for.
#' @param NextToken If the previous request didn't return all of the remaining results, the
#' response's `NextToken` parameter value is set to a token. To retrieve
#' the next set of results, call `ListStackInstances` again and assign that
#' token to the request object's `NextToken` parameter. If there are no
#' remaining results, the previous response object's `NextToken` parameter
#' is set to `null`.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#' @param Filters The status that stack instances are filtered by.
#' @param StackInstanceAccount The name of the AWS account that you want to list stack instances for.
#' @param StackInstanceRegion The name of the Region where you want to list stack instances.
#'
#' @section Request syntax:
#' ```
#' svc$list_stack_instances(
#'   StackSetName = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Filters = list(
#'     list(
#'       Name = "DETAILED_STATUS",
#'       Values = "string"
#'     )
#'   ),
#'   StackInstanceAccount = "string",
#'   StackInstanceRegion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_stack_instances
cloudformation_list_stack_instances <- function(StackSetName, NextToken = NULL, MaxResults = NULL, Filters = NULL, StackInstanceAccount = NULL, StackInstanceRegion = NULL) {
  op <- new_operation(
    name = "ListStackInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_stack_instances_input(StackSetName = StackSetName, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters, StackInstanceAccount = StackInstanceAccount, StackInstanceRegion = StackInstanceRegion)
  output <- .cloudformation$list_stack_instances_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_stack_instances <- cloudformation_list_stack_instances

#' Returns descriptions of all resources of the specified stack
#'
#' @description
#' Returns descriptions of all resources of the specified stack.
#' 
#' For deleted stacks, ListStackResources returns resource information for
#' up to 90 days after the stack has been deleted.
#'
#' @usage
#' cloudformation_list_stack_resources(StackName, NextToken)
#'
#' @param StackName &#91;required&#93; The name or the unique stack ID that is associated with the stack, which
#' are not always interchangeable:
#' 
#' -   Running stacks: You can specify either the stack's name or its
#'     unique stack ID.
#' 
#' -   Deleted stacks: You must specify the unique stack ID.
#' 
#' Default: There is no default value.
#' @param NextToken A string that identifies the next page of stack resources that you want
#' to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$list_stack_resources(
#'   StackName = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_stack_resources
cloudformation_list_stack_resources <- function(StackName, NextToken = NULL) {
  op <- new_operation(
    name = "ListStackResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_stack_resources_input(StackName = StackName, NextToken = NextToken)
  output <- .cloudformation$list_stack_resources_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_stack_resources <- cloudformation_list_stack_resources

#' Returns summary information about the results of a stack set operation
#'
#' @description
#' Returns summary information about the results of a stack set operation.
#'
#' @usage
#' cloudformation_list_stack_set_operation_results(StackSetName,
#'   OperationId, NextToken, MaxResults)
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to get operation
#' results for.
#' @param OperationId &#91;required&#93; The ID of the stack set operation.
#' @param NextToken If the previous request didn't return all of the remaining results, the
#' response object's `NextToken` parameter value is set to a token. To
#' retrieve the next set of results, call `ListStackSetOperationResults`
#' again and assign that token to the request object's `NextToken`
#' parameter. If there are no remaining results, the previous response
#' object's `NextToken` parameter is set to `null`.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_stack_set_operation_results(
#'   StackSetName = "string",
#'   OperationId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_stack_set_operation_results
cloudformation_list_stack_set_operation_results <- function(StackSetName, OperationId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListStackSetOperationResults",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_stack_set_operation_results_input(StackSetName = StackSetName, OperationId = OperationId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudformation$list_stack_set_operation_results_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_stack_set_operation_results <- cloudformation_list_stack_set_operation_results

#' Returns summary information about operations performed on a stack set
#'
#' @description
#' Returns summary information about operations performed on a stack set.
#'
#' @usage
#' cloudformation_list_stack_set_operations(StackSetName, NextToken,
#'   MaxResults)
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to get operation
#' summaries for.
#' @param NextToken If the previous paginated request didn't return all of the remaining
#' results, the response object's `NextToken` parameter value is set to a
#' token. To retrieve the next set of results, call
#' `ListStackSetOperations` again and assign that token to the request
#' object's `NextToken` parameter. If there are no remaining results, the
#' previous response object's `NextToken` parameter is set to `null`.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_stack_set_operations(
#'   StackSetName = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_stack_set_operations
cloudformation_list_stack_set_operations <- function(StackSetName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListStackSetOperations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_stack_set_operations_input(StackSetName = StackSetName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudformation$list_stack_set_operations_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_stack_set_operations <- cloudformation_list_stack_set_operations

#' Returns summary information about stack sets that are associated with
#' the user
#'
#' @description
#' Returns summary information about stack sets that are associated with
#' the user.
#'
#' @usage
#' cloudformation_list_stack_sets(NextToken, MaxResults, Status)
#'
#' @param NextToken If the previous paginated request didn't return all of the remaining
#' results, the response object's `NextToken` parameter value is set to a
#' token. To retrieve the next set of results, call `ListStackSets` again
#' and assign that token to the request object's `NextToken` parameter. If
#' there are no remaining results, the previous response object's
#' `NextToken` parameter is set to `null`.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#' @param Status The status of the stack sets that you want to get summary information
#' about.
#'
#' @section Request syntax:
#' ```
#' svc$list_stack_sets(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Status = "ACTIVE"|"DELETED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_stack_sets
cloudformation_list_stack_sets <- function(NextToken = NULL, MaxResults = NULL, Status = NULL) {
  op <- new_operation(
    name = "ListStackSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_stack_sets_input(NextToken = NextToken, MaxResults = MaxResults, Status = Status)
  output <- .cloudformation$list_stack_sets_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_stack_sets <- cloudformation_list_stack_sets

#' Returns the summary information for stacks whose status matches the
#' specified StackStatusFilter
#'
#' @description
#' Returns the summary information for stacks whose status matches the
#' specified StackStatusFilter. Summary information for stacks that have
#' been deleted is kept for 90 days after the stack is deleted. If no
#' StackStatusFilter is specified, summary information for all stacks is
#' returned (including existing stacks and stacks that have been deleted).
#'
#' @usage
#' cloudformation_list_stacks(NextToken, StackStatusFilter)
#'
#' @param NextToken A string that identifies the next page of stacks that you want to
#' retrieve.
#' @param StackStatusFilter Stack status to use as a filter. Specify one or more stack status codes
#' to list only stacks with the specified status codes. For a complete list
#' of stack status codes, see the `StackStatus` parameter of the Stack data
#' type.
#'
#' @section Request syntax:
#' ```
#' svc$list_stacks(
#'   NextToken = "string",
#'   StackStatusFilter = list(
#'     "CREATE_IN_PROGRESS"|"CREATE_FAILED"|"CREATE_COMPLETE"|"ROLLBACK_IN_PROGRESS"|"ROLLBACK_FAILED"|"ROLLBACK_COMPLETE"|"DELETE_IN_PROGRESS"|"DELETE_FAILED"|"DELETE_COMPLETE"|"UPDATE_IN_PROGRESS"|"UPDATE_COMPLETE_CLEANUP_IN_PROGRESS"|"UPDATE_COMPLETE"|"UPDATE_ROLLBACK_IN_PROGRESS"|"UPDATE_ROLLBACK_FAILED"|"UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS"|"UPDATE_ROLLBACK_COMPLETE"|"REVIEW_IN_PROGRESS"|"IMPORT_IN_PROGRESS"|"IMPORT_COMPLETE"|"IMPORT_ROLLBACK_IN_PROGRESS"|"IMPORT_ROLLBACK_FAILED"|"IMPORT_ROLLBACK_COMPLETE"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_stacks
cloudformation_list_stacks <- function(NextToken = NULL, StackStatusFilter = NULL) {
  op <- new_operation(
    name = "ListStacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_stacks_input(NextToken = NextToken, StackStatusFilter = StackStatusFilter)
  output <- .cloudformation$list_stacks_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_stacks <- cloudformation_list_stacks

#' Returns a list of registration tokens for the specified type(s)
#'
#' @description
#' Returns a list of registration tokens for the specified type(s).
#'
#' @usage
#' cloudformation_list_type_registrations(Type, TypeName, TypeArn,
#'   RegistrationStatusFilter, MaxResults, NextToken)
#'
#' @param Type The kind of type.
#' 
#' Currently the only valid value is `RESOURCE`.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param TypeName The name of the type.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param TypeArn The Amazon Resource Name (ARN) of the type.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param RegistrationStatusFilter The current status of the type registration request.
#' 
#' The default is `IN_PROGRESS`.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#' @param NextToken If the previous paginated request didn't return all of the remaining
#' results, the response object's `NextToken` parameter value is set to a
#' token. To retrieve the next set of results, call this action again and
#' assign that token to the request object's `NextToken` parameter. If
#' there are no remaining results, the previous response object's
#' `NextToken` parameter is set to `null`.
#'
#' @section Request syntax:
#' ```
#' svc$list_type_registrations(
#'   Type = "RESOURCE"|"MODULE",
#'   TypeName = "string",
#'   TypeArn = "string",
#'   RegistrationStatusFilter = "COMPLETE"|"IN_PROGRESS"|"FAILED",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_type_registrations
cloudformation_list_type_registrations <- function(Type = NULL, TypeName = NULL, TypeArn = NULL, RegistrationStatusFilter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTypeRegistrations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_type_registrations_input(Type = Type, TypeName = TypeName, TypeArn = TypeArn, RegistrationStatusFilter = RegistrationStatusFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudformation$list_type_registrations_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_type_registrations <- cloudformation_list_type_registrations

#' Returns summary information about the versions of a type
#'
#' @description
#' Returns summary information about the versions of a type.
#'
#' @usage
#' cloudformation_list_type_versions(Type, TypeName, Arn, MaxResults,
#'   NextToken, DeprecatedStatus)
#'
#' @param Type The kind of the type.
#' 
#' Currently the only valid value is `RESOURCE`.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param TypeName The name of the type for which you want version summary information.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param Arn The Amazon Resource Name (ARN) of the type for which you want version
#' summary information.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#' @param NextToken If the previous paginated request didn't return all of the remaining
#' results, the response object's `NextToken` parameter value is set to a
#' token. To retrieve the next set of results, call this action again and
#' assign that token to the request object's `NextToken` parameter. If
#' there are no remaining results, the previous response object's
#' `NextToken` parameter is set to `null`.
#' @param DeprecatedStatus The deprecation status of the type versions that you want to get summary
#' information about.
#' 
#' Valid values include:
#' 
#' -   `LIVE`: The type version is registered and can be used in
#'     CloudFormation operations, dependent on its provisioning behavior
#'     and visibility scope.
#' 
#' -   `DEPRECATED`: The type version has been deregistered and can no
#'     longer be used in CloudFormation operations.
#' 
#' The default is `LIVE`.
#'
#' @section Request syntax:
#' ```
#' svc$list_type_versions(
#'   Type = "RESOURCE"|"MODULE",
#'   TypeName = "string",
#'   Arn = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DeprecatedStatus = "LIVE"|"DEPRECATED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_type_versions
cloudformation_list_type_versions <- function(Type = NULL, TypeName = NULL, Arn = NULL, MaxResults = NULL, NextToken = NULL, DeprecatedStatus = NULL) {
  op <- new_operation(
    name = "ListTypeVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_type_versions_input(Type = Type, TypeName = TypeName, Arn = Arn, MaxResults = MaxResults, NextToken = NextToken, DeprecatedStatus = DeprecatedStatus)
  output <- .cloudformation$list_type_versions_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_type_versions <- cloudformation_list_type_versions

#' Returns summary information about types that have been registered with
#' CloudFormation
#'
#' @description
#' Returns summary information about types that have been registered with
#' CloudFormation.
#'
#' @usage
#' cloudformation_list_types(Visibility, ProvisioningType,
#'   DeprecatedStatus, Type, MaxResults, NextToken)
#'
#' @param Visibility The scope at which the type is visible and usable in CloudFormation
#' operations.
#' 
#' Valid values include:
#' 
#' -   `PRIVATE`: The type is only visible and usable within the account in
#'     which it is registered. Currently, AWS CloudFormation marks any
#'     types you create as `PRIVATE`.
#' 
#' -   `PUBLIC`: The type is publically visible and usable within any
#'     Amazon account.
#' 
#' The default is `PRIVATE`.
#' @param ProvisioningType The provisioning behavior of the type. AWS CloudFormation determines the
#' provisioning type during registration, based on the types of handlers in
#' the schema handler package submitted.
#' 
#' Valid values include:
#' 
#' -   `FULLY_MUTABLE`: The type includes an update handler to process
#'     updates to the type during stack update operations.
#' 
#' -   `IMMUTABLE`: The type does not include an update handler, so the
#'     type cannot be updated and must instead be replaced during stack
#'     update operations.
#' 
#' -   `NON_PROVISIONABLE`: The type does not include create, read, and
#'     delete handlers, and therefore cannot actually be provisioned.
#' @param DeprecatedStatus The deprecation status of the types that you want to get summary
#' information about.
#' 
#' Valid values include:
#' 
#' -   `LIVE`: The type is registered for use in CloudFormation operations.
#' 
#' -   `DEPRECATED`: The type has been deregistered and can no longer be
#'     used in CloudFormation operations.
#' @param Type The type of extension.
#' @param MaxResults The maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#' @param NextToken If the previous paginated request didn't return all of the remaining
#' results, the response object's `NextToken` parameter value is set to a
#' token. To retrieve the next set of results, call this action again and
#' assign that token to the request object's `NextToken` parameter. If
#' there are no remaining results, the previous response object's
#' `NextToken` parameter is set to `null`.
#'
#' @section Request syntax:
#' ```
#' svc$list_types(
#'   Visibility = "PUBLIC"|"PRIVATE",
#'   ProvisioningType = "NON_PROVISIONABLE"|"IMMUTABLE"|"FULLY_MUTABLE",
#'   DeprecatedStatus = "LIVE"|"DEPRECATED",
#'   Type = "RESOURCE"|"MODULE",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_list_types
cloudformation_list_types <- function(Visibility = NULL, ProvisioningType = NULL, DeprecatedStatus = NULL, Type = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$list_types_input(Visibility = Visibility, ProvisioningType = ProvisioningType, DeprecatedStatus = DeprecatedStatus, Type = Type, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cloudformation$list_types_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$list_types <- cloudformation_list_types

#' Reports progress of a resource handler to CloudFormation
#'
#' @description
#' Reports progress of a resource handler to CloudFormation.
#' 
#' Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#' Do not use this API in your code.
#'
#' @usage
#' cloudformation_record_handler_progress(BearerToken, OperationStatus,
#'   CurrentOperationStatus, StatusMessage, ErrorCode, ResourceModel,
#'   ClientRequestToken)
#'
#' @param BearerToken &#91;required&#93; Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#' @param OperationStatus &#91;required&#93; Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#' @param CurrentOperationStatus Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#' @param StatusMessage Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#' @param ErrorCode Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#' @param ResourceModel Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#' @param ClientRequestToken Reserved for use by the [CloudFormation
#' CLI](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/what-is-cloudformation-cli.html).
#'
#' @section Request syntax:
#' ```
#' svc$record_handler_progress(
#'   BearerToken = "string",
#'   OperationStatus = "PENDING"|"IN_PROGRESS"|"SUCCESS"|"FAILED",
#'   CurrentOperationStatus = "PENDING"|"IN_PROGRESS"|"SUCCESS"|"FAILED",
#'   StatusMessage = "string",
#'   ErrorCode = "NotUpdatable"|"InvalidRequest"|"AccessDenied"|"InvalidCredentials"|"AlreadyExists"|"NotFound"|"ResourceConflict"|"Throttling"|"ServiceLimitExceeded"|"NotStabilized"|"GeneralServiceException"|"ServiceInternalError"|"NetworkFailure"|"InternalFailure",
#'   ResourceModel = "string",
#'   ClientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_record_handler_progress
cloudformation_record_handler_progress <- function(BearerToken, OperationStatus, CurrentOperationStatus = NULL, StatusMessage = NULL, ErrorCode = NULL, ResourceModel = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "RecordHandlerProgress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$record_handler_progress_input(BearerToken = BearerToken, OperationStatus = OperationStatus, CurrentOperationStatus = CurrentOperationStatus, StatusMessage = StatusMessage, ErrorCode = ErrorCode, ResourceModel = ResourceModel, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$record_handler_progress_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$record_handler_progress <- cloudformation_record_handler_progress

#' Registers a type with the CloudFormation service
#'
#' @description
#' Registers a type with the CloudFormation service. Registering a type
#' makes it available for use in CloudFormation templates in your AWS
#' account, and includes:
#' 
#' -   Validating the resource schema
#' 
#' -   Determining which handlers have been specified for the resource
#' 
#' -   Making the resource type available for use in your account
#' 
#' For more information on how to develop types and ready them for
#' registeration, see [Creating Resource
#' Providers](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html)
#' in the *CloudFormation CLI User Guide*.
#' 
#' You can have a maximum of 50 resource type versions registered at a
#' time. This maximum is per account and per region. Use
#' [DeregisterType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeregisterType.html)
#' to deregister specific resource type versions if necessary.
#' 
#' Once you have initiated a registration request using
#' ` <a>RegisterType</a> `, you can use ` <a>DescribeTypeRegistration</a> `
#' to monitor the progress of the registration request.
#'
#' @usage
#' cloudformation_register_type(Type, TypeName, SchemaHandlerPackage,
#'   LoggingConfig, ExecutionRoleArn, ClientRequestToken)
#'
#' @param Type The kind of type.
#' 
#' Currently, the only valid value is `RESOURCE`.
#' @param TypeName &#91;required&#93; The name of the type being registered.
#' 
#' We recommend that type names adhere to the following pattern:
#' *company\\_or\\_organization*::*service*::*type*.
#' 
#' The following organization namespaces are reserved and cannot be used in
#' your resource type names:
#' 
#' -   `Alexa`
#' 
#' -   `AMZN`
#' 
#' -   `Amazon`
#' 
#' -   `AWS`
#' 
#' -   `Custom`
#' 
#' -   `Dev`
#' @param SchemaHandlerPackage &#91;required&#93; A url to the S3 bucket containing the schema handler package that
#' contains the schema, event handlers, and associated files for the type
#' you want to register.
#' 
#' For information on generating a schema handler package for the type you
#' want to register, see
#' [submit](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html)
#' in the *CloudFormation CLI User Guide*.
#' 
#' The user registering the resource provider type must be able to access
#' the the schema handler package in the S3 bucket. That is, the user needs
#' to have
#' [GetObject](https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html)
#' permissions for the schema handler package. For more information, see
#' [Actions, Resources, and Condition Keys for Amazon
#' S3](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3.html)
#' in the *AWS Identity and Access Management User Guide*.
#' @param LoggingConfig Specifies logging configuration information for a type.
#' @param ExecutionRoleArn The Amazon Resource Name (ARN) of the IAM role for CloudFormation to
#' assume when invoking the resource provider. If your resource type calls
#' AWS APIs in any of its handlers, you must create an *[IAM execution
#' role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html)*
#' that includes the necessary permissions to call those AWS APIs, and
#' provision that execution role in your account. When CloudFormation needs
#' to invoke the resource provider handler, CloudFormation assumes this
#' execution role to create a temporary session token, which it then passes
#' to the resource provider handler, thereby supplying your resource
#' provider with the appropriate credentials.
#' @param ClientRequestToken A unique identifier that acts as an idempotency key for this
#' registration request. Specifying a client request token prevents
#' CloudFormation from generating more than one version of a type from the
#' same registeration request, even if the request is submitted multiple
#' times.
#'
#' @section Request syntax:
#' ```
#' svc$register_type(
#'   Type = "RESOURCE"|"MODULE",
#'   TypeName = "string",
#'   SchemaHandlerPackage = "string",
#'   LoggingConfig = list(
#'     LogRoleArn = "string",
#'     LogGroupName = "string"
#'   ),
#'   ExecutionRoleArn = "string",
#'   ClientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_register_type
cloudformation_register_type <- function(Type = NULL, TypeName, SchemaHandlerPackage, LoggingConfig = NULL, ExecutionRoleArn = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "RegisterType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$register_type_input(Type = Type, TypeName = TypeName, SchemaHandlerPackage = SchemaHandlerPackage, LoggingConfig = LoggingConfig, ExecutionRoleArn = ExecutionRoleArn, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$register_type_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$register_type <- cloudformation_register_type

#' Sets a stack policy for a specified stack
#'
#' @description
#' Sets a stack policy for a specified stack.
#'
#' @usage
#' cloudformation_set_stack_policy(StackName, StackPolicyBody,
#'   StackPolicyURL)
#'
#' @param StackName &#91;required&#93; The name or unique stack ID that you want to associate a policy with.
#' @param StackPolicyBody Structure containing the stack policy body. For more information, go to
#' [Prevent Updates to Stack
#' Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
#' in the AWS CloudFormation User Guide. You can specify either the
#' `StackPolicyBody` or the `StackPolicyURL` parameter, but not both.
#' @param StackPolicyURL Location of a file containing the stack policy. The URL must point to a
#' policy (maximum size: 16 KB) located in an S3 bucket in the same Region
#' as the stack. You can specify either the `StackPolicyBody` or the
#' `StackPolicyURL` parameter, but not both.
#'
#' @section Request syntax:
#' ```
#' svc$set_stack_policy(
#'   StackName = "string",
#'   StackPolicyBody = "string",
#'   StackPolicyURL = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_set_stack_policy
cloudformation_set_stack_policy <- function(StackName, StackPolicyBody = NULL, StackPolicyURL = NULL) {
  op <- new_operation(
    name = "SetStackPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$set_stack_policy_input(StackName = StackName, StackPolicyBody = StackPolicyBody, StackPolicyURL = StackPolicyURL)
  output <- .cloudformation$set_stack_policy_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$set_stack_policy <- cloudformation_set_stack_policy

#' Specify the default version of a type
#'
#' @description
#' Specify the default version of a type. The default version of a type
#' will be used in CloudFormation operations.
#'
#' @usage
#' cloudformation_set_type_default_version(Arn, Type, TypeName, VersionId)
#'
#' @param Arn The Amazon Resource Name (ARN) of the type for which you want version
#' summary information.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param Type The kind of type.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param TypeName The name of the type.
#' 
#' Conditional: You must specify either `TypeName` and `Type`, or `Arn`.
#' @param VersionId The ID of a specific version of the type. The version ID is the value at
#' the end of the Amazon Resource Name (ARN) assigned to the type version
#' when it is registered.
#'
#' @section Request syntax:
#' ```
#' svc$set_type_default_version(
#'   Arn = "string",
#'   Type = "RESOURCE"|"MODULE",
#'   TypeName = "string",
#'   VersionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_set_type_default_version
cloudformation_set_type_default_version <- function(Arn = NULL, Type = NULL, TypeName = NULL, VersionId = NULL) {
  op <- new_operation(
    name = "SetTypeDefaultVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$set_type_default_version_input(Arn = Arn, Type = Type, TypeName = TypeName, VersionId = VersionId)
  output <- .cloudformation$set_type_default_version_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$set_type_default_version <- cloudformation_set_type_default_version

#' Sends a signal to the specified resource with a success or failure
#' status
#'
#' @description
#' Sends a signal to the specified resource with a success or failure
#' status. You can use the SignalResource API in conjunction with a
#' creation policy or update policy. AWS CloudFormation doesn't proceed
#' with a stack creation or update until resources receive the required
#' number of signals or the timeout period is exceeded. The SignalResource
#' API is useful in cases where you want to send signals from anywhere
#' other than an Amazon EC2 instance.
#'
#' @usage
#' cloudformation_signal_resource(StackName, LogicalResourceId, UniqueId,
#'   Status)
#'
#' @param StackName &#91;required&#93; The stack name or unique stack ID that includes the resource that you
#' want to signal.
#' @param LogicalResourceId &#91;required&#93; The logical ID of the resource that you want to signal. The logical ID
#' is the name of the resource that given in the template.
#' @param UniqueId &#91;required&#93; A unique ID of the signal. When you signal Amazon EC2 instances or Auto
#' Scaling groups, specify the instance ID that you are signaling as the
#' unique ID. If you send multiple signals to a single resource (such as
#' signaling a wait condition), each signal requires a different unique ID.
#' @param Status &#91;required&#93; The status of the signal, which is either success or failure. A failure
#' signal causes AWS CloudFormation to immediately fail the stack creation
#' or update.
#'
#' @section Request syntax:
#' ```
#' svc$signal_resource(
#'   StackName = "string",
#'   LogicalResourceId = "string",
#'   UniqueId = "string",
#'   Status = "SUCCESS"|"FAILURE"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_signal_resource
cloudformation_signal_resource <- function(StackName, LogicalResourceId, UniqueId, Status) {
  op <- new_operation(
    name = "SignalResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$signal_resource_input(StackName = StackName, LogicalResourceId = LogicalResourceId, UniqueId = UniqueId, Status = Status)
  output <- .cloudformation$signal_resource_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$signal_resource <- cloudformation_signal_resource

#' Stops an in-progress operation on a stack set and its associated stack
#' instances
#'
#' @description
#' Stops an in-progress operation on a stack set and its associated stack
#' instances.
#'
#' @usage
#' cloudformation_stop_stack_set_operation(StackSetName, OperationId)
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to stop the
#' operation for.
#' @param OperationId &#91;required&#93; The ID of the stack operation.
#'
#' @section Request syntax:
#' ```
#' svc$stop_stack_set_operation(
#'   StackSetName = "string",
#'   OperationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_stop_stack_set_operation
cloudformation_stop_stack_set_operation <- function(StackSetName, OperationId) {
  op <- new_operation(
    name = "StopStackSetOperation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$stop_stack_set_operation_input(StackSetName = StackSetName, OperationId = OperationId)
  output <- .cloudformation$stop_stack_set_operation_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$stop_stack_set_operation <- cloudformation_stop_stack_set_operation

#' Updates a stack as specified in the template
#'
#' @description
#' Updates a stack as specified in the template. After the call completes
#' successfully, the stack update starts. You can check the status of the
#' stack via the DescribeStacks action.
#' 
#' To get a copy of the template for an existing stack, you can use the
#' GetTemplate action.
#' 
#' For more information about creating an update template, updating a
#' stack, and monitoring the progress of the update, see [Updating a
#' Stack](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
#'
#' @usage
#' cloudformation_update_stack(StackName, TemplateBody, TemplateURL,
#'   UsePreviousTemplate, StackPolicyDuringUpdateBody,
#'   StackPolicyDuringUpdateURL, Parameters, Capabilities, ResourceTypes,
#'   RoleARN, RollbackConfiguration, StackPolicyBody, StackPolicyURL,
#'   NotificationARNs, Tags, ClientRequestToken)
#'
#' @param StackName &#91;required&#93; The name or unique stack ID of the stack to update.
#' @param TemplateBody Structure containing the template body with a minimum length of 1 byte
#' and a maximum length of 51,200 bytes. (For more information, go to
#' [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.)
#' 
#' Conditional: You must specify only one of the following parameters:
#' `TemplateBody`, `TemplateURL`, or set the `UsePreviousTemplate` to
#' `true`.
#' @param TemplateURL Location of file containing the template body. The URL must point to a
#' template that is located in an Amazon S3 bucket. For more information,
#' go to [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `TemplateBody`, `TemplateURL`, or set the `UsePreviousTemplate` to
#' `true`.
#' @param UsePreviousTemplate Reuse the existing template that is associated with the stack that you
#' are updating.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `TemplateBody`, `TemplateURL`, or set the `UsePreviousTemplate` to
#' `true`.
#' @param StackPolicyDuringUpdateBody Structure containing the temporary overriding stack policy body. You can
#' specify either the `StackPolicyDuringUpdateBody` or the
#' `StackPolicyDuringUpdateURL` parameter, but not both.
#' 
#' If you want to update protected resources, specify a temporary
#' overriding stack policy during this update. If you do not specify a
#' stack policy, the current policy that is associated with the stack will
#' be used.
#' @param StackPolicyDuringUpdateURL Location of a file containing the temporary overriding stack policy. The
#' URL must point to a policy (max size: 16KB) located in an S3 bucket in
#' the same Region as the stack. You can specify either the
#' `StackPolicyDuringUpdateBody` or the `StackPolicyDuringUpdateURL`
#' parameter, but not both.
#' 
#' If you want to update protected resources, specify a temporary
#' overriding stack policy during this update. If you do not specify a
#' stack policy, the current policy that is associated with the stack will
#' be used.
#' @param Parameters A list of `Parameter` structures that specify input parameters for the
#' stack. For more information, see the
#' [Parameter](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
#' data type.
#' @param Capabilities In some cases, you must explicitly acknowledge that your stack template
#' contains certain capabilities in order for AWS CloudFormation to update
#' the stack.
#' 
#' -   `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`
#' 
#'     Some stack templates might include resources that can affect
#'     permissions in your AWS account; for example, by creating new AWS
#'     Identity and Access Management (IAM) users. For those stacks, you
#'     must explicitly acknowledge this by specifying one of these
#'     capabilities.
#' 
#'     The following IAM resources require you to specify either the
#'     `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
#' 
#'     -   If you have IAM resources, you can specify either capability.
#' 
#'     -   If you have IAM resources with custom names, you *must* specify
#'         `CAPABILITY_NAMED_IAM`.
#' 
#'     -   If you don't specify either of these capabilities, AWS
#'         CloudFormation returns an `InsufficientCapabilities` error.
#' 
#'     If your stack template contains these resources, we recommend that
#'     you review all permissions associated with them and edit their
#'     permissions if necessary.
#' 
#'     -   [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
#' 
#'     -   [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
#' 
#'     -   [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
#' 
#'     -   [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
#' 
#'     -   [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
#' 
#'     -   [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
#' 
#'     -   [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
#' 
#'     For more information, see [Acknowledging IAM Resources in AWS
#'     CloudFormation
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
#' 
#' -   `CAPABILITY_AUTO_EXPAND`
#' 
#'     Some template contain macros. Macros perform custom processing on
#'     templates; this can include simple actions like find-and-replace
#'     operations, all the way to extensive transformations of entire
#'     templates. Because of this, users typically create a change set from
#'     the processed template, so that they can review the changes
#'     resulting from the macros before actually updating the stack. If
#'     your stack template contains one or more macros, and you choose to
#'     update a stack directly from the processed template, without first
#'     reviewing the resulting changes in a change set, you must
#'     acknowledge this capability. This includes the
#'     [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
#'     and
#'     [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
#'     transforms, which are macros hosted by AWS CloudFormation.
#' 
#'     If you want to update a stack from a stack template that contains
#'     macros *and* nested stacks, you must update the stack directly from
#'     the template using this capability.
#' 
#'     You should only update stacks directly from a stack template that
#'     contains macros if you know what processing the macro performs.
#' 
#'     Each macro relies on an underlying Lambda service function for
#'     processing stack templates. Be aware that the Lambda function owner
#'     can update the function operation without AWS CloudFormation being
#'     notified.
#' 
#'     For more information, see [Using AWS CloudFormation Macros to
#'     Perform Custom Processing on
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
#' @param ResourceTypes The template resource types that you have permissions to work with for
#' this update stack action, such as `AWS::EC2::Instance`, `AWS::EC2::*`,
#' or `Custom::MyCustomInstance`.
#' 
#' If the list of resource types doesn't include a resource that you're
#' updating, the stack update fails. By default, AWS CloudFormation grants
#' permissions to all resource types. AWS Identity and Access Management
#' (IAM) uses this parameter for AWS CloudFormation-specific condition keys
#' in IAM policies. For more information, see [Controlling Access with AWS
#' Identity and Access
#' Management](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html).
#' @param RoleARN The Amazon Resource Name (ARN) of an AWS Identity and Access Management
#' (IAM) role that AWS CloudFormation assumes to update the stack. AWS
#' CloudFormation uses the role's credentials to make calls on your behalf.
#' AWS CloudFormation always uses this role for all future operations on
#' the stack. As long as users have permission to operate on the stack, AWS
#' CloudFormation uses this role even if the users don't have permission to
#' pass it. Ensure that the role grants least privilege.
#' 
#' If you don't specify a value, AWS CloudFormation uses the role that was
#' previously associated with the stack. If no role is available, AWS
#' CloudFormation uses a temporary session that is generated from your user
#' credentials.
#' @param RollbackConfiguration The rollback triggers for AWS CloudFormation to monitor during stack
#' creation and updating operations, and for the specified monitoring
#' period afterwards.
#' @param StackPolicyBody Structure containing a new stack policy body. You can specify either the
#' `StackPolicyBody` or the `StackPolicyURL` parameter, but not both.
#' 
#' You might update the stack policy, for example, in order to protect a
#' new resource that you created during a stack update. If you do not
#' specify a stack policy, the current policy that is associated with the
#' stack is unchanged.
#' @param StackPolicyURL Location of a file containing the updated stack policy. The URL must
#' point to a policy (max size: 16KB) located in an S3 bucket in the same
#' Region as the stack. You can specify either the `StackPolicyBody` or the
#' `StackPolicyURL` parameter, but not both.
#' 
#' You might update the stack policy, for example, in order to protect a
#' new resource that you created during a stack update. If you do not
#' specify a stack policy, the current policy that is associated with the
#' stack is unchanged.
#' @param NotificationARNs Amazon Simple Notification Service topic Amazon Resource Names (ARNs)
#' that AWS CloudFormation associates with the stack. Specify an empty list
#' to remove all notification topics.
#' @param Tags Key-value pairs to associate with this stack. AWS CloudFormation also
#' propagates these tags to supported resources in the stack. You can
#' specify a maximum number of 50 tags.
#' 
#' If you don't specify this parameter, AWS CloudFormation doesn't modify
#' the stack's tags. If you specify an empty value, AWS CloudFormation
#' removes all associated tags.
#' @param ClientRequestToken A unique identifier for this `UpdateStack` request. Specify this token
#' if you plan to retry requests so that AWS CloudFormation knows that
#' you're not attempting to update a stack with the same name. You might
#' retry `UpdateStack` requests to ensure that AWS CloudFormation
#' successfully received them.
#' 
#' All events triggered by a given stack operation are assigned the same
#' client request token, which you can use to track operations. For
#' example, if you execute a `CreateStack` operation with the token
#' `token1`, then all the `StackEvents` generated by that operation will
#' have `ClientRequestToken` set as `token1`.
#' 
#' In the console, stack operations display the client request token on the
#' Events tab. Stack operations that are initiated from the console use the
#' token format *Console-StackOperation-ID*, which helps you easily
#' identify the stack operation . For example, if you create a stack using
#' the console, each stack event would be assigned the same token in the
#' following format:
#' `Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002`.
#'
#' @section Request syntax:
#' ```
#' svc$update_stack(
#'   StackName = "string",
#'   TemplateBody = "string",
#'   TemplateURL = "string",
#'   UsePreviousTemplate = TRUE|FALSE,
#'   StackPolicyDuringUpdateBody = "string",
#'   StackPolicyDuringUpdateURL = "string",
#'   Parameters = list(
#'     list(
#'       ParameterKey = "string",
#'       ParameterValue = "string",
#'       UsePreviousValue = TRUE|FALSE,
#'       ResolvedValue = "string"
#'     )
#'   ),
#'   Capabilities = list(
#'     "CAPABILITY_IAM"|"CAPABILITY_NAMED_IAM"|"CAPABILITY_AUTO_EXPAND"
#'   ),
#'   ResourceTypes = list(
#'     "string"
#'   ),
#'   RoleARN = "string",
#'   RollbackConfiguration = list(
#'     RollbackTriggers = list(
#'       list(
#'         Arn = "string",
#'         Type = "string"
#'       )
#'     ),
#'     MonitoringTimeInMinutes = 123
#'   ),
#'   StackPolicyBody = "string",
#'   StackPolicyURL = "string",
#'   NotificationARNs = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ClientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_update_stack
cloudformation_update_stack <- function(StackName, TemplateBody = NULL, TemplateURL = NULL, UsePreviousTemplate = NULL, StackPolicyDuringUpdateBody = NULL, StackPolicyDuringUpdateURL = NULL, Parameters = NULL, Capabilities = NULL, ResourceTypes = NULL, RoleARN = NULL, RollbackConfiguration = NULL, StackPolicyBody = NULL, StackPolicyURL = NULL, NotificationARNs = NULL, Tags = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$update_stack_input(StackName = StackName, TemplateBody = TemplateBody, TemplateURL = TemplateURL, UsePreviousTemplate = UsePreviousTemplate, StackPolicyDuringUpdateBody = StackPolicyDuringUpdateBody, StackPolicyDuringUpdateURL = StackPolicyDuringUpdateURL, Parameters = Parameters, Capabilities = Capabilities, ResourceTypes = ResourceTypes, RoleARN = RoleARN, RollbackConfiguration = RollbackConfiguration, StackPolicyBody = StackPolicyBody, StackPolicyURL = StackPolicyURL, NotificationARNs = NotificationARNs, Tags = Tags, ClientRequestToken = ClientRequestToken)
  output <- .cloudformation$update_stack_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$update_stack <- cloudformation_update_stack

#' Updates the parameter values for stack instances for the specified
#' accounts, within the specified Regions
#'
#' @description
#' Updates the parameter values for stack instances for the specified
#' accounts, within the specified Regions. A stack instance refers to a
#' stack in a specific account and Region.
#' 
#' You can only update stack instances in Regions and accounts where they
#' already exist; to create additional stack instances, use
#' [CreateStackInstances](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStackInstances.html).
#' 
#' During stack set updates, any parameters overridden for a stack instance
#' are not updated, but retain their overridden value.
#' 
#' You can only update the parameter *values* that are specified in the
#' stack set; to add or delete a parameter itself, use
#' [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
#' to update the stack set template. If you add a parameter to a template,
#' before you can override the parameter value specified in the stack set
#' you must first use
#' [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
#' to update all stack instances with the updated template and parameter
#' value specified in the stack set. Once a stack instance has been updated
#' with the new parameter, you can then override the parameter value using
#' `UpdateStackInstances`.
#'
#' @usage
#' cloudformation_update_stack_instances(StackSetName, Accounts,
#'   DeploymentTargets, Regions, ParameterOverrides, OperationPreferences,
#'   OperationId)
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set associated with the stack
#' instances.
#' @param Accounts \[`Self-managed` permissions\] The names of one or more AWS accounts for
#' which you want to update parameter values for stack instances. The
#' overridden parameter values will be applied to all stack instances in
#' the specified accounts and Regions.
#' 
#' You can specify `Accounts` or `DeploymentTargets`, but not both.
#' @param DeploymentTargets \[`Service-managed` permissions\] The AWS Organizations accounts for
#' which you want to update parameter values for stack instances. If your
#' update targets OUs, the overridden parameter values only apply to the
#' accounts that are currently in the target OUs and their child OUs.
#' Accounts added to the target OUs and their child OUs in the future won't
#' use the overridden values.
#' 
#' You can specify `Accounts` or `DeploymentTargets`, but not both.
#' @param Regions &#91;required&#93; The names of one or more Regions in which you want to update parameter
#' values for stack instances. The overridden parameter values will be
#' applied to all stack instances in the specified accounts and Regions.
#' @param ParameterOverrides A list of input parameters whose values you want to update for the
#' specified stack instances.
#' 
#' Any overridden parameter values will be applied to all stack instances
#' in the specified accounts and Regions. When specifying parameters and
#' their values, be aware of how AWS CloudFormation sets parameter values
#' during stack instance update operations:
#' 
#' -   To override the current value for a parameter, include the parameter
#'     and specify its value.
#' 
#' -   To leave a parameter set to its present value, you can do one of the
#'     following:
#' 
#'     -   Do not include the parameter in the list.
#' 
#'     -   Include the parameter and specify `UsePreviousValue` as `true`.
#'         (You cannot specify both a value and set `UsePreviousValue` to
#'         `true`.)
#' 
#' -   To set all overridden parameter back to the values specified in the
#'     stack set, specify a parameter list but do not include any
#'     parameters.
#' 
#' -   To leave all parameters set to their present values, do not specify
#'     this property at all.
#' 
#' During stack set updates, any parameter values overridden for a stack
#' instance are not updated, but retain their overridden value.
#' 
#' You can only override the parameter *values* that are specified in the
#' stack set; to add or delete a parameter itself, use `UpdateStackSet` to
#' update the stack set template. If you add a parameter to a template,
#' before you can override the parameter value specified in the stack set
#' you must first use
#' [UpdateStackSet](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_UpdateStackSet.html)
#' to update all stack instances with the updated template and parameter
#' value specified in the stack set. Once a stack instance has been updated
#' with the new parameter, you can then override the parameter value using
#' `UpdateStackInstances`.
#' @param OperationPreferences Preferences for how AWS CloudFormation performs this stack set
#' operation.
#' @param OperationId The unique identifier for this stack set operation.
#' 
#' The operation ID also functions as an idempotency token, to ensure that
#' AWS CloudFormation performs the stack set operation only once, even if
#' you retry the request multiple times. You might retry stack set
#' operation requests to ensure that AWS CloudFormation successfully
#' received them.
#' 
#' If you don't specify an operation ID, the SDK generates one
#' automatically.
#'
#' @section Request syntax:
#' ```
#' svc$update_stack_instances(
#'   StackSetName = "string",
#'   Accounts = list(
#'     "string"
#'   ),
#'   DeploymentTargets = list(
#'     Accounts = list(
#'       "string"
#'     ),
#'     OrganizationalUnitIds = list(
#'       "string"
#'     )
#'   ),
#'   Regions = list(
#'     "string"
#'   ),
#'   ParameterOverrides = list(
#'     list(
#'       ParameterKey = "string",
#'       ParameterValue = "string",
#'       UsePreviousValue = TRUE|FALSE,
#'       ResolvedValue = "string"
#'     )
#'   ),
#'   OperationPreferences = list(
#'     RegionOrder = list(
#'       "string"
#'     ),
#'     FailureToleranceCount = 123,
#'     FailureTolerancePercentage = 123,
#'     MaxConcurrentCount = 123,
#'     MaxConcurrentPercentage = 123
#'   ),
#'   OperationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_update_stack_instances
cloudformation_update_stack_instances <- function(StackSetName, Accounts = NULL, DeploymentTargets = NULL, Regions, ParameterOverrides = NULL, OperationPreferences = NULL, OperationId = NULL) {
  op <- new_operation(
    name = "UpdateStackInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$update_stack_instances_input(StackSetName = StackSetName, Accounts = Accounts, DeploymentTargets = DeploymentTargets, Regions = Regions, ParameterOverrides = ParameterOverrides, OperationPreferences = OperationPreferences, OperationId = OperationId)
  output <- .cloudformation$update_stack_instances_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$update_stack_instances <- cloudformation_update_stack_instances

#' Updates the stack set, and associated stack instances in the specified
#' accounts and Regions
#'
#' @description
#' Updates the stack set, and associated stack instances in the specified
#' accounts and Regions.
#' 
#' Even if the stack set operation created by updating the stack set fails
#' (completely or partially, below or above a specified failure tolerance),
#' the stack set is updated with your changes. Subsequent
#' CreateStackInstances calls on the specified stack set use the updated
#' stack set.
#'
#' @usage
#' cloudformation_update_stack_set(StackSetName, Description, TemplateBody,
#'   TemplateURL, UsePreviousTemplate, Parameters, Capabilities, Tags,
#'   OperationPreferences, AdministrationRoleARN, ExecutionRoleName,
#'   DeploymentTargets, PermissionModel, AutoDeployment, OperationId,
#'   Accounts, Regions)
#'
#' @param StackSetName &#91;required&#93; The name or unique ID of the stack set that you want to update.
#' @param Description A brief description of updates that you are making.
#' @param TemplateBody The structure that contains the template body, with a minimum length of
#' 1 byte and a maximum length of 51,200 bytes. For more information, see
#' [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `TemplateBody` or `TemplateURL`—or set `UsePreviousTemplate` to true.
#' @param TemplateURL The location of the file that contains the template body. The URL must
#' point to a template (maximum size: 460,800 bytes) that is located in an
#' Amazon S3 bucket. For more information, see [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `TemplateBody` or `TemplateURL`—or set `UsePreviousTemplate` to true.
#' @param UsePreviousTemplate Use the existing template that's associated with the stack set that
#' you're updating.
#' 
#' Conditional: You must specify only one of the following parameters:
#' `TemplateBody` or `TemplateURL`—or set `UsePreviousTemplate` to true.
#' @param Parameters A list of input parameters for the stack set template.
#' @param Capabilities In some cases, you must explicitly acknowledge that your stack template
#' contains certain capabilities in order for AWS CloudFormation to update
#' the stack set and its associated stack instances.
#' 
#' -   `CAPABILITY_IAM` and `CAPABILITY_NAMED_IAM`
#' 
#'     Some stack templates might include resources that can affect
#'     permissions in your AWS account; for example, by creating new AWS
#'     Identity and Access Management (IAM) users. For those stacks sets,
#'     you must explicitly acknowledge this by specifying one of these
#'     capabilities.
#' 
#'     The following IAM resources require you to specify either the
#'     `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` capability.
#' 
#'     -   If you have IAM resources, you can specify either capability.
#' 
#'     -   If you have IAM resources with custom names, you *must* specify
#'         `CAPABILITY_NAMED_IAM`.
#' 
#'     -   If you don't specify either of these capabilities, AWS
#'         CloudFormation returns an `InsufficientCapabilities` error.
#' 
#'     If your stack template contains these resources, we recommend that
#'     you review all permissions associated with them and edit their
#'     permissions if necessary.
#' 
#'     -   [AWS::IAM::AccessKey](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html)
#' 
#'     -   [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html)
#' 
#'     -   [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html)
#' 
#'     -   [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html)
#' 
#'     -   [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html)
#' 
#'     -   [AWS::IAM::User](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html)
#' 
#'     -   [AWS::IAM::UserToGroupAddition](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html)
#' 
#'     For more information, see [Acknowledging IAM Resources in AWS
#'     CloudFormation
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities).
#' 
#' -   `CAPABILITY_AUTO_EXPAND`
#' 
#'     Some templates contain macros. If your stack template contains one
#'     or more macros, and you choose to update a stack directly from the
#'     processed template, without first reviewing the resulting changes in
#'     a change set, you must acknowledge this capability. For more
#'     information, see [Using AWS CloudFormation Macros to Perform Custom
#'     Processing on
#'     Templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html).
#' 
#'     Stack sets do not currently support macros in stack templates. (This
#'     includes the
#'     [AWS::Include](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html)
#'     and
#'     [AWS::Serverless](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html)
#'     transforms, which are macros hosted by AWS CloudFormation.) Even if
#'     you specify this capability, if you include a macro in your template
#'     the stack set operation will fail.
#' @param Tags The key-value pairs to associate with this stack set and the stacks
#' created from it. AWS CloudFormation also propagates these tags to
#' supported resources that are created in the stacks. You can specify a
#' maximum number of 50 tags.
#' 
#' If you specify tags for this parameter, those tags replace any list of
#' tags that are currently associated with this stack set. This means:
#' 
#' -   If you don't specify this parameter, AWS CloudFormation doesn't
#'     modify the stack's tags.
#' 
#' -   If you specify *any* tags using this parameter, you must specify
#'     *all* the tags that you want associated with this stack set, even
#'     tags you've specifed before (for example, when creating the stack
#'     set or during a previous update of the stack set.). Any tags that
#'     you don't include in the updated list of tags are removed from the
#'     stack set, and therefore from the stacks and resources as well.
#' 
#' -   If you specify an empty value, AWS CloudFormation removes all
#'     currently associated tags.
#' 
#' If you specify new tags as part of an `UpdateStackSet` action, AWS
#' CloudFormation checks to see if you have the required IAM permission to
#' tag resources. If you omit tags that are currently associated with the
#' stack set from the list of tags you specify, AWS CloudFormation assumes
#' that you want to remove those tags from the stack set, and checks to see
#' if you have permission to untag resources. If you don't have the
#' necessary permission(s), the entire `UpdateStackSet` action fails with
#' an `access denied` error, and the stack set is not updated.
#' @param OperationPreferences Preferences for how AWS CloudFormation performs this stack set
#' operation.
#' @param AdministrationRoleARN The Amazon Resource Number (ARN) of the IAM role to use to update this
#' stack set.
#' 
#' Specify an IAM role only if you are using customized administrator roles
#' to control which users or groups can manage specific stack sets within
#' the same administrator account. For more information, see [Granting
#' Permissions for Stack Set
#' Operations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs.html)
#' in the *AWS CloudFormation User Guide*.
#' 
#' If you specified a customized administrator role when you created the
#' stack set, you must specify a customized administrator role, even if it
#' is the same customized administrator role used with this stack set
#' previously.
#' @param ExecutionRoleName The name of the IAM execution role to use to update the stack set. If
#' you do not specify an execution role, AWS CloudFormation uses the
#' `AWSCloudFormationStackSetExecutionRole` role for the stack set
#' operation.
#' 
#' Specify an IAM role only if you are using customized execution roles to
#' control which stack resources users and groups can include in their
#' stack sets.
#' 
#' If you specify a customized execution role, AWS CloudFormation uses that
#' role to update the stack. If you do not specify a customized execution
#' role, AWS CloudFormation performs the update using the role previously
#' associated with the stack set, so long as you have permissions to
#' perform operations on the stack set.
#' @param DeploymentTargets \[`Service-managed` permissions\] The AWS Organizations accounts in
#' which to update associated stack instances.
#' 
#' To update all the stack instances associated with this stack set, do not
#' specify `DeploymentTargets` or `Regions`.
#' 
#' If the stack set update includes changes to the template (that is, if
#' `TemplateBody` or `TemplateURL` is specified), or the `Parameters`, AWS
#' CloudFormation marks all stack instances with a status of `OUTDATED`
#' prior to updating the stack instances in the specified accounts and
#' Regions. If the stack set update does not include changes to the
#' template or parameters, AWS CloudFormation updates the stack instances
#' in the specified accounts and Regions, while leaving all other stack
#' instances with their existing stack instance status.
#' @param PermissionModel Describes how the IAM roles required for stack set operations are
#' created. You cannot modify `PermissionModel` if there are stack
#' instances associated with your stack set.
#' 
#' -   With `self-managed` permissions, you must create the administrator
#'     and execution roles required to deploy to target accounts. For more
#'     information, see [Grant Self-Managed Stack Set
#'     Permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html).
#' 
#' -   With `service-managed` permissions, StackSets automatically creates
#'     the IAM roles required to deploy to accounts managed by AWS
#'     Organizations. For more information, see [Grant Service-Managed
#'     Stack Set
#'     Permissions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/).
#' @param AutoDeployment \[`Service-managed` permissions\] Describes whether StackSets
#' automatically deploys to AWS Organizations accounts that are added to a
#' target organization or organizational unit (OU).
#' 
#' If you specify `AutoDeployment`, do not specify `DeploymentTargets` or
#' `Regions`.
#' @param OperationId The unique ID for this stack set operation.
#' 
#' The operation ID also functions as an idempotency token, to ensure that
#' AWS CloudFormation performs the stack set operation only once, even if
#' you retry the request multiple times. You might retry stack set
#' operation requests to ensure that AWS CloudFormation successfully
#' received them.
#' 
#' If you don't specify an operation ID, AWS CloudFormation generates one
#' automatically.
#' 
#' Repeating this stack set operation with a new operation ID retries all
#' stack instances whose status is `OUTDATED`.
#' @param Accounts \[`Self-managed` permissions\] The accounts in which to update
#' associated stack instances. If you specify accounts, you must also
#' specify the Regions in which to update stack set instances.
#' 
#' To update *all* the stack instances associated with this stack set, do
#' not specify the `Accounts` or `Regions` properties.
#' 
#' If the stack set update includes changes to the template (that is, if
#' the `TemplateBody` or `TemplateURL` properties are specified), or the
#' `Parameters` property, AWS CloudFormation marks all stack instances with
#' a status of `OUTDATED` prior to updating the stack instances in the
#' specified accounts and Regions. If the stack set update does not include
#' changes to the template or parameters, AWS CloudFormation updates the
#' stack instances in the specified accounts and Regions, while leaving all
#' other stack instances with their existing stack instance status.
#' @param Regions The Regions in which to update associated stack instances. If you
#' specify Regions, you must also specify accounts in which to update stack
#' set instances.
#' 
#' To update *all* the stack instances associated with this stack set, do
#' not specify the `Accounts` or `Regions` properties.
#' 
#' If the stack set update includes changes to the template (that is, if
#' the `TemplateBody` or `TemplateURL` properties are specified), or the
#' `Parameters` property, AWS CloudFormation marks all stack instances with
#' a status of `OUTDATED` prior to updating the stack instances in the
#' specified accounts and Regions. If the stack set update does not include
#' changes to the template or parameters, AWS CloudFormation updates the
#' stack instances in the specified accounts and Regions, while leaving all
#' other stack instances with their existing stack instance status.
#'
#' @section Request syntax:
#' ```
#' svc$update_stack_set(
#'   StackSetName = "string",
#'   Description = "string",
#'   TemplateBody = "string",
#'   TemplateURL = "string",
#'   UsePreviousTemplate = TRUE|FALSE,
#'   Parameters = list(
#'     list(
#'       ParameterKey = "string",
#'       ParameterValue = "string",
#'       UsePreviousValue = TRUE|FALSE,
#'       ResolvedValue = "string"
#'     )
#'   ),
#'   Capabilities = list(
#'     "CAPABILITY_IAM"|"CAPABILITY_NAMED_IAM"|"CAPABILITY_AUTO_EXPAND"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   OperationPreferences = list(
#'     RegionOrder = list(
#'       "string"
#'     ),
#'     FailureToleranceCount = 123,
#'     FailureTolerancePercentage = 123,
#'     MaxConcurrentCount = 123,
#'     MaxConcurrentPercentage = 123
#'   ),
#'   AdministrationRoleARN = "string",
#'   ExecutionRoleName = "string",
#'   DeploymentTargets = list(
#'     Accounts = list(
#'       "string"
#'     ),
#'     OrganizationalUnitIds = list(
#'       "string"
#'     )
#'   ),
#'   PermissionModel = "SERVICE_MANAGED"|"SELF_MANAGED",
#'   AutoDeployment = list(
#'     Enabled = TRUE|FALSE,
#'     RetainStacksOnAccountRemoval = TRUE|FALSE
#'   ),
#'   OperationId = "string",
#'   Accounts = list(
#'     "string"
#'   ),
#'   Regions = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_update_stack_set
cloudformation_update_stack_set <- function(StackSetName, Description = NULL, TemplateBody = NULL, TemplateURL = NULL, UsePreviousTemplate = NULL, Parameters = NULL, Capabilities = NULL, Tags = NULL, OperationPreferences = NULL, AdministrationRoleARN = NULL, ExecutionRoleName = NULL, DeploymentTargets = NULL, PermissionModel = NULL, AutoDeployment = NULL, OperationId = NULL, Accounts = NULL, Regions = NULL) {
  op <- new_operation(
    name = "UpdateStackSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$update_stack_set_input(StackSetName = StackSetName, Description = Description, TemplateBody = TemplateBody, TemplateURL = TemplateURL, UsePreviousTemplate = UsePreviousTemplate, Parameters = Parameters, Capabilities = Capabilities, Tags = Tags, OperationPreferences = OperationPreferences, AdministrationRoleARN = AdministrationRoleARN, ExecutionRoleName = ExecutionRoleName, DeploymentTargets = DeploymentTargets, PermissionModel = PermissionModel, AutoDeployment = AutoDeployment, OperationId = OperationId, Accounts = Accounts, Regions = Regions)
  output <- .cloudformation$update_stack_set_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$update_stack_set <- cloudformation_update_stack_set

#' Updates termination protection for the specified stack
#'
#' @description
#' Updates termination protection for the specified stack. If a user
#' attempts to delete a stack with termination protection enabled, the
#' operation fails and the stack remains unchanged. For more information,
#' see [Protecting a Stack From Being
#' Deleted](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html)
#' in the *AWS CloudFormation User Guide*.
#' 
#' For [nested
#' stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html),
#' termination protection is set on the root stack and cannot be changed
#' directly on the nested stack.
#'
#' @usage
#' cloudformation_update_termination_protection(
#'   EnableTerminationProtection, StackName)
#'
#' @param EnableTerminationProtection &#91;required&#93; Whether to enable termination protection on the specified stack.
#' @param StackName &#91;required&#93; The name or unique ID of the stack for which you want to set termination
#' protection.
#'
#' @section Request syntax:
#' ```
#' svc$update_termination_protection(
#'   EnableTerminationProtection = TRUE|FALSE,
#'   StackName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_update_termination_protection
cloudformation_update_termination_protection <- function(EnableTerminationProtection, StackName) {
  op <- new_operation(
    name = "UpdateTerminationProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$update_termination_protection_input(EnableTerminationProtection = EnableTerminationProtection, StackName = StackName)
  output <- .cloudformation$update_termination_protection_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$update_termination_protection <- cloudformation_update_termination_protection

#' Validates a specified template
#'
#' @description
#' Validates a specified template. AWS CloudFormation first checks if the
#' template is valid JSON. If it isn't, AWS CloudFormation checks if the
#' template is valid YAML. If both these checks fail, AWS CloudFormation
#' returns a template validation error.
#'
#' @usage
#' cloudformation_validate_template(TemplateBody, TemplateURL)
#'
#' @param TemplateBody Structure containing the template body with a minimum length of 1 byte
#' and a maximum length of 51,200 bytes. For more information, go to
#' [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.
#' 
#' Conditional: You must pass `TemplateURL` or `TemplateBody`. If both are
#' passed, only `TemplateBody` is used.
#' @param TemplateURL Location of file containing the template body. The URL must point to a
#' template (max size: 460,800 bytes) that is located in an Amazon S3
#' bucket. For more information, go to [Template
#' Anatomy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
#' in the AWS CloudFormation User Guide.
#' 
#' Conditional: You must pass `TemplateURL` or `TemplateBody`. If both are
#' passed, only `TemplateBody` is used.
#'
#' @section Request syntax:
#' ```
#' svc$validate_template(
#'   TemplateBody = "string",
#'   TemplateURL = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudformation_validate_template
cloudformation_validate_template <- function(TemplateBody = NULL, TemplateURL = NULL) {
  op <- new_operation(
    name = "ValidateTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cloudformation$validate_template_input(TemplateBody = TemplateBody, TemplateURL = TemplateURL)
  output <- .cloudformation$validate_template_output()
  config <- get_config()
  svc <- .cloudformation$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudformation$operations$validate_template <- cloudformation_validate_template
