% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_list_license_specifications_for_resource}
\alias{licensemanager_list_license_specifications_for_resource}
\title{Describes the license configurations for the specified resource}
\usage{
licensemanager_list_license_specifications_for_resource(ResourceArn,
  MaxResults, NextToken)
}
\arguments{
\item{ResourceArn}{[required] Amazon Resource Name (ARN) of a resource that has an associated license
configuration.}

\item{MaxResults}{Maximum number of results to return in a single call.}

\item{NextToken}{Token for the next set of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  LicenseSpecifications = list(
    list(
      LicenseConfigurationArn = "string",
      AmiAssociationScope = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes the license configurations for the specified resource.
}
\section{Request syntax}{
\preformatted{svc$list_license_specifications_for_resource(
  ResourceArn = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
