% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_list_handshakes_for_account}
\alias{organizations_list_handshakes_for_account}
\title{Lists the current handshakes that are associated with the account of the
requesting user}
\usage{
organizations_list_handshakes_for_account(Filter, NextToken, MaxResults)
}
\arguments{
\item{Filter}{Filters the handshakes that you want included in the response. The
default is all types. Use the \code{ActionType} element to limit the output
to only a specified type, such as \code{INVITE}, \code{ENABLE_ALL_FEATURES}, or
\code{APPROVE_ALL_FEATURES}. Alternatively, for the \code{ENABLE_ALL_FEATURES}
handshake that generates a separate child handshake for each member
account, you can specify \code{ParentHandshakeId} to see only the handshakes
that were generated by that parent request.}

\item{NextToken}{Use this parameter if you receive a \code{NextToken} response in a previous
request that indicates that there is more output available. Set it to
the value of the previous call's \code{NextToken} response to indicate where
the output should continue from.}

\item{MaxResults}{(Optional) Use this to limit the number of results you want included per
page in the response. If you do not include this parameter, it defaults
to a value that is specific to the operation. If additional items exist
beyond the maximum you specify, the \code{NextToken} response element is
present and has a value (is not null). Include that value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results. Note that Organizations might return fewer
results than the maximum even when there are more results available. You
should check \code{NextToken} after every operation to ensure that you
receive all of the results.}
}
\description{
Lists the current handshakes that are associated with the account of the
requesting user.
}
\details{
Handshakes that are \code{ACCEPTED}, \code{DECLINED}, or \code{CANCELED} appear in the
results of this API for only 30 days after changing to that state. After
that, they're deleted and no longer accessible.

Always check the \code{NextToken} response parameter for a \code{null} value when
calling a \code{List*} operation. These operations can occasionally return an
empty set of results even when there are more results available. The
\code{NextToken} response parameter value is \code{null} \emph{only} when there are no
more results to display.

This operation can be called from any account in the organization.
}
\section{Request syntax}{
\preformatted{svc$list_handshakes_for_account(
  Filter = list(
    ActionType = "INVITE"|"ENABLE_ALL_FEATURES"|"APPROVE_ALL_FEATURES"|"ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE",
    ParentHandshakeId = "string"
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
# The following example shows you how to get a list of handshakes that are
# associated with the account of the credentials used to call the
# operation:
\donttest{svc$list_handshakes_for_account()}

}
\keyword{internal}
