% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_get_trail_status}
\alias{cloudtrail_get_trail_status}
\title{Returns a JSON-formatted list of information about the specified trail}
\usage{
cloudtrail_get_trail_status(Name)
}
\arguments{
\item{Name}{[required] Specifies the name or the CloudTrail ARN of the trail for which you are
requesting status. To get the status of a shadow trail (a replication of
the trail in another region), you must specify its ARN. The format of a
trail ARN is:

\code{arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail}}
}
\description{
Returns a JSON-formatted list of information about the specified trail.
Fields include information on delivery errors, Amazon SNS and Amazon S3
errors, and start and stop logging times for each trail. This operation
returns trail status from a single region. To return trail status from
all regions, you must call the operation on each region.
}
\section{Request syntax}{
\preformatted{svc$get_trail_status(
  Name = "string"
)
}
}

\keyword{internal}
