% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroups_service.R
\name{resourcegroups}
\alias{resourcegroups}
\title{AWS Resource Groups}
\usage{
resourcegroups(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
AWS Resource Groups lets you organize AWS resources such as Amazon EC2
instances, Amazon Relational Database Service databases, and Amazon S3
buckets into groups using criteria that you define as tags. A resource
group is a collection of resources that match the resource types
specified in a query, and share one or more tags or portions of tags.
You can create a group of resources based on their roles in your cloud
infrastructure, lifecycle stages, regions, application layers, or
virtually any criteria. Resource groups enable you to automate
management tasks, such as those in AWS Systems Manager Automation
documents, on tag-related resources in AWS Systems Manager. Groups of
tagged resources also let you quickly view a custom console in AWS
Systems Manager that shows AWS Config compliance and other monitoring
data about member resources.

To create a resource group, build a resource query, and specify tags
that identify the criteria that members of the group have in common.
Tags are key-value pairs.

For more information about Resource Groups, see the \href{https://docs.aws.amazon.com/ARG/latest/userguide/welcome.html}{AWS Resource Groups User Guide}.

AWS Resource Groups uses a REST-compliant API that you can use to
perform the following types of operations.
\itemize{
\item Create, Read, Update, and Delete (CRUD) operations on resource
groups and resource query entities
\item Applying, editing, and removing tags from resource groups
\item Resolving resource group member ARNs so they can be returned as
search results
\item Getting data about resources that are members of a group
\item Searching AWS resources based on a resource query
}
}
\section{Service syntax}{
\preformatted{svc <- resourcegroups(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=resourcegroups_create_group]{create_group} \tab Creates a group with a specified name, description, and resource query \cr
\link[=resourcegroups_delete_group]{delete_group} \tab Deletes a specified resource group \cr
\link[=resourcegroups_get_group]{get_group} \tab Returns information about a specified resource group \cr
\link[=resourcegroups_get_group_query]{get_group_query} \tab Returns the resource query associated with the specified resource group \cr
\link[=resourcegroups_get_tags]{get_tags} \tab Returns a list of tags that are associated with a resource group, specified by an ARN\cr
\link[=resourcegroups_list_group_resources]{list_group_resources} \tab Returns a list of ARNs of resources that are members of a specified resource group \cr
\link[=resourcegroups_list_groups]{list_groups} \tab Returns a list of existing resource groups in your account \cr
\link[=resourcegroups_search_resources]{search_resources} \tab Returns a list of AWS resource identifiers that matches a specified query \cr
\link[=resourcegroups_tag]{tag} \tab Adds tags to a resource group with the specified ARN \cr
\link[=resourcegroups_untag]{untag} \tab Deletes specified tags from a specified resource \cr
\link[=resourcegroups_update_group]{update_group} \tab Updates an existing group with a new or changed description \cr
\link[=resourcegroups_update_group_query]{update_group_query} \tab Updates the resource query of a group
}
}

\examples{
\donttest{svc <- resourcegroups()
svc$create_group(
  Foo = 123
)}

}
