% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_delete_auto_scaling_group}
\alias{autoscaling_delete_auto_scaling_group}
\title{Deletes the specified Auto Scaling group}
\usage{
autoscaling_delete_auto_scaling_group(AutoScalingGroupName, ForceDelete)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{ForceDelete}{Specifies that the group is to be deleted along with all instances
associated with the group, without waiting for all instances to be
terminated. This parameter also deletes any lifecycle actions associated
with the group.}
}
\description{
Deletes the specified Auto Scaling group.
}
\details{
If the group has instances or scaling activities in progress, you must
specify the option to force the deletion in order for it to succeed.

If the group has policies, deleting the group deletes the policies, the
underlying alarm actions, and any alarm that no longer has an associated
action.

To remove instances from the Auto Scaling group before deleting it, call
DetachInstances with the list of instances and the option to decrement
the desired capacity. This ensures that Amazon EC2 Auto Scaling does not
launch replacement instances.

To terminate all instances before deleting the Auto Scaling group, call
UpdateAutoScalingGroup and set the minimum size and desired capacity of
the Auto Scaling group to zero.
}
\section{Request syntax}{
\preformatted{svc$delete_auto_scaling_group(
  AutoScalingGroupName = "string",
  ForceDelete = TRUE|FALSE
)
}
}

\examples{
# This example deletes the specified Auto Scaling group.
\donttest{svc$delete_auto_scaling_group(
  AutoScalingGroupName = "my-auto-scaling-group"
)}

# This example deletes the specified Auto Scaling group and all its
# instances.
\donttest{svc$delete_auto_scaling_group(
  AutoScalingGroupName = "my-auto-scaling-group",
  ForceDelete = TRUE
)}

}
\keyword{internal}
