% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_tag_resource}
\alias{cloudwatch_tag_resource}
\title{Assigns one or more tags (key-value pairs) to the specified CloudWatch
resource}
\usage{
cloudwatch_tag_resource(ResourceARN, Tags)
}
\arguments{
\item{ResourceARN}{[required] The ARN of the CloudWatch resource that you're adding tags to. For more
information on ARN format, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-cloudwatch}{Example ARNs}
in the \emph{Amazon Web Services General Reference}.}

\item{Tags}{[required] The list of key-value pairs to associate with the resource.}
}
\description{
Assigns one or more tags (key-value pairs) to the specified CloudWatch
resource. Tags can help you organize and categorize your resources. You
can also use them to scope user permissions, by granting a user
permission to access or change only resources with certain tag values.
In CloudWatch, alarms can be tagged.
}
\details{
Tags don't have any semantic meaning to AWS and are interpreted
strictly as strings of characters.

You can use the \code{TagResource} action with a resource that already has
tags. If you specify a new tag key for the resource, this tag is
appended to the list of tags associated with the resource. If you
specify a tag key that is already associated with the resource, the new
tag value that you specify replaces the previous value for that tag.

You can associate as many as 50 tags with a resource.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  ResourceARN = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
