% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_refresh_trusted_advisor_check}
\alias{support_refresh_trusted_advisor_check}
\title{Requests a refresh of the Trusted Advisor check that has the specified
check ID}
\usage{
support_refresh_trusted_advisor_check(checkId)
}
\arguments{
\item{checkId}{[required] The unique identifier for the Trusted Advisor check to refresh.
\strong{Note:} Specifying the check ID of a check that is automatically
refreshed causes an \code{InvalidParameterValue} error.}
}
\description{
Requests a refresh of the Trusted Advisor check that has the specified
check ID. Check IDs can be obtained by calling
DescribeTrustedAdvisorChecks.
}
\details{
Some checks are refreshed automatically, and they cannot be refreshed by
using this operation. Use of the \code{RefreshTrustedAdvisorCheck} operation
for these checks causes an \code{InvalidParameterValue} error.

The response contains a TrustedAdvisorCheckRefreshStatus object, which
contains these fields:
\itemize{
\item \strong{status.} The refresh status of the check: "none", "enqueued",
"processing", "success", or "abandoned".
\item \strong{millisUntilNextRefreshable.} The amount of time, in milliseconds,
until the check is eligible for refresh.
\item \strong{checkId.} The unique identifier for the check.
}
}
\section{Request syntax}{
\preformatted{svc$refresh_trusted_advisor_check(
  checkId = "string"
)
}
}

\keyword{internal}
