# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include licensemanager_service.R
NULL

#' Creates a license configuration
#'
#' Creates a license configuration.
#' 
#' A license configuration is an abstraction of a customer license
#' agreement that can be consumed and enforced by License Manager.
#' Components include specifications for the license type (licensing by
#' instance, socket, CPU, or vCPU), allowed tenancy (shared tenancy,
#' Dedicated Instance, Dedicated Host, or all of these), host affinity (how
#' long a VM must be associated with a host), and the number of licenses
#' purchased and used.
#'
#' @usage
#' licensemanager_create_license_configuration(Name, Description,
#'   LicenseCountingType, LicenseCount, LicenseCountHardLimit, LicenseRules,
#'   Tags, ProductInformationList)
#'
#' @param Name &#91;required&#93; Name of the license configuration.
#' @param Description Description of the license configuration.
#' @param LicenseCountingType &#91;required&#93; Dimension used to track the license inventory.
#' @param LicenseCount Number of licenses managed by the license configuration.
#' @param LicenseCountHardLimit Indicates whether hard or soft license enforcement is used. Exceeding a
#' hard limit blocks the launch of new instances.
#' @param LicenseRules License rules. The syntax is \\#name=value (for example,
#' \\#allowedTenancy=EC2-DedicatedHost). Available rules vary by dimension.
#' 
#' -   `Cores` dimension: `allowedTenancy` \\| `maximumCores` \\|
#'     `minimumCores`
#' 
#' -   `Instances` dimension: `allowedTenancy` \\| `maximumCores` \\|
#'     `minimumCores` \\| `maximumSockets` \\| `minimumSockets` \\|
#'     `maximumVcpus` \\| `minimumVcpus`
#' 
#' -   `Sockets` dimension: `allowedTenancy` \\| `maximumSockets` \\|
#'     `minimumSockets`
#' 
#' -   `vCPUs` dimension: `allowedTenancy` \\| `honorVcpuOptimization` \\|
#'     `maximumVcpus` \\| `minimumVcpus`
#' @param Tags Tags to add to the license configuration.
#' @param ProductInformationList Product information.
#'
#' @section Request syntax:
#' ```
#' svc$create_license_configuration(
#'   Name = "string",
#'   Description = "string",
#'   LicenseCountingType = "vCPU"|"Instance"|"Core"|"Socket",
#'   LicenseCount = 123,
#'   LicenseCountHardLimit = TRUE|FALSE,
#'   LicenseRules = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   ProductInformationList = list(
#'     list(
#'       ResourceType = "string",
#'       ProductInformationFilterList = list(
#'         list(
#'           ProductInformationFilterName = "string",
#'           ProductInformationFilterValue = list(
#'             "string"
#'           ),
#'           ProductInformationFilterComparator = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_create_license_configuration
licensemanager_create_license_configuration <- function(Name, Description = NULL, LicenseCountingType, LicenseCount = NULL, LicenseCountHardLimit = NULL, LicenseRules = NULL, Tags = NULL, ProductInformationList = NULL) {
  op <- new_operation(
    name = "CreateLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$create_license_configuration_input(Name = Name, Description = Description, LicenseCountingType = LicenseCountingType, LicenseCount = LicenseCount, LicenseCountHardLimit = LicenseCountHardLimit, LicenseRules = LicenseRules, Tags = Tags, ProductInformationList = ProductInformationList)
  output <- .licensemanager$create_license_configuration_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$create_license_configuration <- licensemanager_create_license_configuration

#' Deletes the specified license configuration
#'
#' Deletes the specified license configuration.
#' 
#' You cannot delete a license configuration that is in use.
#'
#' @usage
#' licensemanager_delete_license_configuration(LicenseConfigurationArn)
#'
#' @param LicenseConfigurationArn &#91;required&#93; ID of the license configuration.
#'
#' @section Request syntax:
#' ```
#' svc$delete_license_configuration(
#'   LicenseConfigurationArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_delete_license_configuration
licensemanager_delete_license_configuration <- function(LicenseConfigurationArn) {
  op <- new_operation(
    name = "DeleteLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$delete_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn)
  output <- .licensemanager$delete_license_configuration_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$delete_license_configuration <- licensemanager_delete_license_configuration

#' Gets detailed information about the specified license configuration
#'
#' Gets detailed information about the specified license configuration.
#'
#' @usage
#' licensemanager_get_license_configuration(LicenseConfigurationArn)
#'
#' @param LicenseConfigurationArn &#91;required&#93; Amazon Resource Name (ARN) of the license configuration.
#'
#' @section Request syntax:
#' ```
#' svc$get_license_configuration(
#'   LicenseConfigurationArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_get_license_configuration
licensemanager_get_license_configuration <- function(LicenseConfigurationArn) {
  op <- new_operation(
    name = "GetLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$get_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn)
  output <- .licensemanager$get_license_configuration_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$get_license_configuration <- licensemanager_get_license_configuration

#' Gets the License Manager settings for the current Region
#'
#' Gets the License Manager settings for the current Region.
#'
#' @usage
#' licensemanager_get_service_settings()
#'
#' @section Request syntax:
#' ```
#' svc$get_service_settings()
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_get_service_settings
licensemanager_get_service_settings <- function() {
  op <- new_operation(
    name = "GetServiceSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$get_service_settings_input()
  output <- .licensemanager$get_service_settings_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$get_service_settings <- licensemanager_get_service_settings

#' Lists the resource associations for the specified license configuration
#'
#' Lists the resource associations for the specified license configuration.
#' 
#' Resource associations need not consume licenses from a license
#' configuration. For example, an AMI or a stopped instance might not
#' consume a license (depending on the license rules).
#'
#' @usage
#' licensemanager_list_associations_for_license_configuration(
#'   LicenseConfigurationArn, MaxResults, NextToken)
#'
#' @param LicenseConfigurationArn &#91;required&#93; Amazon Resource Name (ARN) of a license configuration.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_associations_for_license_configuration(
#'   LicenseConfigurationArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_associations_for_license_configuration
licensemanager_list_associations_for_license_configuration <- function(LicenseConfigurationArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAssociationsForLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$list_associations_for_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanager$list_associations_for_license_configuration_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_associations_for_license_configuration <- licensemanager_list_associations_for_license_configuration

#' Lists the license configuration operations that failed
#'
#' Lists the license configuration operations that failed.
#'
#' @usage
#' licensemanager_list_failures_for_license_configuration_operations(
#'   LicenseConfigurationArn, MaxResults, NextToken)
#'
#' @param LicenseConfigurationArn &#91;required&#93; Amazon Resource Name of the license configuration.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_failures_for_license_configuration_operations(
#'   LicenseConfigurationArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_failures_for_license_configuration_operations
licensemanager_list_failures_for_license_configuration_operations <- function(LicenseConfigurationArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFailuresForLicenseConfigurationOperations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$list_failures_for_license_configuration_operations_input(LicenseConfigurationArn = LicenseConfigurationArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanager$list_failures_for_license_configuration_operations_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_failures_for_license_configuration_operations <- licensemanager_list_failures_for_license_configuration_operations

#' Lists the license configurations for your account
#'
#' Lists the license configurations for your account.
#'
#' @usage
#' licensemanager_list_license_configurations(LicenseConfigurationArns,
#'   MaxResults, NextToken, Filters)
#'
#' @param LicenseConfigurationArns Amazon Resource Names (ARN) of the license configurations.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#' @param Filters Filters to scope the results. The following filters and logical
#' operators are supported:
#' 
#' -   `licenseCountingType` - The dimension on which licenses are counted
#'     (vCPU). Logical operators are `EQUALS` \\| `NOT_EQUALS`.
#' 
#' -   `enforceLicenseCount` - A Boolean value that indicates whether hard
#'     license enforcement is used. Logical operators are `EQUALS` \\|
#'     `NOT_EQUALS`.
#' 
#' -   `usagelimitExceeded` - A Boolean value that indicates whether the
#'     available licenses have been exceeded. Logical operators are
#'     `EQUALS` \\| `NOT_EQUALS`.
#'
#' @section Request syntax:
#' ```
#' svc$list_license_configurations(
#'   LicenseConfigurationArns = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_license_configurations
licensemanager_list_license_configurations <- function(LicenseConfigurationArns = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListLicenseConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$list_license_configurations_input(LicenseConfigurationArns = LicenseConfigurationArns, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .licensemanager$list_license_configurations_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_license_configurations <- licensemanager_list_license_configurations

#' Describes the license configurations for the specified resource
#'
#' Describes the license configurations for the specified resource.
#'
#' @usage
#' licensemanager_list_license_specifications_for_resource(ResourceArn,
#'   MaxResults, NextToken)
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of a resource that has an associated license
#' configuration.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_license_specifications_for_resource(
#'   ResourceArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_license_specifications_for_resource
licensemanager_list_license_specifications_for_resource <- function(ResourceArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListLicenseSpecificationsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$list_license_specifications_for_resource_input(ResourceArn = ResourceArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanager$list_license_specifications_for_resource_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_license_specifications_for_resource <- licensemanager_list_license_specifications_for_resource

#' Lists resources managed using Systems Manager inventory
#'
#' Lists resources managed using Systems Manager inventory.
#'
#' @usage
#' licensemanager_list_resource_inventory(MaxResults, NextToken, Filters)
#'
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#' @param Filters Filters to scope the results. The following filters and logical
#' operators are supported:
#' 
#' -   `account_id` - The ID of the AWS account that owns the resource.
#'     Logical operators are `EQUALS` \\| `NOT_EQUALS`.
#' 
#' -   `application_name` - The name of the application. Logical operators
#'     are `EQUALS` \\| `BEGINS_WITH`.
#' 
#' -   `license_included` - The type of license included. Logical operators
#'     are `EQUALS` \\| `NOT_EQUALS`. Possible values are
#'     `sql-server-enterprise` \\| `sql-server-standard` \\| `sql-server-web`
#'     \\| `windows-server-datacenter`.
#' 
#' -   `platform` - The platform of the resource. Logical operators are
#'     `EQUALS` \\| `BEGINS_WITH`.
#' 
#' -   `resource_id` - The ID of the resource. Logical operators are
#'     `EQUALS` \\| `NOT_EQUALS`.
#'
#' @section Request syntax:
#' ```
#' svc$list_resource_inventory(
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Condition = "EQUALS"|"NOT_EQUALS"|"BEGINS_WITH"|"CONTAINS",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_resource_inventory
licensemanager_list_resource_inventory <- function(MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListResourceInventory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$list_resource_inventory_input(MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .licensemanager$list_resource_inventory_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_resource_inventory <- licensemanager_list_resource_inventory

#' Lists the tags for the specified license configuration
#'
#' Lists the tags for the specified license configuration.
#'
#' @usage
#' licensemanager_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of the license configuration.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_tags_for_resource
licensemanager_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .licensemanager$list_tags_for_resource_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_tags_for_resource <- licensemanager_list_tags_for_resource

#' Lists all license usage records for a license configuration, displaying
#' license consumption details by resource at a selected point in time
#'
#' Lists all license usage records for a license configuration, displaying
#' license consumption details by resource at a selected point in time. Use
#' this action to audit the current license consumption for any license
#' inventory and configuration.
#'
#' @usage
#' licensemanager_list_usage_for_license_configuration(
#'   LicenseConfigurationArn, MaxResults, NextToken, Filters)
#'
#' @param LicenseConfigurationArn &#91;required&#93; Amazon Resource Name (ARN) of the license configuration.
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#' @param Filters Filters to scope the results. The following filters and logical
#' operators are supported:
#' 
#' -   `resourceArn` - The ARN of the license configuration resource.
#'     Logical operators are `EQUALS` \\| `NOT_EQUALS`.
#' 
#' -   `resourceType` - The resource type (EC2\\_INSTANCE \\| EC2\\_HOST \\|
#'     EC2\\_AMI \\| SYSTEMS\\_MANAGER\\_MANAGED\\_INSTANCE). Logical operators
#'     are `EQUALS` \\| `NOT_EQUALS`.
#' 
#' -   `resourceAccount` - The ID of the account that owns the resource.
#'     Logical operators are `EQUALS` \\| `NOT_EQUALS`.
#'
#' @section Request syntax:
#' ```
#' svc$list_usage_for_license_configuration(
#'   LicenseConfigurationArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_usage_for_license_configuration
licensemanager_list_usage_for_license_configuration <- function(LicenseConfigurationArn, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListUsageForLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$list_usage_for_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .licensemanager$list_usage_for_license_configuration_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_usage_for_license_configuration <- licensemanager_list_usage_for_license_configuration

#' Adds the specified tags to the specified license configuration
#'
#' Adds the specified tags to the specified license configuration.
#'
#' @usage
#' licensemanager_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of the license configuration.
#' @param Tags &#91;required&#93; One or more tags.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_tag_resource
licensemanager_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .licensemanager$tag_resource_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$tag_resource <- licensemanager_tag_resource

#' Removes the specified tags from the specified license configuration
#'
#' Removes the specified tags from the specified license configuration.
#'
#' @usage
#' licensemanager_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of the license configuration.
#' @param TagKeys &#91;required&#93; Keys identifying the tags to remove.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_untag_resource
licensemanager_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .licensemanager$untag_resource_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$untag_resource <- licensemanager_untag_resource

#' Modifies the attributes of an existing license configuration
#'
#' Modifies the attributes of an existing license configuration.
#' 
#' A license configuration is an abstraction of a customer license
#' agreement that can be consumed and enforced by License Manager.
#' Components include specifications for the license type (licensing by
#' instance, socket, CPU, or vCPU), allowed tenancy (shared tenancy,
#' Dedicated Instance, Dedicated Host, or all of these), host affinity (how
#' long a VM must be associated with a host), and the number of licenses
#' purchased and used.
#'
#' @usage
#' licensemanager_update_license_configuration(LicenseConfigurationArn,
#'   LicenseConfigurationStatus, LicenseRules, LicenseCount,
#'   LicenseCountHardLimit, Name, Description, ProductInformationList)
#'
#' @param LicenseConfigurationArn &#91;required&#93; Amazon Resource Name (ARN) of the license configuration.
#' @param LicenseConfigurationStatus New status of the license configuration.
#' @param LicenseRules New license rules.
#' @param LicenseCount New number of licenses managed by the license configuration.
#' @param LicenseCountHardLimit New hard limit of the number of available licenses.
#' @param Name New name of the license configuration.
#' @param Description New description of the license configuration.
#' @param ProductInformationList New product information.
#'
#' @section Request syntax:
#' ```
#' svc$update_license_configuration(
#'   LicenseConfigurationArn = "string",
#'   LicenseConfigurationStatus = "AVAILABLE"|"DISABLED",
#'   LicenseRules = list(
#'     "string"
#'   ),
#'   LicenseCount = 123,
#'   LicenseCountHardLimit = TRUE|FALSE,
#'   Name = "string",
#'   Description = "string",
#'   ProductInformationList = list(
#'     list(
#'       ResourceType = "string",
#'       ProductInformationFilterList = list(
#'         list(
#'           ProductInformationFilterName = "string",
#'           ProductInformationFilterValue = list(
#'             "string"
#'           ),
#'           ProductInformationFilterComparator = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_update_license_configuration
licensemanager_update_license_configuration <- function(LicenseConfigurationArn, LicenseConfigurationStatus = NULL, LicenseRules = NULL, LicenseCount = NULL, LicenseCountHardLimit = NULL, Name = NULL, Description = NULL, ProductInformationList = NULL) {
  op <- new_operation(
    name = "UpdateLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$update_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn, LicenseConfigurationStatus = LicenseConfigurationStatus, LicenseRules = LicenseRules, LicenseCount = LicenseCount, LicenseCountHardLimit = LicenseCountHardLimit, Name = Name, Description = Description, ProductInformationList = ProductInformationList)
  output <- .licensemanager$update_license_configuration_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$update_license_configuration <- licensemanager_update_license_configuration

#' Adds or removes the specified license configurations for the specified
#' AWS resource
#'
#' Adds or removes the specified license configurations for the specified
#' AWS resource.
#' 
#' You can update the license specifications of AMIs, instances, and hosts.
#' You cannot update the license specifications for launch templates and
#' AWS CloudFormation templates, as they send license configurations to the
#' operation that creates the resource.
#'
#' @usage
#' licensemanager_update_license_specifications_for_resource(ResourceArn,
#'   AddLicenseSpecifications, RemoveLicenseSpecifications)
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of the AWS resource.
#' @param AddLicenseSpecifications ARNs of the license configurations to add.
#' @param RemoveLicenseSpecifications ARNs of the license configurations to remove.
#'
#' @section Request syntax:
#' ```
#' svc$update_license_specifications_for_resource(
#'   ResourceArn = "string",
#'   AddLicenseSpecifications = list(
#'     list(
#'       LicenseConfigurationArn = "string"
#'     )
#'   ),
#'   RemoveLicenseSpecifications = list(
#'     list(
#'       LicenseConfigurationArn = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_update_license_specifications_for_resource
licensemanager_update_license_specifications_for_resource <- function(ResourceArn, AddLicenseSpecifications = NULL, RemoveLicenseSpecifications = NULL) {
  op <- new_operation(
    name = "UpdateLicenseSpecificationsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$update_license_specifications_for_resource_input(ResourceArn = ResourceArn, AddLicenseSpecifications = AddLicenseSpecifications, RemoveLicenseSpecifications = RemoveLicenseSpecifications)
  output <- .licensemanager$update_license_specifications_for_resource_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$update_license_specifications_for_resource <- licensemanager_update_license_specifications_for_resource

#' Updates License Manager settings for the current Region
#'
#' Updates License Manager settings for the current Region.
#'
#' @usage
#' licensemanager_update_service_settings(S3BucketArn, SnsTopicArn,
#'   OrganizationConfiguration, EnableCrossAccountsDiscovery)
#'
#' @param S3BucketArn Amazon Resource Name (ARN) of the Amazon S3 bucket where the License
#' Manager information is stored.
#' @param SnsTopicArn Amazon Resource Name (ARN) of the Amazon SNS topic used for License
#' Manager alerts.
#' @param OrganizationConfiguration Enables integration with AWS Organizations for cross-account discovery.
#' @param EnableCrossAccountsDiscovery Activates cross-account discovery.
#'
#' @section Request syntax:
#' ```
#' svc$update_service_settings(
#'   S3BucketArn = "string",
#'   SnsTopicArn = "string",
#'   OrganizationConfiguration = list(
#'     EnableIntegration = TRUE|FALSE
#'   ),
#'   EnableCrossAccountsDiscovery = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_update_service_settings
licensemanager_update_service_settings <- function(S3BucketArn = NULL, SnsTopicArn = NULL, OrganizationConfiguration = NULL, EnableCrossAccountsDiscovery = NULL) {
  op <- new_operation(
    name = "UpdateServiceSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$update_service_settings_input(S3BucketArn = S3BucketArn, SnsTopicArn = SnsTopicArn, OrganizationConfiguration = OrganizationConfiguration, EnableCrossAccountsDiscovery = EnableCrossAccountsDiscovery)
  output <- .licensemanager$update_service_settings_output()
  config <- get_config()
  svc <- .licensemanager$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$update_service_settings <- licensemanager_update_service_settings
