# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include support_service.R
NULL

#' Adds one or more attachments to an attachment set
#'
#' Adds one or more attachments to an attachment set.
#' 
#' An attachment set is a temporary container for attachments that you add
#' to a case or case communication. The set is available for 1 hour after
#' it\'s created. The `expiryTime` returned in the response is when the set
#' expires.
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_add_attachments_to_set(attachmentSetId, attachments)
#'
#' @param attachmentSetId The ID of the attachment set. If an `attachmentSetId` is not specified,
#' a new attachment set is created, and the ID of the set is returned in
#' the response. If an `attachmentSetId` is specified, the attachments are
#' added to the specified set, if it exists.
#' @param attachments &#91;required&#93; One or more attachments to add to the set. You can add up to three
#' attachments per set. The size limit is 5 MB per attachment.
#' 
#' In the `Attachment` object, use the `data` parameter to specify the
#' contents of the attachment file. In the previous request syntax, the
#' value for `data` appear as `blob`, which is represented as a
#' base64-encoded string. The value for `fileName` is the name of the
#' attachment, such as `troubleshoot-screenshot.png`.
#'
#' @section Request syntax:
#' ```
#' svc$add_attachments_to_set(
#'   attachmentSetId = "string",
#'   attachments = list(
#'     list(
#'       fileName = "string",
#'       data = raw
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_add_attachments_to_set
support_add_attachments_to_set <- function(attachmentSetId = NULL, attachments) {
  op <- new_operation(
    name = "AddAttachmentsToSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$add_attachments_to_set_input(attachmentSetId = attachmentSetId, attachments = attachments)
  output <- .support$add_attachments_to_set_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$add_attachments_to_set <- support_add_attachments_to_set

#' Adds additional customer communication to an AWS Support case
#'
#' Adds additional customer communication to an AWS Support case. Use the
#' `caseId` parameter to identify the case to which to add communication.
#' You can list a set of email addresses to copy on the communication by
#' using the `ccEmailAddresses` parameter. The `communicationBody` value
#' contains the text of the communication.
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_add_communication_to_case(caseId, communicationBody,
#'   ccEmailAddresses, attachmentSetId)
#'
#' @param caseId The AWS Support case ID requested or returned in the call. The case ID
#' is an alphanumeric string formatted as shown in this example:
#' case-*12345678910-2013-c4c1d2bf33c5cf47*
#' @param communicationBody &#91;required&#93; The body of an email communication to add to the support case.
#' @param ccEmailAddresses The email addresses in the CC line of an email to be added to the
#' support case.
#' @param attachmentSetId The ID of a set of one or more attachments for the communication to add
#' to the case. Create the set by calling AddAttachmentsToSet
#'
#' @section Request syntax:
#' ```
#' svc$add_communication_to_case(
#'   caseId = "string",
#'   communicationBody = "string",
#'   ccEmailAddresses = list(
#'     "string"
#'   ),
#'   attachmentSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_add_communication_to_case
support_add_communication_to_case <- function(caseId = NULL, communicationBody, ccEmailAddresses = NULL, attachmentSetId = NULL) {
  op <- new_operation(
    name = "AddCommunicationToCase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$add_communication_to_case_input(caseId = caseId, communicationBody = communicationBody, ccEmailAddresses = ccEmailAddresses, attachmentSetId = attachmentSetId)
  output <- .support$add_communication_to_case_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$add_communication_to_case <- support_add_communication_to_case

#' Creates a case in the AWS Support Center
#'
#' Creates a case in the AWS Support Center. This operation is similar to
#' how you create a case in the AWS Support Center [Create
#' Case](https://console.aws.amazon.com/support/home#/case/create) page.
#' 
#' The AWS Support API doesn\'t support requesting service limit increases.
#' You can submit a service limit increase in the following ways:
#' 
#' -   Submit a request from the AWS Support Center [Create
#'     Case](https://console.aws.amazon.com/support/home#/case/create)
#'     page.
#' 
#' -   Use the Service Quotas
#'     [RequestServiceQuotaIncrease](https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_RequestServiceQuotaIncrease.html)
#'     operation.
#' 
#' A successful `CreateCase` request returns an AWS Support case number.
#' You can use the DescribeCases operation and specify the case number to
#' get existing AWS Support cases. After you create a case, use the
#' AddCommunicationToCase operation to add additional communication or
#' attachments to an existing case.
#' 
#' The `caseId` is separate from the `displayId` that appears in the [AWS
#' Support Center](https://console.aws.amazon.com/support). Use the
#' DescribeCases operation to get the `displayId`.
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_create_case(subject, serviceCode, severityCode, categoryCode,
#'   communicationBody, ccEmailAddresses, language, issueType,
#'   attachmentSetId)
#'
#' @param subject &#91;required&#93; The title of the AWS Support case. The title appears in the **Subject**
#' field on the AWS Support Center [Create
#' Case](https://console.aws.amazon.com/support/home#/case/create) page.
#' @param serviceCode The code for the AWS service. You can use the DescribeServices operation
#' to get the possible `serviceCode` values.
#' @param severityCode A value that indicates the urgency of the case. This value determines
#' the response time according to your service level agreement with AWS
#' Support. You can use the DescribeSeverityLevels operation to get the
#' possible values for `severityCode`.
#' 
#' For more information, see SeverityLevel and [Choosing a
#' Severity](https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity)
#' in the *AWS Support User Guide*.
#' 
#' The availability of severity levels depends on the support plan for the
#' AWS account.
#' @param categoryCode The category of problem for the AWS Support case. You also use the
#' DescribeServices operation to get the category code for a service. Each
#' AWS service defines its own set of category codes.
#' @param communicationBody &#91;required&#93; The communication body text that describes the issue. This text appears
#' in the **Description** field on the AWS Support Center [Create
#' Case](https://console.aws.amazon.com/support/home#/case/create) page.
#' @param ccEmailAddresses A list of email addresses that AWS Support copies on case
#' correspondence. AWS Support identifies the account that creates the case
#' when you specify your AWS credentials in an HTTP POST method or use the
#' [AWS SDKs](http://aws.amazon.com/tools/).
#' @param language The language in which AWS Support handles the case. You must specify the
#' ISO 639-1 code for the `language` parameter if you want support in that
#' language. Currently, English (\"en\") and Japanese (\"ja\") are
#' supported.
#' @param issueType The type of issue for the case. You can specify `customer-service` or
#' `technical`. If you don\'t specify a value, the default is `technical`.
#' @param attachmentSetId The ID of a set of one or more attachments for the case. Create the set
#' by using the AddAttachmentsToSet operation.
#'
#' @section Request syntax:
#' ```
#' svc$create_case(
#'   subject = "string",
#'   serviceCode = "string",
#'   severityCode = "string",
#'   categoryCode = "string",
#'   communicationBody = "string",
#'   ccEmailAddresses = list(
#'     "string"
#'   ),
#'   language = "string",
#'   issueType = "string",
#'   attachmentSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_create_case
support_create_case <- function(subject, serviceCode = NULL, severityCode = NULL, categoryCode = NULL, communicationBody, ccEmailAddresses = NULL, language = NULL, issueType = NULL, attachmentSetId = NULL) {
  op <- new_operation(
    name = "CreateCase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$create_case_input(subject = subject, serviceCode = serviceCode, severityCode = severityCode, categoryCode = categoryCode, communicationBody = communicationBody, ccEmailAddresses = ccEmailAddresses, language = language, issueType = issueType, attachmentSetId = attachmentSetId)
  output <- .support$create_case_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$create_case <- support_create_case

#' Returns the attachment that has the specified ID
#'
#' Returns the attachment that has the specified ID. Attachments can
#' include screenshots, error logs, or other files that describe your
#' issue. Attachment IDs are generated by the case management system when
#' you add an attachment to a case or case communication. Attachment IDs
#' are returned in the AttachmentDetails objects that are returned by the
#' DescribeCommunications operation.
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_describe_attachment(attachmentId)
#'
#' @param attachmentId &#91;required&#93; The ID of the attachment to return. Attachment IDs are returned by the
#' DescribeCommunications operation.
#'
#' @section Request syntax:
#' ```
#' svc$describe_attachment(
#'   attachmentId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_attachment
support_describe_attachment <- function(attachmentId) {
  op <- new_operation(
    name = "DescribeAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_attachment_input(attachmentId = attachmentId)
  output <- .support$describe_attachment_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_attachment <- support_describe_attachment

#' Returns a list of cases that you specify by passing one or more case IDs
#'
#' Returns a list of cases that you specify by passing one or more case
#' IDs. You can use the `afterTime` and `beforeTime` parameters to filter
#' the cases by date. You can set values for the `includeResolvedCases` and
#' `includeCommunications` parameters to specify how much information to
#' return.
#' 
#' The response returns the following in JSON format:
#' 
#' -   One or more
#'     [CaseDetails](https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html)
#'     data types.
#' 
#' -   One or more `nextToken` values, which specify where to paginate the
#'     returned records represented by the `CaseDetails` objects.
#' 
#' Case data is available for 12 months after creation. If a case was
#' created more than 12 months ago, a request might return an error.
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_describe_cases(caseIdList, displayId, afterTime, beforeTime,
#'   includeResolvedCases, nextToken, maxResults, language,
#'   includeCommunications)
#'
#' @param caseIdList A list of ID numbers of the support cases you want returned. The maximum
#' number of cases is 100.
#' @param displayId The ID displayed for a case in the AWS Support Center user interface.
#' @param afterTime The start date for a filtered date search on support case
#' communications. Case communications are available for 12 months after
#' creation.
#' @param beforeTime The end date for a filtered date search on support case communications.
#' Case communications are available for 12 months after creation.
#' @param includeResolvedCases Specifies whether to include resolved support cases in the
#' `DescribeCases` response. By default, resolved cases aren\'t included.
#' @param nextToken A resumption point for pagination.
#' @param maxResults The maximum number of results to return before paginating.
#' @param language The ISO 639-1 code for the language in which AWS provides support. AWS
#' Support currently supports English (\"en\") and Japanese (\"ja\").
#' Language parameters must be passed explicitly for operations that take
#' them.
#' @param includeCommunications Specifies whether to include communications in the `DescribeCases`
#' response. By default, communications are incuded.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cases(
#'   caseIdList = list(
#'     "string"
#'   ),
#'   displayId = "string",
#'   afterTime = "string",
#'   beforeTime = "string",
#'   includeResolvedCases = TRUE|FALSE,
#'   nextToken = "string",
#'   maxResults = 123,
#'   language = "string",
#'   includeCommunications = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_cases
support_describe_cases <- function(caseIdList = NULL, displayId = NULL, afterTime = NULL, beforeTime = NULL, includeResolvedCases = NULL, nextToken = NULL, maxResults = NULL, language = NULL, includeCommunications = NULL) {
  op <- new_operation(
    name = "DescribeCases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_cases_input(caseIdList = caseIdList, displayId = displayId, afterTime = afterTime, beforeTime = beforeTime, includeResolvedCases = includeResolvedCases, nextToken = nextToken, maxResults = maxResults, language = language, includeCommunications = includeCommunications)
  output <- .support$describe_cases_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_cases <- support_describe_cases

#' Returns communications and attachments for one or more support cases
#'
#' Returns communications and attachments for one or more support cases.
#' Use the `afterTime` and `beforeTime` parameters to filter by date. You
#' can use the `caseId` parameter to restrict the results to a specific
#' case.
#' 
#' Case data is available for 12 months after creation. If a case was
#' created more than 12 months ago, a request for data might cause an
#' error.
#' 
#' You can use the `maxResults` and `nextToken` parameters to control the
#' pagination of the results. Set `maxResults` to the number of cases that
#' you want to display on each page, and use `nextToken` to specify the
#' resumption of pagination.
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_describe_communications(caseId, beforeTime, afterTime,
#'   nextToken, maxResults)
#'
#' @param caseId &#91;required&#93; The AWS Support case ID requested or returned in the call. The case ID
#' is an alphanumeric string formatted as shown in this example:
#' case-*12345678910-2013-c4c1d2bf33c5cf47*
#' @param beforeTime The end date for a filtered date search on support case communications.
#' Case communications are available for 12 months after creation.
#' @param afterTime The start date for a filtered date search on support case
#' communications. Case communications are available for 12 months after
#' creation.
#' @param nextToken A resumption point for pagination.
#' @param maxResults The maximum number of results to return before paginating.
#'
#' @section Request syntax:
#' ```
#' svc$describe_communications(
#'   caseId = "string",
#'   beforeTime = "string",
#'   afterTime = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_communications
support_describe_communications <- function(caseId, beforeTime = NULL, afterTime = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeCommunications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_communications_input(caseId = caseId, beforeTime = beforeTime, afterTime = afterTime, nextToken = nextToken, maxResults = maxResults)
  output <- .support$describe_communications_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_communications <- support_describe_communications

#' Returns the current list of AWS services and a list of service
#' categories for each service
#'
#' Returns the current list of AWS services and a list of service
#' categories for each service. You then use service names and categories
#' in your CreateCase requests. Each AWS service has its own set of
#' categories.
#' 
#' The service codes and category codes correspond to the values that
#' appear in the **Service** and **Category** lists on the AWS Support
#' Center [Create
#' Case](https://console.aws.amazon.com/support/home#/case/create) page.
#' The values in those fields don\'t necessarily match the service codes
#' and categories returned by the `DescribeServices` operation. Always use
#' the service codes and categories that the `DescribeServices` operation
#' returns, so that you have the most recent set of service and category
#' codes.
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_describe_services(serviceCodeList, language)
#'
#' @param serviceCodeList A JSON-formatted list of service codes available for AWS services.
#' @param language The ISO 639-1 code for the language in which AWS provides support. AWS
#' Support currently supports English (\"en\") and Japanese (\"ja\").
#' Language parameters must be passed explicitly for operations that take
#' them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_services(
#'   serviceCodeList = list(
#'     "string"
#'   ),
#'   language = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_services
support_describe_services <- function(serviceCodeList = NULL, language = NULL) {
  op <- new_operation(
    name = "DescribeServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_services_input(serviceCodeList = serviceCodeList, language = language)
  output <- .support$describe_services_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_services <- support_describe_services

#' Returns the list of severity levels that you can assign to an AWS
#' Support case
#'
#' Returns the list of severity levels that you can assign to an AWS
#' Support case. The severity level for a case is also a field in the
#' CaseDetails data type that you include for a CreateCase request.
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_describe_severity_levels(language)
#'
#' @param language The ISO 639-1 code for the language in which AWS provides support. AWS
#' Support currently supports English (\"en\") and Japanese (\"ja\").
#' Language parameters must be passed explicitly for operations that take
#' them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_severity_levels(
#'   language = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_severity_levels
support_describe_severity_levels <- function(language = NULL) {
  op <- new_operation(
    name = "DescribeSeverityLevels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_severity_levels_input(language = language)
  output <- .support$describe_severity_levels_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_severity_levels <- support_describe_severity_levels

#' Returns the refresh status of the AWS Trusted Advisor checks that have
#' the specified check IDs
#'
#' Returns the refresh status of the AWS Trusted Advisor checks that have
#' the specified check IDs. You can get the check IDs by calling the
#' DescribeTrustedAdvisorChecks operation.
#' 
#' Some checks are refreshed automatically, and you can\'t return their
#' refresh statuses by using the
#' `DescribeTrustedAdvisorCheckRefreshStatuses` operation. If you call this
#' operation for these checks, you might see an `InvalidParameterValue`
#' error.
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_describe_trusted_advisor_check_refresh_statuses(checkIds)
#'
#' @param checkIds &#91;required&#93; The IDs of the Trusted Advisor checks to get the status of.
#' 
#' If you specify the check ID of a check that is automatically refreshed,
#' you might see an `InvalidParameterValue` error.
#'
#' @section Request syntax:
#' ```
#' svc$describe_trusted_advisor_check_refresh_statuses(
#'   checkIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_trusted_advisor_check_refresh_statuses
support_describe_trusted_advisor_check_refresh_statuses <- function(checkIds) {
  op <- new_operation(
    name = "DescribeTrustedAdvisorCheckRefreshStatuses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_trusted_advisor_check_refresh_statuses_input(checkIds = checkIds)
  output <- .support$describe_trusted_advisor_check_refresh_statuses_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_trusted_advisor_check_refresh_statuses <- support_describe_trusted_advisor_check_refresh_statuses

#' Returns the results of the AWS Trusted Advisor check that has the
#' specified check ID
#'
#' Returns the results of the AWS Trusted Advisor check that has the
#' specified check ID. You can get the check IDs by calling the
#' DescribeTrustedAdvisorChecks operation.
#' 
#' The response contains a TrustedAdvisorCheckResult object, which contains
#' these three objects:
#' 
#' -   TrustedAdvisorCategorySpecificSummary
#' 
#' -   TrustedAdvisorResourceDetail
#' 
#' -   TrustedAdvisorResourcesSummary
#' 
#' In addition, the response contains these fields:
#' 
#' -   **status** - The alert status of the check: \"ok\" (green),
#'     \"warning\" (yellow), \"error\" (red), or \"not\\_available\".
#' 
#' -   **timestamp** - The time of the last refresh of the check.
#' 
#' -   **checkId** - The unique identifier for the check.
#' 
#' <!-- -->
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_describe_trusted_advisor_check_result(checkId, language)
#'
#' @param checkId &#91;required&#93; The unique identifier for the Trusted Advisor check.
#' @param language The ISO 639-1 code for the language in which AWS provides support. AWS
#' Support currently supports English (\"en\") and Japanese (\"ja\").
#' Language parameters must be passed explicitly for operations that take
#' them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_trusted_advisor_check_result(
#'   checkId = "string",
#'   language = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_trusted_advisor_check_result
support_describe_trusted_advisor_check_result <- function(checkId, language = NULL) {
  op <- new_operation(
    name = "DescribeTrustedAdvisorCheckResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_trusted_advisor_check_result_input(checkId = checkId, language = language)
  output <- .support$describe_trusted_advisor_check_result_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_trusted_advisor_check_result <- support_describe_trusted_advisor_check_result

#' Returns the results for the AWS Trusted Advisor check summaries for the
#' check IDs that you specified
#'
#' Returns the results for the AWS Trusted Advisor check summaries for the
#' check IDs that you specified. You can get the check IDs by calling the
#' DescribeTrustedAdvisorChecks operation.
#' 
#' The response contains an array of TrustedAdvisorCheckSummary objects.
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_describe_trusted_advisor_check_summaries(checkIds)
#'
#' @param checkIds &#91;required&#93; The IDs of the Trusted Advisor checks.
#'
#' @section Request syntax:
#' ```
#' svc$describe_trusted_advisor_check_summaries(
#'   checkIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_trusted_advisor_check_summaries
support_describe_trusted_advisor_check_summaries <- function(checkIds) {
  op <- new_operation(
    name = "DescribeTrustedAdvisorCheckSummaries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_trusted_advisor_check_summaries_input(checkIds = checkIds)
  output <- .support$describe_trusted_advisor_check_summaries_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_trusted_advisor_check_summaries <- support_describe_trusted_advisor_check_summaries

#' Returns information about all available AWS Trusted Advisor checks,
#' including the name, ID, category, description, and metadata
#'
#' Returns information about all available AWS Trusted Advisor checks,
#' including the name, ID, category, description, and metadata. You must
#' specify a language code. The AWS Support API currently supports English
#' (\"en\") and Japanese (\"ja\"). The response contains a
#' TrustedAdvisorCheckDescription object for each check. You must set the
#' AWS Region to us-east-1.
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_describe_trusted_advisor_checks(language)
#'
#' @param language &#91;required&#93; The ISO 639-1 code for the language in which AWS provides support. AWS
#' Support currently supports English (\"en\") and Japanese (\"ja\").
#' Language parameters must be passed explicitly for operations that take
#' them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_trusted_advisor_checks(
#'   language = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_describe_trusted_advisor_checks
support_describe_trusted_advisor_checks <- function(language) {
  op <- new_operation(
    name = "DescribeTrustedAdvisorChecks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$describe_trusted_advisor_checks_input(language = language)
  output <- .support$describe_trusted_advisor_checks_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$describe_trusted_advisor_checks <- support_describe_trusted_advisor_checks

#' Refreshes the AWS Trusted Advisor check that you specify using the check
#' ID
#'
#' Refreshes the AWS Trusted Advisor check that you specify using the check
#' ID. You can get the check IDs by calling the
#' DescribeTrustedAdvisorChecks operation.
#' 
#' Some checks are refreshed automatically. If you call the
#' `RefreshTrustedAdvisorCheck` operation to refresh them, you might see
#' the `InvalidParameterValue` error.
#' 
#' The response contains a TrustedAdvisorCheckRefreshStatus object.
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_refresh_trusted_advisor_check(checkId)
#'
#' @param checkId &#91;required&#93; The unique identifier for the Trusted Advisor check to refresh.
#' **Note:** Specifying the check ID of a check that is automatically
#' refreshed causes an `InvalidParameterValue` error.
#'
#' @section Request syntax:
#' ```
#' svc$refresh_trusted_advisor_check(
#'   checkId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_refresh_trusted_advisor_check
support_refresh_trusted_advisor_check <- function(checkId) {
  op <- new_operation(
    name = "RefreshTrustedAdvisorCheck",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$refresh_trusted_advisor_check_input(checkId = checkId)
  output <- .support$refresh_trusted_advisor_check_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$refresh_trusted_advisor_check <- support_refresh_trusted_advisor_check

#' Resolves a support case
#'
#' Resolves a support case. This operation takes a `caseId` and returns the
#' initial and final state of the case.
#' 
#' -   You must have a Business or Enterprise support plan to use the AWS
#'     Support API.
#' 
#' -   If you call the AWS Support API from an account that does not have a
#'     Business or Enterprise support plan, the
#'     `SubscriptionRequiredException` error message appears. For
#'     information about changing your support plan, see [AWS
#'     Support](http://aws.amazon.com/premiumsupport/).
#'
#' @usage
#' support_resolve_case(caseId)
#'
#' @param caseId The AWS Support case ID requested or returned in the call. The case ID
#' is an alphanumeric string formatted as shown in this example:
#' case-*12345678910-2013-c4c1d2bf33c5cf47*
#'
#' @section Request syntax:
#' ```
#' svc$resolve_case(
#'   caseId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname support_resolve_case
support_resolve_case <- function(caseId = NULL) {
  op <- new_operation(
    name = "ResolveCase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .support$resolve_case_input(caseId = caseId)
  output <- .support$resolve_case_output()
  config <- get_config()
  svc <- .support$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.support$operations$resolve_case <- support_resolve_case
