% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_tag_resource}
\alias{cloudwatch_tag_resource}
\title{Assigns one or more tags (key-value pairs) to the specified CloudWatch
resource}
\usage{
cloudwatch_tag_resource(ResourceARN, Tags)
}
\arguments{
\item{ResourceARN}{[required] The ARN of the CloudWatch resource that you\'re adding tags to.

The ARN format of an alarm is
\verb{arn:aws:cloudwatch:<i>Region</i>:<i>account-id</i>:alarm:<i>alarm-name</i> }

The ARN format of a Contributor Insights rule is
\verb{arn:aws:cloudwatch:<i>Region</i>:<i>account-id</i>:insight-rule:<i>insight-rule-name</i> }

For more information on ARN format, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies}{Resource Types Defined by Amazon CloudWatch}
in the \emph{Amazon Web Services General Reference}.}

\item{Tags}{[required] The list of key-value pairs to associate with the alarm.}
}
\description{
Assigns one or more tags (key-value pairs) to the specified CloudWatch
resource. Currently, the only CloudWatch resources that can be tagged
are alarms and Contributor Insights rules.
}
\details{
Tags can help you organize and categorize your resources. You can also
use them to scope user permissions, by granting a user permission to
access or change only resources with certain tag values.

Tags don\'t have any semantic meaning to AWS and are interpreted
strictly as strings of characters.

You can use the \code{TagResource} action with an alarm that already has
tags. If you specify a new tag key for the alarm, this tag is appended
to the list of tags associated with the alarm. If you specify a tag key
that is already associated with the alarm, the new tag value that you
specify replaces the previous value for that tag.

You can associate as many as 50 tags with a CloudWatch resource.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  ResourceARN = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
