# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Systems Manager Incident Manager Contacts
#'
#' @description
#' Systems Manager Incident Manager is an incident management console
#' designed to help users mitigate and recover from incidents affecting
#' their Amazon Web Services-hosted applications. An incident is any
#' unplanned interruption or reduction in quality of services.
#' 
#' Incident Manager increases incident resolution by notifying responders
#' of impact, highlighting relevant troubleshooting data, and providing
#' collaboration tools to get services back up and running. To achieve the
#' primary goal of reducing the time-to-resolution of critical incidents,
#' Incident Manager automates response plans and enables responder team
#' escalation.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- ssmcontacts(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- ssmcontacts()
#' # The following accept-page operation uses an accept code sent to the
#' # contact channel to accept a page.
#' svc$accept_page(
#'   AcceptCode = "425440",
#'   AcceptType = "READ",
#'   PageId = "arn:aws:ssm-contacts:us-east-2:682428703967:page/akuam/94ea0c7b..."
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=ssmcontacts_accept_page]{accept_page} \tab Used to acknowledge an engagement to a contact channel during an incident\cr
#'  \link[=ssmcontacts_activate_contact_channel]{activate_contact_channel} \tab Activates a contact's contact channel\cr
#'  \link[=ssmcontacts_create_contact]{create_contact} \tab Contacts are either the contacts that Incident Manager engages during an incident or the escalation plans that Incident Manager uses to engage contacts in phases during an incident\cr
#'  \link[=ssmcontacts_create_contact_channel]{create_contact_channel} \tab A contact channel is the method that Incident Manager uses to engage your contact\cr
#'  \link[=ssmcontacts_deactivate_contact_channel]{deactivate_contact_channel} \tab To no longer receive Incident Manager engagements to a contact channel, you can deactivate the channel\cr
#'  \link[=ssmcontacts_delete_contact]{delete_contact} \tab To remove a contact from Incident Manager, you can delete the contact\cr
#'  \link[=ssmcontacts_delete_contact_channel]{delete_contact_channel} \tab To no longer receive engagements on a contact channel, you can delete the channel from a contact\cr
#'  \link[=ssmcontacts_describe_engagement]{describe_engagement} \tab Incident Manager uses engagements to engage contacts and escalation plans during an incident\cr
#'  \link[=ssmcontacts_describe_page]{describe_page} \tab Lists details of the engagement to a contact channel\cr
#'  \link[=ssmcontacts_get_contact]{get_contact} \tab Retrieves information about the specified contact or escalation plan\cr
#'  \link[=ssmcontacts_get_contact_channel]{get_contact_channel} \tab List details about a specific contact channel\cr
#'  \link[=ssmcontacts_get_contact_policy]{get_contact_policy} \tab Retrieves the resource policies attached to the specified contact or escalation plan\cr
#'  \link[=ssmcontacts_list_contact_channels]{list_contact_channels} \tab Lists all contact channels for the specified contact\cr
#'  \link[=ssmcontacts_list_contacts]{list_contacts} \tab Lists all contacts and escalation plans in Incident Manager\cr
#'  \link[=ssmcontacts_list_engagements]{list_engagements} \tab Lists all engagements that have happened in an incident\cr
#'  \link[=ssmcontacts_list_page_receipts]{list_page_receipts} \tab Lists all of the engagements to contact channels that have been acknowledged\cr
#'  \link[=ssmcontacts_list_pages_by_contact]{list_pages_by_contact} \tab Lists the engagements to a contact's contact channels\cr
#'  \link[=ssmcontacts_list_pages_by_engagement]{list_pages_by_engagement} \tab Lists the engagements to contact channels that occurred by engaging a contact\cr
#'  \link[=ssmcontacts_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags of an escalation plan or contact\cr
#'  \link[=ssmcontacts_put_contact_policy]{put_contact_policy} \tab Adds a resource policy to the specified contact or escalation plan\cr
#'  \link[=ssmcontacts_send_activation_code]{send_activation_code} \tab Sends an activation code to a contact channel\cr
#'  \link[=ssmcontacts_start_engagement]{start_engagement} \tab Starts an engagement to a contact or escalation plan\cr
#'  \link[=ssmcontacts_stop_engagement]{stop_engagement} \tab Stops an engagement before it finishes the final stage of the escalation plan or engagement plan\cr
#'  \link[=ssmcontacts_tag_resource]{tag_resource} \tab Tags a contact or escalation plan\cr
#'  \link[=ssmcontacts_untag_resource]{untag_resource} \tab Removes tags from the specified resource\cr
#'  \link[=ssmcontacts_update_contact]{update_contact} \tab Updates the contact or escalation plan specified\cr
#'  \link[=ssmcontacts_update_contact_channel]{update_contact_channel} \tab Updates a contact's contact channel
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname ssmcontacts
#' @export
ssmcontacts <- function(config = list()) {
  svc <- .ssmcontacts$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.ssmcontacts <- list()

.ssmcontacts$operations <- list()

.ssmcontacts$metadata <- list(
  service_name = "ssmcontacts",
  endpoints = list("*" = list(endpoint = "ssm-contacts.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "ssm-contacts.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "ssm-contacts.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "ssm-contacts.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "SSM Contacts",
  api_version = "2021-05-03",
  signing_name = "ssm-contacts",
  json_version = "1.1",
  target_prefix = "SSMContacts"
)

.ssmcontacts$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.ssmcontacts$metadata, handlers, config)
}
