% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/managedgrafana_operations.R
\name{managedgrafana_create_workspace}
\alias{managedgrafana_create_workspace}
\title{Creates a workspace}
\usage{
managedgrafana_create_workspace(
  accountAccessType,
  authenticationProviders,
  clientToken = NULL,
  organizationRoleName = NULL,
  permissionType,
  stackSetName = NULL,
  tags = NULL,
  workspaceDataSources = NULL,
  workspaceDescription = NULL,
  workspaceName = NULL,
  workspaceNotificationDestinations = NULL,
  workspaceOrganizationalUnits = NULL,
  workspaceRoleArn = NULL
)
}
\arguments{
\item{accountAccessType}{[required] Specifies whether the workspace can access Amazon Web Services resources
in this Amazon Web Services account only, or whether it can also access
Amazon Web Services resources in other accounts in the same
organization. If you specify \code{ORGANIZATION}, you must specify which
organizational units the workspace can access in the
\code{workspaceOrganizationalUnits} parameter.}

\item{authenticationProviders}{[required] Specifies whether this workspace uses SAML 2.0, Amazon Web Services
Single Sign On, or both to authenticate users for using the Grafana
console within a workspace. For more information, see \href{https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html}{User authentication in Amazon Managed Grafana}.}

\item{clientToken}{A unique, case-sensitive, user-provided identifier to ensure the
idempotency of the request.}

\item{organizationRoleName}{The name of an IAM role that already exists to use with Organizations to
access Amazon Web Services data sources and notification channels in
other accounts in an organization.}

\item{permissionType}{[required] If you specify \code{SERVICE_MANAGED} on AWS Grafana console, Amazon Managed
Grafana automatically creates the IAM roles and provisions the
permissions that the workspace needs to use Amazon Web Services data
sources and notification channels. In CLI mode, the permissionType
\code{SERVICE_MANAGED} will not create the IAM role for you.

If you specify \code{CUSTOMER_MANAGED}, you will manage those roles and
permissions yourself. If you are creating this workspace in a member
account of an organization that is not a delegated administrator
account, and you want the workspace to access data sources in other
Amazon Web Services accounts in the organization, you must choose
\code{CUSTOMER_MANAGED}.

For more information, see \href{https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html}{Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels}.}

\item{stackSetName}{The name of the CloudFormation stack set to use to generate IAM roles to
be used for this workspace.}

\item{tags}{The list of tags associated with the workspace.}

\item{workspaceDataSources}{Specify the Amazon Web Services data sources that you want to be queried
in this workspace. Specifying these data sources here enables Amazon
Managed Grafana to create IAM roles and permissions that allow Amazon
Managed Grafana to read data from these sources. You must still add them
as data sources in the Grafana console in the workspace.

If you don't specify a data source here, you can still add it as a data
source in the workspace console later. However, you will then have to
manually configure permissions for it.}

\item{workspaceDescription}{A description for the workspace. This is used only to help you identify
this workspace.

Pattern: \verb{^[\\\\p\{L\}\\\\p\{Z\}\\\\p\{N\}\\\\p\{P\}]\{0,2048\}$}}

\item{workspaceName}{The name for the workspace. It does not have to be unique.}

\item{workspaceNotificationDestinations}{Specify the Amazon Web Services notification channels that you plan to
use in this workspace. Specifying these data sources here enables Amazon
Managed Grafana to create IAM roles and permissions that allow Amazon
Managed Grafana to use these channels.}

\item{workspaceOrganizationalUnits}{Specifies the organizational units that this workspace is allowed to use
data sources from, if this workspace is in an account that is part of an
organization.}

\item{workspaceRoleArn}{The workspace needs an IAM role that grants permissions to the Amazon
Web Services resources that the workspace will view data from. If you
already have a role that you want to use, specify it here. The
permission type should be set to \code{CUSTOMER_MANAGED}.}
}
\description{
Creates a \emph{workspace}. In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.

See \url{https://paws-r.github.io/docs/managedgrafana/create_workspace.html} for full documentation.
}
\keyword{internal}
