% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_copy_product}
\alias{servicecatalog_copy_product}
\title{Copies the specified source product to the specified target product or a
new product}
\usage{
servicecatalog_copy_product(
  AcceptLanguage = NULL,
  SourceProductArn,
  TargetProductId = NULL,
  TargetProductName = NULL,
  SourceProvisioningArtifactIdentifiers = NULL,
  CopyOptions = NULL,
  IdempotencyToken
)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{SourceProductArn}{[required] The Amazon Resource Name (ARN) of the source product.}

\item{TargetProductId}{The identifier of the target product. By default, a new product is
created.}

\item{TargetProductName}{A name for the target product. The default is the name of the source
product.}

\item{SourceProvisioningArtifactIdentifiers}{The identifiers of the provisioning artifacts (also known as versions)
of the product to copy. By default, all provisioning artifacts are
copied.}

\item{CopyOptions}{The copy options. If the value is \code{CopyTags}, the tags from the source
product are copied to the target product.}

\item{IdempotencyToken}{[required] A unique identifier that you provide to ensure idempotency. If multiple
requests differ only by the idempotency token, the same response is
returned for each repeated request.}
}
\description{
Copies the specified source product to the specified target product or a new product.

See \url{https://paws-r.github.io/docs/servicecatalog/copy_product.html} for full documentation.
}
\keyword{internal}
