% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_get_predictive_scaling_forecast}
\alias{autoscaling_get_predictive_scaling_forecast}
\title{Retrieves the forecast data for a predictive scaling policy}
\usage{
autoscaling_get_predictive_scaling_forecast(
  AutoScalingGroupName,
  PolicyName,
  StartTime,
  EndTime
)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{PolicyName}{[required] The name of the policy.}

\item{StartTime}{[required] The inclusive start time of the time range for the forecast data to get.
At most, the date and time can be one year before the current date and
time.}

\item{EndTime}{[required] The exclusive end time of the time range for the forecast data to get.
The maximum time duration between the start and end time is 30 days.

Although this parameter can accept a date and time that is more than two
days in the future, the availability of forecast data has limits. Amazon
EC2 Auto Scaling only issues forecasts for periods of two days in
advance.}
}
\description{
Retrieves the forecast data for a predictive scaling policy.

See \url{https://www.paws-r-sdk.com/docs/autoscaling_get_predictive_scaling_forecast/} for full documentation.
}
\keyword{internal}
