% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_tag_resource}
\alias{cloudwatchlogs_tag_resource}
\title{Assigns one or more tags (key-value pairs) to the specified CloudWatch
Logs resource}
\usage{
cloudwatchlogs_tag_resource(resourceArn, tags)
}
\arguments{
\item{resourceArn}{[required] The ARN of the resource that you're adding tags to.

The ARN format of a log group is
\code{arn:aws:logs:Region:account-id:log-group:log-group-name }

The ARN format of a destination is
\code{arn:aws:logs:Region:account-id:destination:destination-name }

For more information about ARN format, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/iam-access-control-overview-cwl.html}{CloudWatch Logs resources and operations}.}

\item{tags}{[required] The list of key-value pairs to associate with the resource.}
}
\description{
Assigns one or more tags (key-value pairs) to the specified CloudWatch Logs resource. Currently, the only CloudWatch Logs resources that can be tagged are log groups and destinations.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_tag_resource/} for full documentation.
}
\keyword{internal}
