% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_disassociate_principal_from_portfolio}
\alias{servicecatalog_disassociate_principal_from_portfolio}
\title{Disassociates a previously associated principal ARN from a specified
portfolio}
\usage{
servicecatalog_disassociate_principal_from_portfolio(
  AcceptLanguage = NULL,
  PortfolioId,
  PrincipalARN,
  PrincipalType = NULL
)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{PortfolioId}{[required] The portfolio identifier.}

\item{PrincipalARN}{[required] The ARN of the principal (user, role, or group). This field allows an
ARN with no \code{accountID} with or without wildcard characters if
\code{PrincipalType} is \code{IAM_PATTERN}.}

\item{PrincipalType}{The supported value is \code{IAM} if you use a fully defined ARN, or
\code{IAM_PATTERN} if you specify an \code{IAM} ARN with no AccountId, with or
without wildcard characters.}
}
\description{
Disassociates a previously associated principal ARN from a specified portfolio.

See \url{https://www.paws-r-sdk.com/docs/servicecatalog_disassociate_principal_from_portfolio/} for full documentation.
}
\keyword{internal}
