% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_put_organization_config_rule}
\alias{configservice_put_organization_config_rule}
\title{Adds or updates an Config rule for your entire organization to evaluate
if your Amazon Web Services resources comply with your desired
configurations}
\usage{
configservice_put_organization_config_rule(
  OrganizationConfigRuleName,
  OrganizationManagedRuleMetadata = NULL,
  OrganizationCustomRuleMetadata = NULL,
  ExcludedAccounts = NULL,
  OrganizationCustomPolicyRuleMetadata = NULL
)
}
\arguments{
\item{OrganizationConfigRuleName}{[required] The name that you assign to an organization Config rule.}

\item{OrganizationManagedRuleMetadata}{An \code{OrganizationManagedRuleMetadata} object. This object specifies
organization managed rule metadata such as resource type and ID of
Amazon Web Services resource along with the rule identifier. It also
provides the frequency with which you want Config to run evaluations for
the rule if the trigger type is periodic.}

\item{OrganizationCustomRuleMetadata}{An \code{OrganizationCustomRuleMetadata} object. This object specifies
organization custom rule metadata such as resource type, resource ID of
Amazon Web Services resource, Lambda function ARN, and organization
trigger types that trigger Config to evaluate your Amazon Web Services
resources against a rule. It also provides the frequency with which you
want Config to run evaluations for the rule if the trigger type is
periodic.}

\item{ExcludedAccounts}{A comma-separated list of accounts that you want to exclude from an
organization Config rule.}

\item{OrganizationCustomPolicyRuleMetadata}{An \code{OrganizationCustomPolicyRuleMetadata} object. This object specifies
metadata for your organization's Config Custom Policy rule. The metadata
includes the runtime system in use, which accounts have debug logging
enabled, and other custom rule metadata, such as resource type, resource
ID of Amazon Web Services resource, and organization trigger types that
initiate Config to evaluate Amazon Web Services resources against a
rule.}
}
\description{
Adds or updates an Config rule for your entire organization to evaluate if your Amazon Web Services resources comply with your desired configurations. For information on how many organization Config rules you can have per account, see \href{https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html}{\strong{Service Limits}} in the \emph{Config Developer Guide}.

See \url{https://www.paws-r-sdk.com/docs/configservice_put_organization_config_rule/} for full documentation.
}
\keyword{internal}
