% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchinternetmonitor_operations.R
\name{cloudwatchinternetmonitor_list_health_events}
\alias{cloudwatchinternetmonitor_list_health_events}
\title{Lists all health events for a monitor in Amazon CloudWatch Internet
Monitor}
\usage{
cloudwatchinternetmonitor_list_health_events(
  MonitorName,
  StartTime = NULL,
  EndTime = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  EventStatus = NULL
)
}
\arguments{
\item{MonitorName}{[required] The name of the monitor.}

\item{StartTime}{The time when a health event started.}

\item{EndTime}{The time when a health event ended. If the health event is still
ongoing, then the end time is not set.}

\item{NextToken}{The token for the next set of results. You receive this token from a
previous call.}

\item{MaxResults}{The number of health event objects that you want to return with this
call.}

\item{EventStatus}{The status of a health event.}
}
\description{
Lists all health events for a monitor in Amazon CloudWatch Internet Monitor. Returns information for health events including the event start and end time and the status.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_list_health_events/} for full documentation.
}
\keyword{internal}
