% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_delete_resiliency_policy}
\alias{resiliencehub_delete_resiliency_policy}
\title{Deletes a resiliency policy}
\usage{
resiliencehub_delete_resiliency_policy(clientToken = NULL, policyArn)
}
\arguments{
\item{clientToken}{Used for an idempotency token. A client token is a unique,
case-sensitive string of up to 64 ASCII characters. You should not reuse
the same client token for other API requests.}

\item{policyArn}{[required] Amazon Resource Name (ARN) of the resiliency policy. The format for this
ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:resiliency-policy/\code{policy-id}.
For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference} guide.}
}
\description{
Deletes a resiliency policy. This is a destructive action that can't be undone.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_delete_resiliency_policy/} for full documentation.
}
\keyword{internal}
