% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_update_maintenance_window_task}
\alias{ssm_update_maintenance_window_task}
\title{Modifies a task assigned to a maintenance window}
\usage{
ssm_update_maintenance_window_task(
  WindowId,
  WindowTaskId,
  Targets = NULL,
  TaskArn = NULL,
  ServiceRoleArn = NULL,
  TaskParameters = NULL,
  TaskInvocationParameters = NULL,
  Priority = NULL,
  MaxConcurrency = NULL,
  MaxErrors = NULL,
  LoggingInfo = NULL,
  Name = NULL,
  Description = NULL,
  Replace = NULL,
  CutoffBehavior = NULL,
  AlarmConfiguration = NULL
)
}
\arguments{
\item{WindowId}{[required] The maintenance window ID that contains the task to modify.}

\item{WindowTaskId}{[required] The task ID to modify.}

\item{Targets}{The targets (either managed nodes or tags) to modify. Managed nodes are
specified using the format
\verb{Key=instanceids,Values=instanceID_1,instanceID_2}. Tags are specified
using the format \verb{ Key=tag_name,Values=tag_value}.

One or more targets must be specified for maintenance window Run
Command-type tasks. Depending on the task, targets are optional for
other maintenance window task types (Automation, Lambda, and Step
Functions). For more information about running tasks that don't specify
targets, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html}{Registering maintenance window tasks without targets}
in the \emph{Amazon Web Services Systems Manager User Guide}.}

\item{TaskArn}{The task ARN to modify.}

\item{ServiceRoleArn}{The Amazon Resource Name (ARN) of the IAM service role for Amazon Web
Services Systems Manager to assume when running a maintenance window
task. If you do not specify a service role ARN, Systems Manager uses a
service-linked role in your account. If no appropriate service-linked
role for Systems Manager exists in your account, it is created when you
run
\code{\link[=ssm_register_task_with_maintenance_window]{register_task_with_maintenance_window}}.

However, for an improved security posture, we strongly recommend
creating a custom policy and custom service role for running your
maintenance window tasks. The policy can be crafted to provide only the
permissions needed for your particular maintenance window tasks. For
more information, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html}{Setting up maintenance windows}
in the in the \emph{Amazon Web Services Systems Manager User Guide}.}

\item{TaskParameters}{The parameters to modify.

\code{TaskParameters} has been deprecated. To specify parameters to pass to a
task when it runs, instead use the \code{Parameters} option in the
\code{TaskInvocationParameters} structure. For information about how Systems
Manager handles these options for the supported maintenance window task
types, see MaintenanceWindowTaskInvocationParameters.

The map has the following format:

Key: string, between 1 and 255 characters

Value: an array of strings, each string is between 1 and 255 characters}

\item{TaskInvocationParameters}{The parameters that the task should use during execution. Populate only
the fields that match the task type. All other fields should be empty.

When you update a maintenance window task that has options specified in
\code{TaskInvocationParameters}, you must provide again all the
\code{TaskInvocationParameters} values that you want to retain. The values
you don't specify again are removed. For example, suppose that when you
registered a Run Command task, you specified \code{TaskInvocationParameters}
values for \code{Comment}, \code{NotificationConfig}, and \code{OutputS3BucketName}. If
you update the maintenance window task and specify only a different
\code{OutputS3BucketName} value, the values for \code{Comment} and
\code{NotificationConfig} are removed.}

\item{Priority}{The new task priority to specify. The lower the number, the higher the
priority. Tasks that have the same priority are scheduled in parallel.}

\item{MaxConcurrency}{The new \code{MaxConcurrency} value you want to specify. \code{MaxConcurrency} is
the number of targets that are allowed to run this task, in parallel.

Although this element is listed as "Required: No", a value can be
omitted only when you are registering or updating a \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html}{targetless task}
You must provide a value in all other cases.

For maintenance window tasks without a target specified, you can't
supply a value for this option. Instead, the system inserts a
placeholder value of \code{1}. This value doesn't affect the running of your
task.}

\item{MaxErrors}{The new \code{MaxErrors} value to specify. \code{MaxErrors} is the maximum number
of errors that are allowed before the task stops being scheduled.

Although this element is listed as "Required: No", a value can be
omitted only when you are registering or updating a \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html}{targetless task}
You must provide a value in all other cases.

For maintenance window tasks without a target specified, you can't
supply a value for this option. Instead, the system inserts a
placeholder value of \code{1}. This value doesn't affect the running of your
task.}

\item{LoggingInfo}{The new logging location in Amazon S3 to specify.

\code{LoggingInfo} has been deprecated. To specify an Amazon Simple Storage
Service (Amazon S3) bucket to contain logs, instead use the
\code{OutputS3BucketName} and \code{OutputS3KeyPrefix} options in the
\code{TaskInvocationParameters} structure. For information about how Amazon
Web Services Systems Manager handles these options for the supported
maintenance window task types, see
MaintenanceWindowTaskInvocationParameters.}

\item{Name}{The new task name to specify.}

\item{Description}{The new task description to specify.}

\item{Replace}{If True, then all fields that are required by the
\code{\link[=ssm_register_task_with_maintenance_window]{register_task_with_maintenance_window}}
operation are also required for this API request. Optional fields that
aren't specified are set to null.}

\item{CutoffBehavior}{Indicates whether tasks should continue to run after the cutoff time
specified in the maintenance windows is reached.
\itemize{
\item \code{CONTINUE_TASK}: When the cutoff time is reached, any tasks that are
running continue. The default value.
\item \code{CANCEL_TASK}:
\itemize{
\item For Automation, Lambda, Step Functions tasks: When the cutoff
time is reached, any task invocations that are already running
continue, but no new task invocations are started.
\item For Run Command tasks: When the cutoff time is reached, the
system sends a \code{\link[=ssm_cancel_command]{cancel_command}} operation
that attempts to cancel the command associated with the task.
However, there is no guarantee that the command will be
terminated and the underlying process stopped.
}

The status for tasks that are not completed is \code{TIMED_OUT}.
}}

\item{AlarmConfiguration}{The CloudWatch alarm you want to apply to your maintenance window task.}
}
\description{
Modifies a task assigned to a maintenance window. You can't change the task type, but you can change the following values:

See \url{https://www.paws-r-sdk.com/docs/ssm_update_maintenance_window_task/} for full documentation.
}
\keyword{internal}
