% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_create_stack}
\alias{cloudformation_create_stack}
\title{Creates a stack as specified in the template}
\usage{
cloudformation_create_stack(
  StackName,
  TemplateBody = NULL,
  TemplateURL = NULL,
  Parameters = NULL,
  DisableRollback = NULL,
  RollbackConfiguration = NULL,
  TimeoutInMinutes = NULL,
  NotificationARNs = NULL,
  Capabilities = NULL,
  ResourceTypes = NULL,
  RoleARN = NULL,
  OnFailure = NULL,
  StackPolicyBody = NULL,
  StackPolicyURL = NULL,
  Tags = NULL,
  ClientRequestToken = NULL,
  EnableTerminationProtection = NULL,
  RetainExceptOnCreate = NULL
)
}
\arguments{
\item{StackName}{[required] The name that's associated with the stack. The name must be unique in
the Region in which you are creating the stack.

A stack name can contain only alphanumeric characters (case sensitive)
and hyphens. It must start with an alphabetical character and can't be
longer than 128 characters.}

\item{TemplateBody}{Structure containing the template body with a minimum length of 1 byte
and a maximum length of 51,200 bytes. For more information, go to
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template anatomy}
in the \emph{CloudFormation User Guide}.

Conditional: You must specify either the \code{TemplateBody} or the
\code{TemplateURL} parameter, but not both.}

\item{TemplateURL}{Location of file containing the template body. The URL must point to a
template (max size: 460,800 bytes) that's located in an Amazon S3 bucket
or a Systems Manager document. For more information, go to the \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template anatomy}
in the \emph{CloudFormation User Guide}. The location for an Amazon S3 bucket
must start with \verb{https://}.

Conditional: You must specify either the \code{TemplateBody} or the
\code{TemplateURL} parameter, but not both.}

\item{Parameters}{A list of \code{Parameter} structures that specify input parameters for the
stack. For more information, see the
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html}{Parameter}
data type.}

\item{DisableRollback}{Set to \code{true} to disable rollback of the stack if stack creation failed.
You can specify either \code{DisableRollback} or \code{OnFailure}, but not both.

Default: \code{false}}

\item{RollbackConfiguration}{The rollback triggers for CloudFormation to monitor during stack
creation and updating operations, and for the specified monitoring
period afterwards.}

\item{TimeoutInMinutes}{The amount of time that can pass before the stack status becomes
\code{CREATE_FAILED}; if \code{DisableRollback} is not set or is set to \code{false},
the stack will be rolled back.}

\item{NotificationARNs}{The Amazon Simple Notification Service (Amazon SNS) topic ARNs to
publish stack related events. You can find your Amazon SNS topic ARNs
using the Amazon SNS console or your Command Line Interface (CLI).}

\item{Capabilities}{In some cases, you must explicitly acknowledge that your stack template
contains certain capabilities in order for CloudFormation to create the
stack.
\itemize{
\item \code{CAPABILITY_IAM} and \code{CAPABILITY_NAMED_IAM}

Some stack templates might include resources that can affect
permissions in your Amazon Web Services account; for example, by
creating new Identity and Access Management (IAM) users. For those
stacks, you must explicitly acknowledge this by specifying one of
these capabilities.

The following IAM resources require you to specify either the
\code{CAPABILITY_IAM} or \code{CAPABILITY_NAMED_IAM} capability.
\itemize{
\item If you have IAM resources, you can specify either capability.
\item If you have IAM resources with custom names, you \emph{must} specify
\code{CAPABILITY_NAMED_IAM}.
\item If you don't specify either of these capabilities,
CloudFormation returns an \code{InsufficientCapabilities} error.
}

If your stack template contains these resources, we recommend that
you review all permissions associated with them and edit their
permissions if necessary.
\itemize{
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-accesskey.html}{AWS::IAM::AccessKey}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-group.html}{AWS::IAM::Group}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html}{AWS::IAM::InstanceProfile}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/}{AWS::IAM::Policy}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html}{AWS::IAM::Role}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-user.html}{AWS::IAM::User}
\item \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-usertogroupaddition.html}{AWS::IAM::UserToGroupAddition}
}

For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#capabilities}{Acknowledging IAM Resources in CloudFormation Templates}.
\item \code{CAPABILITY_AUTO_EXPAND}

Some template contain macros. Macros perform custom processing on
templates; this can include simple actions like find-and-replace
operations, all the way to extensive transformations of entire
templates. Because of this, users typically create a change set from
the processed template, so that they can review the changes
resulting from the macros before actually creating the stack. If
your stack template contains one or more macros, and you choose to
create a stack directly from the processed template, without first
reviewing the resulting changes in a change set, you must
acknowledge this capability. This includes the
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/create-reusable-transform-function-snippets-and-add-to-your-template-with-aws-include-transform.html}{AWS::Include}
and
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/transform-aws-serverless.html}{AWS::Serverless}
transforms, which are macros hosted by CloudFormation.

If you want to create a stack from a stack template that contains
macros \emph{and} nested stacks, you must create the stack directly from
the template using this capability.

You should only create stacks directly from a stack template that
contains macros if you know what processing the macro performs.

Each macro relies on an underlying Lambda service function for
processing stack templates. Be aware that the Lambda function owner
can update the function operation without CloudFormation being
notified.

For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-macros.html}{Using CloudFormation macros to perform custom processing on templates}.
}

Only one of the \code{Capabilities} and \code{ResourceType} parameters can be
specified.}

\item{ResourceTypes}{The template resource types that you have permissions to work with for
this create stack action, such as \verb{AWS::EC2::Instance}, \verb{AWS::EC2::*},
or \code{Custom::MyCustomInstance}. Use the following syntax to describe
template resource types: \verb{AWS::*} (for all Amazon Web Services
resources), \verb{Custom::*} (for all custom resources),
\code{Custom::logical_ID } (for a specific custom resource),
\verb{AWS::service_name::*} (for all resources of a particular Amazon Web
Services service), and \verb{AWS::service_name::resource_logical_ID } (for a
specific Amazon Web Services resource).

If the list of resource types doesn't include a resource that you're
creating, the stack creation fails. By default, CloudFormation grants
permissions to all resource types. Identity and Access Management (IAM)
uses this parameter for CloudFormation-specific condition keys in IAM
policies. For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html}{Controlling Access with Identity and Access Management}.

Only one of the \code{Capabilities} and \code{ResourceType} parameters can be
specified.}

\item{RoleARN}{The Amazon Resource Name (ARN) of an Identity and Access Management
(IAM) role that CloudFormation assumes to create the stack.
CloudFormation uses the role's credentials to make calls on your behalf.
CloudFormation always uses this role for all future operations on the
stack. Provided that users have permission to operate on the stack,
CloudFormation uses this role even if the users don't have permission to
pass it. Ensure that the role grants least privilege.

If you don't specify a value, CloudFormation uses the role that was
previously associated with the stack. If no role is available,
CloudFormation uses a temporary session that's generated from your user
credentials.}

\item{OnFailure}{Determines what action will be taken if stack creation fails. This must
be one of: \code{DO_NOTHING}, \code{ROLLBACK}, or \code{DELETE}. You can specify either
\code{OnFailure} or \code{DisableRollback}, but not both.

Default: \code{ROLLBACK}}

\item{StackPolicyBody}{Structure containing the stack policy body. For more information, go to
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html}{Prevent Updates to Stack Resources}
in the \emph{CloudFormation User Guide}. You can specify either the
\code{StackPolicyBody} or the \code{StackPolicyURL} parameter, but not both.}

\item{StackPolicyURL}{Location of a file containing the stack policy. The URL must point to a
policy (maximum size: 16 KB) located in an S3 bucket in the same Region
as the stack. The location for an Amazon S3 bucket must start with
\verb{https://}. You can specify either the \code{StackPolicyBody} or the
\code{StackPolicyURL} parameter, but not both.}

\item{Tags}{Key-value pairs to associate with this stack. CloudFormation also
propagates these tags to the resources created in the stack. A maximum
number of 50 tags can be specified.}

\item{ClientRequestToken}{A unique identifier for this
\code{\link[=cloudformation_create_stack]{create_stack}} request. Specify this
token if you plan to retry requests so that CloudFormation knows that
you're not attempting to create a stack with the same name. You might
retry \code{\link[=cloudformation_create_stack]{create_stack}} requests to ensure
that CloudFormation successfully received them.

All events initiated by a given stack operation are assigned the same
client request token, which you can use to track operations. For
example, if you execute a \code{\link[=cloudformation_create_stack]{create_stack}}
operation with the token \code{token1}, then all the \code{StackEvents} generated
by that operation will have \code{ClientRequestToken} set as \code{token1}.

In the console, stack operations display the client request token on the
Events tab. Stack operations that are initiated from the console use the
token format \emph{Console-StackOperation-ID}, which helps you easily
identify the stack operation . For example, if you create a stack using
the console, each stack event would be assigned the same token in the
following format:
\verb{Console-CreateStack-7f59c3cf-00d2-40c7-b2ff-e75db0987002}.}

\item{EnableTerminationProtection}{Whether to enable termination protection on the specified stack. If a
user attempts to delete a stack with termination protection enabled, the
operation fails and the stack remains unchanged. For more information,
see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-protect-stacks.html}{Protecting a Stack From Being Deleted}
in the \emph{CloudFormation User Guide}. Termination protection is
deactivated on stacks by default.

For \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-nested-stacks.html}{nested stacks},
termination protection is set on the root stack and can't be changed
directly on the nested stack.}

\item{RetainExceptOnCreate}{When set to \code{true}, newly created resources are deleted when the
operation rolls back. This includes newly created resources marked with
a deletion policy of \code{Retain}.

Default: \code{false}}
}
\description{
Creates a stack as specified in the template. After the call completes successfully, the stack creation starts. You can check the status of the stack through the \code{\link[=cloudformation_describe_stacks]{describe_stacks}} operation.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_create_stack/} for full documentation.
}
\keyword{internal}
