% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_list_stack_instances}
\alias{cloudformation_list_stack_instances}
\title{Returns summary information about stack instances that are associated
with the specified stack set}
\usage{
cloudformation_list_stack_instances(
  StackSetName,
  NextToken = NULL,
  MaxResults = NULL,
  Filters = NULL,
  StackInstanceAccount = NULL,
  StackInstanceRegion = NULL,
  CallAs = NULL
)
}
\arguments{
\item{StackSetName}{[required] The name or unique ID of the stack set that you want to list stack
instances for.}

\item{NextToken}{If the previous request didn't return all the remaining results, the
response's \code{NextToken} parameter value is set to a token. To retrieve
the next set of results, call
\code{\link[=cloudformation_list_stack_instances]{list_stack_instances}} again and
assign that token to the request object's \code{NextToken} parameter. If
there are no remaining results, the previous response object's
\code{NextToken} parameter is set to \code{null}.}

\item{MaxResults}{The maximum number of results to be returned with a single call. If the
number of available results exceeds this maximum, the response includes
a \code{NextToken} value that you can assign to the \code{NextToken} request
parameter to get the next set of results.}

\item{Filters}{The filter to apply to stack instances}

\item{StackInstanceAccount}{The name of the Amazon Web Services account that you want to list stack
instances for.}

\item{StackInstanceRegion}{The name of the Region where you want to list stack instances.}

\item{CallAs}{[Service-managed permissions] Specifies whether you are acting as an
account administrator in the organization's management account or as a
delegated administrator in a member account.

By default, \code{SELF} is specified. Use \code{SELF} for stack sets with
self-managed permissions.
\itemize{
\item If you are signed in to the management account, specify \code{SELF}.
\item If you are signed in to a delegated administrator account, specify
\code{DELEGATED_ADMIN}.

Your Amazon Web Services account must be registered as a delegated
administrator in the management account. For more information, see
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html}{Register a delegated administrator}
in the \emph{CloudFormation User Guide}.
}}
}
\description{
Returns summary information about stack instances that are associated with the specified stack set. You can filter for stack instances that are associated with a specific Amazon Web Services account name or Region, or that have a specific status.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_list_stack_instances/} for full documentation.
}
\keyword{internal}
