% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_list_app_version_resource_mappings}
\alias{resiliencehub_list_app_version_resource_mappings}
\title{Lists how the resources in an application version are mapped/sourced
from}
\usage{
resiliencehub_list_app_version_resource_mappings(
  appArn,
  appVersion,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{appArn}{[required] Amazon Resource Name (ARN) of the Resilience Hub application. The format
for this ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app/\code{app-id}. For more
information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference} guide.}

\item{appVersion}{[required] The version of the application.}

\item{maxResults}{Maximum number of results to include in the response. If more results
exist than the specified \code{MaxResults} value, a token is included in the
response so that the remaining results can be retrieved.}

\item{nextToken}{Null, or the token from a previous call to get the next set of results.}
}
\description{
Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource identifiers, CloudFormation stacks, resource-groups, or an application registry app.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_list_app_version_resource_mappings/} for full documentation.
}
\keyword{internal}
