% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_parameter_history}
\alias{ssm_get_parameter_history}
\title{Retrieves the history of all changes to a parameter}
\usage{
ssm_get_parameter_history(
  Name,
  WithDecryption = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{Name}{[required] The name or Amazon Resource Name (ARN) of the parameter for which you
want to review history. For parameters shared with you from another
account, you must use the full ARN.}

\item{WithDecryption}{Return decrypted values for secure string parameters. This flag is
ignored for \code{String} and \code{StringList} parameter types.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}
}
\description{
Retrieves the history of all changes to a parameter.

See \url{https://www.paws-r-sdk.com/docs/ssm_get_parameter_history/} for full documentation.
}
\keyword{internal}
