# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudwatchevents_service.R
NULL

#' Activates a partner event source that has been deactivated
#'
#' @description
#' Activates a partner event source that has been deactivated. Once activated, your matching event bus will start receiving events from the event source.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_activate_event_source/](https://www.paws-r-sdk.com/docs/cloudwatchevents_activate_event_source/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the partner event source to activate.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_activate_event_source
cloudwatchevents_activate_event_source <- function(Name) {
  op <- new_operation(
    name = "ActivateEventSource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$activate_event_source_input(Name = Name)
  output <- .cloudwatchevents$activate_event_source_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$activate_event_source <- cloudwatchevents_activate_event_source

#' Cancels the specified replay
#'
#' @description
#' Cancels the specified replay.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_cancel_replay/](https://www.paws-r-sdk.com/docs/cloudwatchevents_cancel_replay/) for full documentation.
#'
#' @param ReplayName &#91;required&#93; The name of the replay to cancel.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_cancel_replay
cloudwatchevents_cancel_replay <- function(ReplayName) {
  op <- new_operation(
    name = "CancelReplay",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$cancel_replay_input(ReplayName = ReplayName)
  output <- .cloudwatchevents$cancel_replay_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$cancel_replay <- cloudwatchevents_cancel_replay

#' Creates an API destination, which is an HTTP invocation endpoint
#' configured as a target for events
#'
#' @description
#' Creates an API destination, which is an HTTP invocation endpoint configured as a target for events.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_create_api_destination/](https://www.paws-r-sdk.com/docs/cloudwatchevents_create_api_destination/) for full documentation.
#'
#' @param Name &#91;required&#93; The name for the API destination to create.
#' @param Description A description for the API destination to create.
#' @param ConnectionArn &#91;required&#93; The ARN of the connection to use for the API destination. The
#' destination endpoint must support the authorization type specified for
#' the connection.
#' @param InvocationEndpoint &#91;required&#93; The URL to the HTTP invocation endpoint for the API destination.
#' @param HttpMethod &#91;required&#93; The method to use for the request to the HTTP invocation endpoint.
#' @param InvocationRateLimitPerSecond The maximum number of requests per second to send to the HTTP invocation
#' endpoint.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_create_api_destination
cloudwatchevents_create_api_destination <- function(Name, Description = NULL, ConnectionArn, InvocationEndpoint, HttpMethod, InvocationRateLimitPerSecond = NULL) {
  op <- new_operation(
    name = "CreateApiDestination",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$create_api_destination_input(Name = Name, Description = Description, ConnectionArn = ConnectionArn, InvocationEndpoint = InvocationEndpoint, HttpMethod = HttpMethod, InvocationRateLimitPerSecond = InvocationRateLimitPerSecond)
  output <- .cloudwatchevents$create_api_destination_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$create_api_destination <- cloudwatchevents_create_api_destination

#' Creates an archive of events with the specified settings
#'
#' @description
#' Creates an archive of events with the specified settings. When you create an archive, incoming events might not immediately start being sent to the archive. Allow a short period of time for changes to take effect. If you do not specify a pattern to filter events sent to the archive, all events are sent to the archive except replayed events. Replayed events are not sent to an archive.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_create_archive/](https://www.paws-r-sdk.com/docs/cloudwatchevents_create_archive/) for full documentation.
#'
#' @param ArchiveName &#91;required&#93; The name for the archive to create.
#' @param EventSourceArn &#91;required&#93; The ARN of the event bus that sends events to the archive.
#' @param Description A description for the archive.
#' @param EventPattern An event pattern to use to filter events sent to the archive.
#' @param RetentionDays The number of days to retain events for. Default value is 0. If set to
#' 0, events are retained indefinitely
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_create_archive
cloudwatchevents_create_archive <- function(ArchiveName, EventSourceArn, Description = NULL, EventPattern = NULL, RetentionDays = NULL) {
  op <- new_operation(
    name = "CreateArchive",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$create_archive_input(ArchiveName = ArchiveName, EventSourceArn = EventSourceArn, Description = Description, EventPattern = EventPattern, RetentionDays = RetentionDays)
  output <- .cloudwatchevents$create_archive_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$create_archive <- cloudwatchevents_create_archive

#' Creates a connection
#'
#' @description
#' Creates a connection. A connection defines the authorization type and credentials to use for authorization with an API destination HTTP endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_create_connection/](https://www.paws-r-sdk.com/docs/cloudwatchevents_create_connection/) for full documentation.
#'
#' @param Name &#91;required&#93; The name for the connection to create.
#' @param Description A description for the connection to create.
#' @param AuthorizationType &#91;required&#93; The type of authorization to use for the connection.
#' @param AuthParameters &#91;required&#93; A `CreateConnectionAuthRequestParameters` object that contains the
#' authorization parameters to use to authorize with the endpoint.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_create_connection
cloudwatchevents_create_connection <- function(Name, Description = NULL, AuthorizationType, AuthParameters) {
  op <- new_operation(
    name = "CreateConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$create_connection_input(Name = Name, Description = Description, AuthorizationType = AuthorizationType, AuthParameters = AuthParameters)
  output <- .cloudwatchevents$create_connection_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$create_connection <- cloudwatchevents_create_connection

#' Creates a new event bus within your account
#'
#' @description
#' Creates a new event bus within your account. This can be a custom event bus which you can use to receive events from your custom applications and services, or it can be a partner event bus which can be matched to a partner event source.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_create_event_bus/](https://www.paws-r-sdk.com/docs/cloudwatchevents_create_event_bus/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the new event bus.
#' 
#' Event bus names cannot contain the / character. You can't use the name
#' `default` for a custom event bus, as this name is already used for your
#' account's default event bus.
#' 
#' If this is a partner event bus, the name must exactly match the name of
#' the partner event source that this event bus is matched to.
#' @param EventSourceName If you are creating a partner event bus, this specifies the partner
#' event source that the new event bus will be matched with.
#' @param Tags Tags to associate with the event bus.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_create_event_bus
cloudwatchevents_create_event_bus <- function(Name, EventSourceName = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEventBus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$create_event_bus_input(Name = Name, EventSourceName = EventSourceName, Tags = Tags)
  output <- .cloudwatchevents$create_event_bus_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$create_event_bus <- cloudwatchevents_create_event_bus

#' Called by an SaaS partner to create a partner event source
#'
#' @description
#' Called by an SaaS partner to create a partner event source. This operation is not used by Amazon Web Services customers.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_create_partner_event_source/](https://www.paws-r-sdk.com/docs/cloudwatchevents_create_partner_event_source/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the partner event source. This name must be unique and must
#' be in the format ` partner_name/event_namespace/event_name `. The Amazon
#' Web Services account that wants to use this partner event source must
#' create a partner event bus with a name that matches the name of the
#' partner event source.
#' @param Account &#91;required&#93; The Amazon Web Services account ID that is permitted to create a
#' matching partner event bus for this partner event source.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_create_partner_event_source
cloudwatchevents_create_partner_event_source <- function(Name, Account) {
  op <- new_operation(
    name = "CreatePartnerEventSource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$create_partner_event_source_input(Name = Name, Account = Account)
  output <- .cloudwatchevents$create_partner_event_source_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$create_partner_event_source <- cloudwatchevents_create_partner_event_source

#' You can use this operation to temporarily stop receiving events from the
#' specified partner event source
#'
#' @description
#' You can use this operation to temporarily stop receiving events from the specified partner event source. The matching event bus is not deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_deactivate_event_source/](https://www.paws-r-sdk.com/docs/cloudwatchevents_deactivate_event_source/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the partner event source to deactivate.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_deactivate_event_source
cloudwatchevents_deactivate_event_source <- function(Name) {
  op <- new_operation(
    name = "DeactivateEventSource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$deactivate_event_source_input(Name = Name)
  output <- .cloudwatchevents$deactivate_event_source_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$deactivate_event_source <- cloudwatchevents_deactivate_event_source

#' Removes all authorization parameters from the connection
#'
#' @description
#' Removes all authorization parameters from the connection. This lets you remove the secret from the connection so you can reuse it without having to create a new connection.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_deauthorize_connection/](https://www.paws-r-sdk.com/docs/cloudwatchevents_deauthorize_connection/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the connection to remove authorization from.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_deauthorize_connection
cloudwatchevents_deauthorize_connection <- function(Name) {
  op <- new_operation(
    name = "DeauthorizeConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$deauthorize_connection_input(Name = Name)
  output <- .cloudwatchevents$deauthorize_connection_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$deauthorize_connection <- cloudwatchevents_deauthorize_connection

#' Deletes the specified API destination
#'
#' @description
#' Deletes the specified API destination.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_delete_api_destination/](https://www.paws-r-sdk.com/docs/cloudwatchevents_delete_api_destination/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the destination to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_delete_api_destination
cloudwatchevents_delete_api_destination <- function(Name) {
  op <- new_operation(
    name = "DeleteApiDestination",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$delete_api_destination_input(Name = Name)
  output <- .cloudwatchevents$delete_api_destination_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$delete_api_destination <- cloudwatchevents_delete_api_destination

#' Deletes the specified archive
#'
#' @description
#' Deletes the specified archive.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_delete_archive/](https://www.paws-r-sdk.com/docs/cloudwatchevents_delete_archive/) for full documentation.
#'
#' @param ArchiveName &#91;required&#93; The name of the archive to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_delete_archive
cloudwatchevents_delete_archive <- function(ArchiveName) {
  op <- new_operation(
    name = "DeleteArchive",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$delete_archive_input(ArchiveName = ArchiveName)
  output <- .cloudwatchevents$delete_archive_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$delete_archive <- cloudwatchevents_delete_archive

#' Deletes a connection
#'
#' @description
#' Deletes a connection.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_delete_connection/](https://www.paws-r-sdk.com/docs/cloudwatchevents_delete_connection/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the connection to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_delete_connection
cloudwatchevents_delete_connection <- function(Name) {
  op <- new_operation(
    name = "DeleteConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$delete_connection_input(Name = Name)
  output <- .cloudwatchevents$delete_connection_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$delete_connection <- cloudwatchevents_delete_connection

#' Deletes the specified custom event bus or partner event bus
#'
#' @description
#' Deletes the specified custom event bus or partner event bus. All rules associated with this event bus need to be deleted. You can't delete your account's default event bus.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_delete_event_bus/](https://www.paws-r-sdk.com/docs/cloudwatchevents_delete_event_bus/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the event bus to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_delete_event_bus
cloudwatchevents_delete_event_bus <- function(Name) {
  op <- new_operation(
    name = "DeleteEventBus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$delete_event_bus_input(Name = Name)
  output <- .cloudwatchevents$delete_event_bus_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$delete_event_bus <- cloudwatchevents_delete_event_bus

#' This operation is used by SaaS partners to delete a partner event source
#'
#' @description
#' This operation is used by SaaS partners to delete a partner event source. This operation is not used by Amazon Web Services customers.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_delete_partner_event_source/](https://www.paws-r-sdk.com/docs/cloudwatchevents_delete_partner_event_source/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the event source to delete.
#' @param Account &#91;required&#93; The Amazon Web Services account ID of the Amazon Web Services customer
#' that the event source was created for.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_delete_partner_event_source
cloudwatchevents_delete_partner_event_source <- function(Name, Account) {
  op <- new_operation(
    name = "DeletePartnerEventSource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$delete_partner_event_source_input(Name = Name, Account = Account)
  output <- .cloudwatchevents$delete_partner_event_source_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$delete_partner_event_source <- cloudwatchevents_delete_partner_event_source

#' Deletes the specified rule
#'
#' @description
#' Deletes the specified rule.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_delete_rule/](https://www.paws-r-sdk.com/docs/cloudwatchevents_delete_rule/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#' @param Force If this is a managed rule, created by an Amazon Web Services service on
#' your behalf, you must specify `Force` as `True` to delete the rule. This
#' parameter is ignored for rules that are not managed rules. You can check
#' whether a rule is a managed rule by using
#' [`describe_rule`][cloudwatchevents_describe_rule] or
#' [`list_rules`][cloudwatchevents_list_rules] and checking the `ManagedBy`
#' field of the response.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_delete_rule
cloudwatchevents_delete_rule <- function(Name, EventBusName = NULL, Force = NULL) {
  op <- new_operation(
    name = "DeleteRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$delete_rule_input(Name = Name, EventBusName = EventBusName, Force = Force)
  output <- .cloudwatchevents$delete_rule_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$delete_rule <- cloudwatchevents_delete_rule

#' Retrieves details about an API destination
#'
#' @description
#' Retrieves details about an API destination.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_api_destination/](https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_api_destination/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the API destination to retrieve.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_api_destination
cloudwatchevents_describe_api_destination <- function(Name) {
  op <- new_operation(
    name = "DescribeApiDestination",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_api_destination_input(Name = Name)
  output <- .cloudwatchevents$describe_api_destination_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_api_destination <- cloudwatchevents_describe_api_destination

#' Retrieves details about an archive
#'
#' @description
#' Retrieves details about an archive.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_archive/](https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_archive/) for full documentation.
#'
#' @param ArchiveName &#91;required&#93; The name of the archive to retrieve.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_archive
cloudwatchevents_describe_archive <- function(ArchiveName) {
  op <- new_operation(
    name = "DescribeArchive",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_archive_input(ArchiveName = ArchiveName)
  output <- .cloudwatchevents$describe_archive_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_archive <- cloudwatchevents_describe_archive

#' Retrieves details about a connection
#'
#' @description
#' Retrieves details about a connection.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_connection/](https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_connection/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the connection to retrieve.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_connection
cloudwatchevents_describe_connection <- function(Name) {
  op <- new_operation(
    name = "DescribeConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_connection_input(Name = Name)
  output <- .cloudwatchevents$describe_connection_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_connection <- cloudwatchevents_describe_connection

#' Displays details about an event bus in your account
#'
#' @description
#' Displays details about an event bus in your account. This can include the external Amazon Web Services accounts that are permitted to write events to your default event bus, and the associated policy. For custom event buses and partner event buses, it displays the name, ARN, policy, state, and creation time.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_event_bus/](https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_event_bus/) for full documentation.
#'
#' @param Name The name or ARN of the event bus to show details for. If you omit this,
#' the default event bus is displayed.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_event_bus
cloudwatchevents_describe_event_bus <- function(Name = NULL) {
  op <- new_operation(
    name = "DescribeEventBus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_event_bus_input(Name = Name)
  output <- .cloudwatchevents$describe_event_bus_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_event_bus <- cloudwatchevents_describe_event_bus

#' This operation lists details about a partner event source that is shared
#' with your account
#'
#' @description
#' This operation lists details about a partner event source that is shared with your account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_event_source/](https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_event_source/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the partner event source to display the details of.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_event_source
cloudwatchevents_describe_event_source <- function(Name) {
  op <- new_operation(
    name = "DescribeEventSource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_event_source_input(Name = Name)
  output <- .cloudwatchevents$describe_event_source_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_event_source <- cloudwatchevents_describe_event_source

#' An SaaS partner can use this operation to list details about a partner
#' event source that they have created
#'
#' @description
#' An SaaS partner can use this operation to list details about a partner event source that they have created. Amazon Web Services customers do not use this operation. Instead, Amazon Web Services customers can use [`describe_event_source`][cloudwatchevents_describe_event_source] to see details about a partner event source that is shared with them.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_partner_event_source/](https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_partner_event_source/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the event source to display.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_partner_event_source
cloudwatchevents_describe_partner_event_source <- function(Name) {
  op <- new_operation(
    name = "DescribePartnerEventSource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_partner_event_source_input(Name = Name)
  output <- .cloudwatchevents$describe_partner_event_source_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_partner_event_source <- cloudwatchevents_describe_partner_event_source

#' Retrieves details about a replay
#'
#' @description
#' Retrieves details about a replay. Use [`describe_replay`][cloudwatchevents_describe_replay] to determine the progress of a running replay. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you use [`start_replay`][cloudwatchevents_start_replay] and specify an `EventStartTime` and an `EventEndTime` that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use [`describe_replay`][cloudwatchevents_describe_replay] to determine the progress of a replay. The value returned for `EventLastReplayedTime` indicates the time within the specified time range associated with the last event replayed.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_replay/](https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_replay/) for full documentation.
#'
#' @param ReplayName &#91;required&#93; The name of the replay to retrieve.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_replay
cloudwatchevents_describe_replay <- function(ReplayName) {
  op <- new_operation(
    name = "DescribeReplay",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_replay_input(ReplayName = ReplayName)
  output <- .cloudwatchevents$describe_replay_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_replay <- cloudwatchevents_describe_replay

#' Describes the specified rule
#'
#' @description
#' Describes the specified rule.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_rule/](https://www.paws-r-sdk.com/docs/cloudwatchevents_describe_rule/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_describe_rule
cloudwatchevents_describe_rule <- function(Name, EventBusName = NULL) {
  op <- new_operation(
    name = "DescribeRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$describe_rule_input(Name = Name, EventBusName = EventBusName)
  output <- .cloudwatchevents$describe_rule_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$describe_rule <- cloudwatchevents_describe_rule

#' Disables the specified rule
#'
#' @description
#' Disables the specified rule. A disabled rule won't match any events, and won't self-trigger if it has a schedule expression.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_disable_rule/](https://www.paws-r-sdk.com/docs/cloudwatchevents_disable_rule/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_disable_rule
cloudwatchevents_disable_rule <- function(Name, EventBusName = NULL) {
  op <- new_operation(
    name = "DisableRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$disable_rule_input(Name = Name, EventBusName = EventBusName)
  output <- .cloudwatchevents$disable_rule_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$disable_rule <- cloudwatchevents_disable_rule

#' Enables the specified rule
#'
#' @description
#' Enables the specified rule. If the rule does not exist, the operation fails.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_enable_rule/](https://www.paws-r-sdk.com/docs/cloudwatchevents_enable_rule/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_enable_rule
cloudwatchevents_enable_rule <- function(Name, EventBusName = NULL) {
  op <- new_operation(
    name = "EnableRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$enable_rule_input(Name = Name, EventBusName = EventBusName)
  output <- .cloudwatchevents$enable_rule_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$enable_rule <- cloudwatchevents_enable_rule

#' Retrieves a list of API destination in the account in the current Region
#'
#' @description
#' Retrieves a list of API destination in the account in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_list_api_destinations/](https://www.paws-r-sdk.com/docs/cloudwatchevents_list_api_destinations/) for full documentation.
#'
#' @param NamePrefix A name prefix to filter results returned. Only API destinations with a
#' name that starts with the prefix are returned.
#' @param ConnectionArn The ARN of the connection specified for the API destination.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of API destinations to include in the response.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_api_destinations
cloudwatchevents_list_api_destinations <- function(NamePrefix = NULL, ConnectionArn = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListApiDestinations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$list_api_destinations_input(NamePrefix = NamePrefix, ConnectionArn = ConnectionArn, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_api_destinations_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_api_destinations <- cloudwatchevents_list_api_destinations

#' Lists your archives
#'
#' @description
#' Lists your archives. You can either list all the archives or you can provide a prefix to match to the archive names. Filter parameters are exclusive.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_list_archives/](https://www.paws-r-sdk.com/docs/cloudwatchevents_list_archives/) for full documentation.
#'
#' @param NamePrefix A name prefix to filter the archives returned. Only archives with name
#' that match the prefix are returned.
#' @param EventSourceArn The ARN of the event source associated with the archive.
#' @param State The state of the archive.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_archives
cloudwatchevents_list_archives <- function(NamePrefix = NULL, EventSourceArn = NULL, State = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListArchives",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$list_archives_input(NamePrefix = NamePrefix, EventSourceArn = EventSourceArn, State = State, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_archives_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_archives <- cloudwatchevents_list_archives

#' Retrieves a list of connections from the account
#'
#' @description
#' Retrieves a list of connections from the account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_list_connections/](https://www.paws-r-sdk.com/docs/cloudwatchevents_list_connections/) for full documentation.
#'
#' @param NamePrefix A name prefix to filter results returned. Only connections with a name
#' that starts with the prefix are returned.
#' @param ConnectionState The state of the connection.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of connections to return.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_connections
cloudwatchevents_list_connections <- function(NamePrefix = NULL, ConnectionState = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListConnections",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$list_connections_input(NamePrefix = NamePrefix, ConnectionState = ConnectionState, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_connections_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_connections <- cloudwatchevents_list_connections

#' Lists all the event buses in your account, including the default event
#' bus, custom event buses, and partner event buses
#'
#' @description
#' Lists all the event buses in your account, including the default event bus, custom event buses, and partner event buses.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_list_event_buses/](https://www.paws-r-sdk.com/docs/cloudwatchevents_list_event_buses/) for full documentation.
#'
#' @param NamePrefix Specifying this limits the results to only those event buses with names
#' that start with the specified prefix.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit Specifying this limits the number of results returned by this operation.
#' The operation also returns a NextToken which you can use in a subsequent
#' operation to retrieve the next set of results.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_event_buses
cloudwatchevents_list_event_buses <- function(NamePrefix = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListEventBuses",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$list_event_buses_input(NamePrefix = NamePrefix, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_event_buses_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_event_buses <- cloudwatchevents_list_event_buses

#' You can use this to see all the partner event sources that have been
#' shared with your Amazon Web Services account
#'
#' @description
#' You can use this to see all the partner event sources that have been shared with your Amazon Web Services account. For more information about partner event sources, see [`create_event_bus`][cloudwatchevents_create_event_bus].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_list_event_sources/](https://www.paws-r-sdk.com/docs/cloudwatchevents_list_event_sources/) for full documentation.
#'
#' @param NamePrefix Specifying this limits the results to only those partner event sources
#' with names that start with the specified prefix.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit Specifying this limits the number of results returned by this operation.
#' The operation also returns a NextToken which you can use in a subsequent
#' operation to retrieve the next set of results.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_event_sources
cloudwatchevents_list_event_sources <- function(NamePrefix = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListEventSources",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$list_event_sources_input(NamePrefix = NamePrefix, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_event_sources_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_event_sources <- cloudwatchevents_list_event_sources

#' An SaaS partner can use this operation to display the Amazon Web
#' Services account ID that a particular partner event source name is
#' associated with
#'
#' @description
#' An SaaS partner can use this operation to display the Amazon Web Services account ID that a particular partner event source name is associated with. This operation is not used by Amazon Web Services customers.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_list_partner_event_source_accounts/](https://www.paws-r-sdk.com/docs/cloudwatchevents_list_partner_event_source_accounts/) for full documentation.
#'
#' @param EventSourceName &#91;required&#93; The name of the partner event source to display account information
#' about.
#' @param NextToken The token returned by a previous call to this operation. Specifying this
#' retrieves the next set of results.
#' @param Limit Specifying this limits the number of results returned by this operation.
#' The operation also returns a NextToken which you can use in a subsequent
#' operation to retrieve the next set of results.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_partner_event_source_accounts
cloudwatchevents_list_partner_event_source_accounts <- function(EventSourceName, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListPartnerEventSourceAccounts",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$list_partner_event_source_accounts_input(EventSourceName = EventSourceName, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_partner_event_source_accounts_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_partner_event_source_accounts <- cloudwatchevents_list_partner_event_source_accounts

#' An SaaS partner can use this operation to list all the partner event
#' source names that they have created
#'
#' @description
#' An SaaS partner can use this operation to list all the partner event source names that they have created. This operation is not used by Amazon Web Services customers.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_list_partner_event_sources/](https://www.paws-r-sdk.com/docs/cloudwatchevents_list_partner_event_sources/) for full documentation.
#'
#' @param NamePrefix &#91;required&#93; If you specify this, the results are limited to only those partner event
#' sources that start with the string you specify.
#' @param NextToken The token returned by a previous call to this operation. Specifying this
#' retrieves the next set of results.
#' @param Limit pecifying this limits the number of results returned by this operation.
#' The operation also returns a NextToken which you can use in a subsequent
#' operation to retrieve the next set of results.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_partner_event_sources
cloudwatchevents_list_partner_event_sources <- function(NamePrefix, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListPartnerEventSources",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$list_partner_event_sources_input(NamePrefix = NamePrefix, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_partner_event_sources_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_partner_event_sources <- cloudwatchevents_list_partner_event_sources

#' Lists your replays
#'
#' @description
#' Lists your replays. You can either list all the replays or you can provide a prefix to match to the replay names. Filter parameters are exclusive.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_list_replays/](https://www.paws-r-sdk.com/docs/cloudwatchevents_list_replays/) for full documentation.
#'
#' @param NamePrefix A name prefix to filter the replays returned. Only replays with name
#' that match the prefix are returned.
#' @param State The state of the replay.
#' @param EventSourceArn The ARN of the archive from which the events are replayed.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of replays to retrieve.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_replays
cloudwatchevents_list_replays <- function(NamePrefix = NULL, State = NULL, EventSourceArn = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListReplays",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$list_replays_input(NamePrefix = NamePrefix, State = State, EventSourceArn = EventSourceArn, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_replays_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_replays <- cloudwatchevents_list_replays

#' Lists the rules for the specified target
#'
#' @description
#' Lists the rules for the specified target. You can see which of the rules in Amazon EventBridge can invoke a specific target in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_list_rule_names_by_target/](https://www.paws-r-sdk.com/docs/cloudwatchevents_list_rule_names_by_target/) for full documentation.
#'
#' @param TargetArn &#91;required&#93; The Amazon Resource Name (ARN) of the target resource.
#' @param EventBusName The name or ARN of the event bus to list rules for. If you omit this,
#' the default event bus is used.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_rule_names_by_target
cloudwatchevents_list_rule_names_by_target <- function(TargetArn, EventBusName = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRuleNamesByTarget",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$list_rule_names_by_target_input(TargetArn = TargetArn, EventBusName = EventBusName, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_rule_names_by_target_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_rule_names_by_target <- cloudwatchevents_list_rule_names_by_target

#' Lists your Amazon EventBridge rules
#'
#' @description
#' Lists your Amazon EventBridge rules. You can either list all the rules or you can provide a prefix to match to the rule names.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_list_rules/](https://www.paws-r-sdk.com/docs/cloudwatchevents_list_rules/) for full documentation.
#'
#' @param NamePrefix The prefix matching the rule name.
#' @param EventBusName The name or ARN of the event bus to list the rules for. If you omit
#' this, the default event bus is used.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_rules
cloudwatchevents_list_rules <- function(NamePrefix = NULL, EventBusName = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRules",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$list_rules_input(NamePrefix = NamePrefix, EventBusName = EventBusName, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_rules_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_rules <- cloudwatchevents_list_rules

#' Displays the tags associated with an EventBridge resource
#'
#' @description
#' Displays the tags associated with an EventBridge resource. In EventBridge, rules and event buses can be tagged.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/cloudwatchevents_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the EventBridge resource for which you want to view tags.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_tags_for_resource
cloudwatchevents_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .cloudwatchevents$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_tags_for_resource <- cloudwatchevents_list_tags_for_resource

#' Lists the targets assigned to the specified rule
#'
#' @description
#' Lists the targets assigned to the specified rule.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_list_targets_by_rule/](https://www.paws-r-sdk.com/docs/cloudwatchevents_list_targets_by_rule/) for full documentation.
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_list_targets_by_rule
cloudwatchevents_list_targets_by_rule <- function(Rule, EventBusName = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTargetsByRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$list_targets_by_rule_input(Rule = Rule, EventBusName = EventBusName, NextToken = NextToken, Limit = Limit)
  output <- .cloudwatchevents$list_targets_by_rule_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$list_targets_by_rule <- cloudwatchevents_list_targets_by_rule

#' Sends custom events to Amazon EventBridge so that they can be matched to
#' rules
#'
#' @description
#' Sends custom events to Amazon EventBridge so that they can be matched to rules.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_put_events/](https://www.paws-r-sdk.com/docs/cloudwatchevents_put_events/) for full documentation.
#'
#' @param Entries &#91;required&#93; The entry that defines an event in your system. You can specify several
#' parameters for the entry such as the source and type of the event,
#' resources associated with the event, and so on.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_events
cloudwatchevents_put_events <- function(Entries) {
  op <- new_operation(
    name = "PutEvents",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$put_events_input(Entries = Entries)
  output <- .cloudwatchevents$put_events_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_events <- cloudwatchevents_put_events

#' This is used by SaaS partners to write events to a customer's partner
#' event bus
#'
#' @description
#' This is used by SaaS partners to write events to a customer's partner event bus. Amazon Web Services customers do not use this operation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_put_partner_events/](https://www.paws-r-sdk.com/docs/cloudwatchevents_put_partner_events/) for full documentation.
#'
#' @param Entries &#91;required&#93; The list of events to write to the event bus.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_partner_events
cloudwatchevents_put_partner_events <- function(Entries) {
  op <- new_operation(
    name = "PutPartnerEvents",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$put_partner_events_input(Entries = Entries)
  output <- .cloudwatchevents$put_partner_events_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_partner_events <- cloudwatchevents_put_partner_events

#' Running PutPermission permits the specified Amazon Web Services account
#' or Amazon Web Services organization to put events to the specified event
#' bus
#'
#' @description
#' Running [`put_permission`][cloudwatchevents_put_permission] permits the specified Amazon Web Services account or Amazon Web Services organization to put events to the specified *event bus*. Amazon EventBridge (CloudWatch Events) rules in your account are triggered by these events arriving to an event bus in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_put_permission/](https://www.paws-r-sdk.com/docs/cloudwatchevents_put_permission/) for full documentation.
#'
#' @param EventBusName The name of the event bus associated with the rule. If you omit this,
#' the default event bus is used.
#' @param Action The action that you are enabling the other account to perform.
#' @param Principal The 12-digit Amazon Web Services account ID that you are permitting to
#' put events to your default event bus. Specify "*" to permit any account
#' to put events to your default event bus.
#' 
#' If you specify "*" without specifying `Condition`, avoid creating rules
#' that may match undesirable events. To create more secure rules, make
#' sure that the event pattern for each rule contains an `account` field
#' with a specific account ID from which to receive events. Rules with an
#' account field do not match any events sent from other accounts.
#' @param StatementId An identifier string for the external account that you are granting
#' permissions to. If you later want to revoke the permission for this
#' external account, specify this `StatementId` when you run
#' [`remove_permission`][cloudwatchevents_remove_permission].
#' @param Condition This parameter enables you to limit the permission to accounts that
#' fulfill a certain condition, such as being a member of a certain Amazon
#' Web Services organization. For more information about Amazon Web
#' Services Organizations, see [What Is Amazon Web Services
#' Organizations](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html)
#' in the *Amazon Web Services Organizations User Guide*.
#' 
#' If you specify `Condition` with an Amazon Web Services organization ID,
#' and specify "*" as the value for `Principal`, you grant permission to
#' all the accounts in the named organization.
#' 
#' The `Condition` is a JSON string which must contain `Type`, `Key`, and
#' `Value` fields.
#' @param Policy A JSON string that describes the permission policy statement. You can
#' include a `Policy` parameter in the request instead of using the
#' `StatementId`, `Action`, `Principal`, or `Condition` parameters.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_permission
cloudwatchevents_put_permission <- function(EventBusName = NULL, Action = NULL, Principal = NULL, StatementId = NULL, Condition = NULL, Policy = NULL) {
  op <- new_operation(
    name = "PutPermission",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$put_permission_input(EventBusName = EventBusName, Action = Action, Principal = Principal, StatementId = StatementId, Condition = Condition, Policy = Policy)
  output <- .cloudwatchevents$put_permission_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_permission <- cloudwatchevents_put_permission

#' Creates or updates the specified rule
#'
#' @description
#' Creates or updates the specified rule. Rules are enabled by default, or based on value of the state. You can disable a rule using [`disable_rule`][cloudwatchevents_disable_rule].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_put_rule/](https://www.paws-r-sdk.com/docs/cloudwatchevents_put_rule/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the rule that you are creating or updating.
#' @param ScheduleExpression The scheduling expression. For example, "cron(0 20 * * ? *)" or
#' "rate(5 minutes)".
#' @param EventPattern The event pattern. For more information, see [Events and Event
#' Patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html)
#' in the *Amazon EventBridge User Guide*.
#' @param State Indicates whether the rule is enabled or disabled.
#' @param Description A description of the rule.
#' @param RoleArn The Amazon Resource Name (ARN) of the IAM role associated with the rule.
#' 
#' If you're setting an event bus in another account as the target and that
#' account granted permission to your account through an organization
#' instead of directly by the account ID, you must specify a `RoleArn` with
#' proper permissions in the `Target` structure, instead of here in this
#' parameter.
#' @param Tags The list of key-value pairs to associate with the rule.
#' @param EventBusName The name or ARN of the event bus to associate with this rule. If you
#' omit this, the default event bus is used.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_rule
cloudwatchevents_put_rule <- function(Name, ScheduleExpression = NULL, EventPattern = NULL, State = NULL, Description = NULL, RoleArn = NULL, Tags = NULL, EventBusName = NULL) {
  op <- new_operation(
    name = "PutRule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$put_rule_input(Name = Name, ScheduleExpression = ScheduleExpression, EventPattern = EventPattern, State = State, Description = Description, RoleArn = RoleArn, Tags = Tags, EventBusName = EventBusName)
  output <- .cloudwatchevents$put_rule_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_rule <- cloudwatchevents_put_rule

#' Adds the specified targets to the specified rule, or updates the targets
#' if they are already associated with the rule
#'
#' @description
#' Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_put_targets/](https://www.paws-r-sdk.com/docs/cloudwatchevents_put_targets/) for full documentation.
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#' @param Targets &#91;required&#93; The targets to update or add to the rule.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_put_targets
cloudwatchevents_put_targets <- function(Rule, EventBusName = NULL, Targets) {
  op <- new_operation(
    name = "PutTargets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$put_targets_input(Rule = Rule, EventBusName = EventBusName, Targets = Targets)
  output <- .cloudwatchevents$put_targets_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$put_targets <- cloudwatchevents_put_targets

#' Revokes the permission of another Amazon Web Services account to be able
#' to put events to the specified event bus
#'
#' @description
#' Revokes the permission of another Amazon Web Services account to be able to put events to the specified event bus. Specify the account to revoke by the `StatementId` value that you associated with the account when you granted it permission with [`put_permission`][cloudwatchevents_put_permission]. You can find the `StatementId` by using [`describe_event_bus`][cloudwatchevents_describe_event_bus].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_remove_permission/](https://www.paws-r-sdk.com/docs/cloudwatchevents_remove_permission/) for full documentation.
#'
#' @param StatementId The statement ID corresponding to the account that is no longer allowed
#' to put events to the default event bus.
#' @param RemoveAllPermissions Specifies whether to remove all permissions.
#' @param EventBusName The name of the event bus to revoke permissions for. If you omit this,
#' the default event bus is used.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_remove_permission
cloudwatchevents_remove_permission <- function(StatementId = NULL, RemoveAllPermissions = NULL, EventBusName = NULL) {
  op <- new_operation(
    name = "RemovePermission",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$remove_permission_input(StatementId = StatementId, RemoveAllPermissions = RemoveAllPermissions, EventBusName = EventBusName)
  output <- .cloudwatchevents$remove_permission_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$remove_permission <- cloudwatchevents_remove_permission

#' Removes the specified targets from the specified rule
#'
#' @description
#' Removes the specified targets from the specified rule. When the rule is triggered, those targets are no longer be invoked.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_remove_targets/](https://www.paws-r-sdk.com/docs/cloudwatchevents_remove_targets/) for full documentation.
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#' @param Ids &#91;required&#93; The IDs of the targets to remove from the rule.
#' @param Force If this is a managed rule, created by an Amazon Web Services service on
#' your behalf, you must specify `Force` as `True` to remove targets. This
#' parameter is ignored for rules that are not managed rules. You can check
#' whether a rule is a managed rule by using
#' [`describe_rule`][cloudwatchevents_describe_rule] or
#' [`list_rules`][cloudwatchevents_list_rules] and checking the `ManagedBy`
#' field of the response.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_remove_targets
cloudwatchevents_remove_targets <- function(Rule, EventBusName = NULL, Ids, Force = NULL) {
  op <- new_operation(
    name = "RemoveTargets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$remove_targets_input(Rule = Rule, EventBusName = EventBusName, Ids = Ids, Force = Force)
  output <- .cloudwatchevents$remove_targets_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$remove_targets <- cloudwatchevents_remove_targets

#' Starts the specified replay
#'
#' @description
#' Starts the specified replay. Events are not necessarily replayed in the exact same order that they were added to the archive. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you specify an `EventStartTime` and an `EventEndTime` that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use [`describe_replay`][cloudwatchevents_describe_replay] to determine the progress of a replay. The value returned for `EventLastReplayedTime` indicates the time within the specified time range associated with the last event replayed.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_start_replay/](https://www.paws-r-sdk.com/docs/cloudwatchevents_start_replay/) for full documentation.
#'
#' @param ReplayName &#91;required&#93; The name of the replay to start.
#' @param Description A description for the replay to start.
#' @param EventSourceArn &#91;required&#93; The ARN of the archive to replay events from.
#' @param EventStartTime &#91;required&#93; A time stamp for the time to start replaying events. Only events that
#' occurred between the `EventStartTime` and `EventEndTime` are replayed.
#' @param EventEndTime &#91;required&#93; A time stamp for the time to stop replaying events. Only events that
#' occurred between the `EventStartTime` and `EventEndTime` are replayed.
#' @param Destination &#91;required&#93; A `ReplayDestination` object that includes details about the destination
#' for the replay.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_start_replay
cloudwatchevents_start_replay <- function(ReplayName, Description = NULL, EventSourceArn, EventStartTime, EventEndTime, Destination) {
  op <- new_operation(
    name = "StartReplay",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$start_replay_input(ReplayName = ReplayName, Description = Description, EventSourceArn = EventSourceArn, EventStartTime = EventStartTime, EventEndTime = EventEndTime, Destination = Destination)
  output <- .cloudwatchevents$start_replay_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$start_replay <- cloudwatchevents_start_replay

#' Assigns one or more tags (key-value pairs) to the specified EventBridge
#' resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In EventBridge, rules and event buses can be tagged.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_tag_resource/](https://www.paws-r-sdk.com/docs/cloudwatchevents_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the EventBridge resource that you're adding tags to.
#' @param Tags &#91;required&#93; The list of key-value pairs to associate with the resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_tag_resource
cloudwatchevents_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .cloudwatchevents$tag_resource_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$tag_resource <- cloudwatchevents_tag_resource

#' Tests whether the specified event pattern matches the provided event
#'
#' @description
#' Tests whether the specified event pattern matches the provided event.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_test_event_pattern/](https://www.paws-r-sdk.com/docs/cloudwatchevents_test_event_pattern/) for full documentation.
#'
#' @param EventPattern &#91;required&#93; The event pattern. For more information, see [Events and Event
#' Patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html)
#' in the *Amazon EventBridge User Guide*.
#' @param Event &#91;required&#93; The event, in JSON format, to test against the event pattern. The JSON
#' must follow the format specified in [Amazon Web Services
#' Events](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html),
#' and the following fields are mandatory:
#' 
#' -   `id`
#' 
#' -   `account`
#' 
#' -   `source`
#' 
#' -   `time`
#' 
#' -   `region`
#' 
#' -   `resources`
#' 
#' -   `detail-type`
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_test_event_pattern
cloudwatchevents_test_event_pattern <- function(EventPattern, Event) {
  op <- new_operation(
    name = "TestEventPattern",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$test_event_pattern_input(EventPattern = EventPattern, Event = Event)
  output <- .cloudwatchevents$test_event_pattern_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$test_event_pattern <- cloudwatchevents_test_event_pattern

#' Removes one or more tags from the specified EventBridge resource
#'
#' @description
#' Removes one or more tags from the specified EventBridge resource. In Amazon EventBridge (CloudWatch Events), rules and event buses can be tagged.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_untag_resource/](https://www.paws-r-sdk.com/docs/cloudwatchevents_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the EventBridge resource from which you are removing tags.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_untag_resource
cloudwatchevents_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .cloudwatchevents$untag_resource_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$untag_resource <- cloudwatchevents_untag_resource

#' Updates an API destination
#'
#' @description
#' Updates an API destination.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_update_api_destination/](https://www.paws-r-sdk.com/docs/cloudwatchevents_update_api_destination/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the API destination to update.
#' @param Description The name of the API destination to update.
#' @param ConnectionArn The ARN of the connection to use for the API destination.
#' @param InvocationEndpoint The URL to the endpoint to use for the API destination.
#' @param HttpMethod The method to use for the API destination.
#' @param InvocationRateLimitPerSecond The maximum number of invocations per second to send to the API
#' destination.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_update_api_destination
cloudwatchevents_update_api_destination <- function(Name, Description = NULL, ConnectionArn = NULL, InvocationEndpoint = NULL, HttpMethod = NULL, InvocationRateLimitPerSecond = NULL) {
  op <- new_operation(
    name = "UpdateApiDestination",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$update_api_destination_input(Name = Name, Description = Description, ConnectionArn = ConnectionArn, InvocationEndpoint = InvocationEndpoint, HttpMethod = HttpMethod, InvocationRateLimitPerSecond = InvocationRateLimitPerSecond)
  output <- .cloudwatchevents$update_api_destination_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$update_api_destination <- cloudwatchevents_update_api_destination

#' Updates the specified archive
#'
#' @description
#' Updates the specified archive.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_update_archive/](https://www.paws-r-sdk.com/docs/cloudwatchevents_update_archive/) for full documentation.
#'
#' @param ArchiveName &#91;required&#93; The name of the archive to update.
#' @param Description The description for the archive.
#' @param EventPattern The event pattern to use to filter events sent to the archive.
#' @param RetentionDays The number of days to retain events in the archive.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_update_archive
cloudwatchevents_update_archive <- function(ArchiveName, Description = NULL, EventPattern = NULL, RetentionDays = NULL) {
  op <- new_operation(
    name = "UpdateArchive",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$update_archive_input(ArchiveName = ArchiveName, Description = Description, EventPattern = EventPattern, RetentionDays = RetentionDays)
  output <- .cloudwatchevents$update_archive_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$update_archive <- cloudwatchevents_update_archive

#' Updates settings for a connection
#'
#' @description
#' Updates settings for a connection.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchevents_update_connection/](https://www.paws-r-sdk.com/docs/cloudwatchevents_update_connection/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the connection to update.
#' @param Description A description for the connection.
#' @param AuthorizationType The type of authorization to use for the connection.
#' @param AuthParameters The authorization parameters to use for the connection.
#'
#' @keywords internal
#'
#' @rdname cloudwatchevents_update_connection
cloudwatchevents_update_connection <- function(Name, Description = NULL, AuthorizationType = NULL, AuthParameters = NULL) {
  op <- new_operation(
    name = "UpdateConnection",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .cloudwatchevents$update_connection_input(Name = Name, Description = Description, AuthorizationType = AuthorizationType, AuthParameters = AuthParameters)
  output <- .cloudwatchevents$update_connection_output()
  config <- get_config()
  svc <- .cloudwatchevents$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchevents$operations$update_connection <- cloudwatchevents_update_connection
