% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_start_automation_execution}
\alias{ssm_start_automation_execution}
\title{Initiates execution of an Automation runbook}
\usage{
ssm_start_automation_execution(
  DocumentName,
  DocumentVersion = NULL,
  Parameters = NULL,
  ClientToken = NULL,
  Mode = NULL,
  TargetParameterName = NULL,
  Targets = NULL,
  TargetMaps = NULL,
  MaxConcurrency = NULL,
  MaxErrors = NULL,
  TargetLocations = NULL,
  Tags = NULL,
  AlarmConfiguration = NULL
)
}
\arguments{
\item{DocumentName}{[required] The name of the SSM document to run. This can be a public document or a
custom document. To run a shared document belonging to another account,
specify the document ARN. For more information about how to use shared
documents, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-ssm-sharing.html}{Sharing SSM documents}
in the \emph{Amazon Web Services Systems Manager User Guide}.}

\item{DocumentVersion}{The version of the Automation runbook to use for this execution.}

\item{Parameters}{A key-value map of execution parameters, which match the declared
parameters in the Automation runbook.}

\item{ClientToken}{User-provided idempotency token. The token must be unique, is case
insensitive, enforces the UUID format, and can't be reused.}

\item{Mode}{The execution mode of the automation. Valid modes include the following:
Auto and Interactive. The default mode is Auto.}

\item{TargetParameterName}{The name of the parameter used as the target resource for the
rate-controlled execution. Required if you specify targets.}

\item{Targets}{A key-value mapping to target resources. Required if you specify
TargetParameterName.}

\item{TargetMaps}{A key-value mapping of document parameters to target resources. Both
Targets and TargetMaps can't be specified together.}

\item{MaxConcurrency}{The maximum number of targets allowed to run this task in parallel. You
can specify a number, such as 10, or a percentage, such as 10\%. The
default value is \code{10}.}

\item{MaxErrors}{The number of errors that are allowed before the system stops running
the automation on additional targets. You can specify either an absolute
number of errors, for example 10, or a percentage of the target set, for
example 10\%. If you specify 3, for example, the system stops running the
automation when the fourth error is received. If you specify 0, then the
system stops running the automation on additional targets after the
first error result is returned. If you run an automation on 50 resources
and set max-errors to 10\%, then the system stops running the automation
on additional targets when the sixth error is received.

Executions that are already running an automation when max-errors is
reached are allowed to complete, but some of these executions may fail
as well. If you need to ensure that there won't be more than max-errors
failed executions, set max-concurrency to 1 so the executions proceed
one at a time.}

\item{TargetLocations}{A location is a combination of Amazon Web Services Regions and/or Amazon
Web Services accounts where you want to run the automation. Use this
operation to start an automation in multiple Amazon Web Services Regions
and multiple Amazon Web Services accounts. For more information, see
\href{https://docs.aws.amazon.com/systems-manager/latest/userguide/running-automations-multiple-accounts-regions.html}{Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services accounts}
in the \emph{Amazon Web Services Systems Manager User Guide}.}

\item{Tags}{Optional metadata that you assign to a resource. You can specify a
maximum of five tags for an automation. Tags enable you to categorize a
resource in different ways, such as by purpose, owner, or environment.
For example, you might want to tag an automation to identify an
environment or operating system. In this case, you could specify the
following key-value pairs:
\itemize{
\item \verb{Key=environment,Value=test}
\item \verb{Key=OS,Value=Windows}
}

To add tags to an existing automation, use the
\code{\link[=ssm_add_tags_to_resource]{add_tags_to_resource}} operation.}

\item{AlarmConfiguration}{The CloudWatch alarm you want to apply to your automation.}
}
\description{
Initiates execution of an Automation runbook.

See \url{https://www.paws-r-sdk.com/docs/ssm_start_automation_execution/} for full documentation.
}
\keyword{internal}
