# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include auditmanager_service.R
NULL

#' Associates an evidence folder to an assessment report in an Audit
#' Manager assessment
#'
#' @description
#' Associates an evidence folder to an assessment report in an Audit Manager assessment.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_associate_assessment_report_evidence_folder/](https://www.paws-r-sdk.com/docs/auditmanager_associate_assessment_report_evidence_folder/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The identifier for the assessment.
#' @param evidenceFolderId &#91;required&#93; The identifier for the folder that the evidence is stored in.
#'
#' @keywords internal
#'
#' @rdname auditmanager_associate_assessment_report_evidence_folder
auditmanager_associate_assessment_report_evidence_folder <- function(assessmentId, evidenceFolderId) {
  op <- new_operation(
    name = "AssociateAssessmentReportEvidenceFolder",
    http_method = "PUT",
    http_path = "/assessments/{assessmentId}/associateToAssessmentReport",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$associate_assessment_report_evidence_folder_input(assessmentId = assessmentId, evidenceFolderId = evidenceFolderId)
  output <- .auditmanager$associate_assessment_report_evidence_folder_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$associate_assessment_report_evidence_folder <- auditmanager_associate_assessment_report_evidence_folder

#' Associates a list of evidence to an assessment report in an Audit
#' Manager assessment
#'
#' @description
#' Associates a list of evidence to an assessment report in an Audit Manager assessment.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_batch_associate_assessment_report_evidence/](https://www.paws-r-sdk.com/docs/auditmanager_batch_associate_assessment_report_evidence/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The identifier for the assessment.
#' @param evidenceFolderId &#91;required&#93; The identifier for the folder that the evidence is stored in.
#' @param evidenceIds &#91;required&#93; The list of evidence identifiers.
#'
#' @keywords internal
#'
#' @rdname auditmanager_batch_associate_assessment_report_evidence
auditmanager_batch_associate_assessment_report_evidence <- function(assessmentId, evidenceFolderId, evidenceIds) {
  op <- new_operation(
    name = "BatchAssociateAssessmentReportEvidence",
    http_method = "PUT",
    http_path = "/assessments/{assessmentId}/batchAssociateToAssessmentReport",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$batch_associate_assessment_report_evidence_input(assessmentId = assessmentId, evidenceFolderId = evidenceFolderId, evidenceIds = evidenceIds)
  output <- .auditmanager$batch_associate_assessment_report_evidence_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$batch_associate_assessment_report_evidence <- auditmanager_batch_associate_assessment_report_evidence

#' Creates a batch of delegations for an assessment in Audit Manager
#'
#' @description
#' Creates a batch of delegations for an assessment in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_batch_create_delegation_by_assessment/](https://www.paws-r-sdk.com/docs/auditmanager_batch_create_delegation_by_assessment/) for full documentation.
#'
#' @param createDelegationRequests &#91;required&#93; The API request to batch create delegations in Audit Manager.
#' @param assessmentId &#91;required&#93; The identifier for the assessment.
#'
#' @keywords internal
#'
#' @rdname auditmanager_batch_create_delegation_by_assessment
auditmanager_batch_create_delegation_by_assessment <- function(createDelegationRequests, assessmentId) {
  op <- new_operation(
    name = "BatchCreateDelegationByAssessment",
    http_method = "POST",
    http_path = "/assessments/{assessmentId}/delegations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$batch_create_delegation_by_assessment_input(createDelegationRequests = createDelegationRequests, assessmentId = assessmentId)
  output <- .auditmanager$batch_create_delegation_by_assessment_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$batch_create_delegation_by_assessment <- auditmanager_batch_create_delegation_by_assessment

#' Deletes a batch of delegations for an assessment in Audit Manager
#'
#' @description
#' Deletes a batch of delegations for an assessment in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_batch_delete_delegation_by_assessment/](https://www.paws-r-sdk.com/docs/auditmanager_batch_delete_delegation_by_assessment/) for full documentation.
#'
#' @param delegationIds &#91;required&#93; The identifiers for the delegations.
#' @param assessmentId &#91;required&#93; The identifier for the assessment.
#'
#' @keywords internal
#'
#' @rdname auditmanager_batch_delete_delegation_by_assessment
auditmanager_batch_delete_delegation_by_assessment <- function(delegationIds, assessmentId) {
  op <- new_operation(
    name = "BatchDeleteDelegationByAssessment",
    http_method = "PUT",
    http_path = "/assessments/{assessmentId}/delegations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$batch_delete_delegation_by_assessment_input(delegationIds = delegationIds, assessmentId = assessmentId)
  output <- .auditmanager$batch_delete_delegation_by_assessment_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$batch_delete_delegation_by_assessment <- auditmanager_batch_delete_delegation_by_assessment

#' Disassociates a list of evidence from an assessment report in Audit
#' Manager
#'
#' @description
#' Disassociates a list of evidence from an assessment report in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_batch_disassociate_assessment_report_evidence/](https://www.paws-r-sdk.com/docs/auditmanager_batch_disassociate_assessment_report_evidence/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The identifier for the assessment.
#' @param evidenceFolderId &#91;required&#93; The identifier for the folder that the evidence is stored in.
#' @param evidenceIds &#91;required&#93; The list of evidence identifiers.
#'
#' @keywords internal
#'
#' @rdname auditmanager_batch_disassociate_assessment_report_evidence
auditmanager_batch_disassociate_assessment_report_evidence <- function(assessmentId, evidenceFolderId, evidenceIds) {
  op <- new_operation(
    name = "BatchDisassociateAssessmentReportEvidence",
    http_method = "PUT",
    http_path = "/assessments/{assessmentId}/batchDisassociateFromAssessmentReport",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$batch_disassociate_assessment_report_evidence_input(assessmentId = assessmentId, evidenceFolderId = evidenceFolderId, evidenceIds = evidenceIds)
  output <- .auditmanager$batch_disassociate_assessment_report_evidence_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$batch_disassociate_assessment_report_evidence <- auditmanager_batch_disassociate_assessment_report_evidence

#' Adds one or more pieces of evidence to a control in an Audit Manager
#' assessment
#'
#' @description
#' Adds one or more pieces of evidence to a control in an Audit Manager assessment.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_batch_import_evidence_to_assessment_control/](https://www.paws-r-sdk.com/docs/auditmanager_batch_import_evidence_to_assessment_control/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The identifier for the assessment.
#' @param controlSetId &#91;required&#93; The identifier for the control set.
#' @param controlId &#91;required&#93; The identifier for the control.
#' @param manualEvidence &#91;required&#93; The list of manual evidence objects.
#'
#' @keywords internal
#'
#' @rdname auditmanager_batch_import_evidence_to_assessment_control
auditmanager_batch_import_evidence_to_assessment_control <- function(assessmentId, controlSetId, controlId, manualEvidence) {
  op <- new_operation(
    name = "BatchImportEvidenceToAssessmentControl",
    http_method = "POST",
    http_path = "/assessments/{assessmentId}/controlSets/{controlSetId}/controls/{controlId}/evidence",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$batch_import_evidence_to_assessment_control_input(assessmentId = assessmentId, controlSetId = controlSetId, controlId = controlId, manualEvidence = manualEvidence)
  output <- .auditmanager$batch_import_evidence_to_assessment_control_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$batch_import_evidence_to_assessment_control <- auditmanager_batch_import_evidence_to_assessment_control

#' Creates an assessment in Audit Manager
#'
#' @description
#' Creates an assessment in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_create_assessment/](https://www.paws-r-sdk.com/docs/auditmanager_create_assessment/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the assessment to be created.
#' @param description The optional description of the assessment to be created.
#' @param assessmentReportsDestination &#91;required&#93; The assessment report storage destination for the assessment that's
#' being created.
#' @param scope &#91;required&#93; 
#' @param roles &#91;required&#93; The list of roles for the assessment.
#' @param frameworkId &#91;required&#93; The identifier for the framework that the assessment will be created
#' from.
#' @param tags The tags that are associated with the assessment.
#'
#' @keywords internal
#'
#' @rdname auditmanager_create_assessment
auditmanager_create_assessment <- function(name, description = NULL, assessmentReportsDestination, scope, roles, frameworkId, tags = NULL) {
  op <- new_operation(
    name = "CreateAssessment",
    http_method = "POST",
    http_path = "/assessments",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$create_assessment_input(name = name, description = description, assessmentReportsDestination = assessmentReportsDestination, scope = scope, roles = roles, frameworkId = frameworkId, tags = tags)
  output <- .auditmanager$create_assessment_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$create_assessment <- auditmanager_create_assessment

#' Creates a custom framework in Audit Manager
#'
#' @description
#' Creates a custom framework in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_create_assessment_framework/](https://www.paws-r-sdk.com/docs/auditmanager_create_assessment_framework/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the new custom framework.
#' @param description An optional description for the new custom framework.
#' @param complianceType The compliance type that the new custom framework supports, such as CIS
#' or HIPAA.
#' @param controlSets &#91;required&#93; The control sets that are associated with the framework.
#' @param tags The tags that are associated with the framework.
#'
#' @keywords internal
#'
#' @rdname auditmanager_create_assessment_framework
auditmanager_create_assessment_framework <- function(name, description = NULL, complianceType = NULL, controlSets, tags = NULL) {
  op <- new_operation(
    name = "CreateAssessmentFramework",
    http_method = "POST",
    http_path = "/assessmentFrameworks",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$create_assessment_framework_input(name = name, description = description, complianceType = complianceType, controlSets = controlSets, tags = tags)
  output <- .auditmanager$create_assessment_framework_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$create_assessment_framework <- auditmanager_create_assessment_framework

#' Creates an assessment report for the specified assessment
#'
#' @description
#' Creates an assessment report for the specified assessment.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_create_assessment_report/](https://www.paws-r-sdk.com/docs/auditmanager_create_assessment_report/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the new assessment report.
#' @param description The description of the assessment report.
#' @param assessmentId &#91;required&#93; The identifier for the assessment.
#' @param queryStatement A SQL statement that represents an evidence finder query.
#' 
#' Provide this parameter when you want to generate an assessment report
#' from the results of an evidence finder search query. When you use this
#' parameter, Audit Manager generates a one-time report using only the
#' evidence from the query output. This report does not include any
#' assessment evidence that was manually [added to a report using the
#' console](https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence),
#' or [associated with a report using the
#' API](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchAssociateAssessmentReportEvidence.html).
#' 
#' To use this parameter, the
#' [enablementStatus](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_EvidenceFinderEnablement.html#auditmanager-Type-EvidenceFinderEnablement-enablementStatus)
#' of evidence finder must be `ENABLED`.
#' 
#' For examples and help resolving `queryStatement` validation exceptions,
#' see [Troubleshooting evidence finder
#' issues](https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions)
#' in the *Audit Manager User Guide.*
#'
#' @keywords internal
#'
#' @rdname auditmanager_create_assessment_report
auditmanager_create_assessment_report <- function(name, description = NULL, assessmentId, queryStatement = NULL) {
  op <- new_operation(
    name = "CreateAssessmentReport",
    http_method = "POST",
    http_path = "/assessments/{assessmentId}/reports",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$create_assessment_report_input(name = name, description = description, assessmentId = assessmentId, queryStatement = queryStatement)
  output <- .auditmanager$create_assessment_report_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$create_assessment_report <- auditmanager_create_assessment_report

#' Creates a new custom control in Audit Manager
#'
#' @description
#' Creates a new custom control in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_create_control/](https://www.paws-r-sdk.com/docs/auditmanager_create_control/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the control.
#' @param description The description of the control.
#' @param testingInformation The steps to follow to determine if the control is satisfied.
#' @param actionPlanTitle The title of the action plan for remediating the control.
#' @param actionPlanInstructions The recommended actions to carry out if the control isn't fulfilled.
#' @param controlMappingSources &#91;required&#93; The data mapping sources for the control.
#' @param tags The tags that are associated with the control.
#'
#' @keywords internal
#'
#' @rdname auditmanager_create_control
auditmanager_create_control <- function(name, description = NULL, testingInformation = NULL, actionPlanTitle = NULL, actionPlanInstructions = NULL, controlMappingSources, tags = NULL) {
  op <- new_operation(
    name = "CreateControl",
    http_method = "POST",
    http_path = "/controls",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$create_control_input(name = name, description = description, testingInformation = testingInformation, actionPlanTitle = actionPlanTitle, actionPlanInstructions = actionPlanInstructions, controlMappingSources = controlMappingSources, tags = tags)
  output <- .auditmanager$create_control_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$create_control <- auditmanager_create_control

#' Deletes an assessment in Audit Manager
#'
#' @description
#' Deletes an assessment in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_delete_assessment/](https://www.paws-r-sdk.com/docs/auditmanager_delete_assessment/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The identifier for the assessment.
#'
#' @keywords internal
#'
#' @rdname auditmanager_delete_assessment
auditmanager_delete_assessment <- function(assessmentId) {
  op <- new_operation(
    name = "DeleteAssessment",
    http_method = "DELETE",
    http_path = "/assessments/{assessmentId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$delete_assessment_input(assessmentId = assessmentId)
  output <- .auditmanager$delete_assessment_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$delete_assessment <- auditmanager_delete_assessment

#' Deletes a custom framework in Audit Manager
#'
#' @description
#' Deletes a custom framework in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_delete_assessment_framework/](https://www.paws-r-sdk.com/docs/auditmanager_delete_assessment_framework/) for full documentation.
#'
#' @param frameworkId &#91;required&#93; The identifier for the custom framework.
#'
#' @keywords internal
#'
#' @rdname auditmanager_delete_assessment_framework
auditmanager_delete_assessment_framework <- function(frameworkId) {
  op <- new_operation(
    name = "DeleteAssessmentFramework",
    http_method = "DELETE",
    http_path = "/assessmentFrameworks/{frameworkId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$delete_assessment_framework_input(frameworkId = frameworkId)
  output <- .auditmanager$delete_assessment_framework_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$delete_assessment_framework <- auditmanager_delete_assessment_framework

#' Deletes a share request for a custom framework in Audit Manager
#'
#' @description
#' Deletes a share request for a custom framework in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_delete_assessment_framework_share/](https://www.paws-r-sdk.com/docs/auditmanager_delete_assessment_framework_share/) for full documentation.
#'
#' @param requestId &#91;required&#93; The unique identifier for the share request to be deleted.
#' @param requestType &#91;required&#93; Specifies whether the share request is a sent request or a received
#' request.
#'
#' @keywords internal
#'
#' @rdname auditmanager_delete_assessment_framework_share
auditmanager_delete_assessment_framework_share <- function(requestId, requestType) {
  op <- new_operation(
    name = "DeleteAssessmentFrameworkShare",
    http_method = "DELETE",
    http_path = "/assessmentFrameworkShareRequests/{requestId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$delete_assessment_framework_share_input(requestId = requestId, requestType = requestType)
  output <- .auditmanager$delete_assessment_framework_share_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$delete_assessment_framework_share <- auditmanager_delete_assessment_framework_share

#' Deletes an assessment report in Audit Manager
#'
#' @description
#' Deletes an assessment report in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_delete_assessment_report/](https://www.paws-r-sdk.com/docs/auditmanager_delete_assessment_report/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The unique identifier for the assessment.
#' @param assessmentReportId &#91;required&#93; The unique identifier for the assessment report.
#'
#' @keywords internal
#'
#' @rdname auditmanager_delete_assessment_report
auditmanager_delete_assessment_report <- function(assessmentId, assessmentReportId) {
  op <- new_operation(
    name = "DeleteAssessmentReport",
    http_method = "DELETE",
    http_path = "/assessments/{assessmentId}/reports/{assessmentReportId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$delete_assessment_report_input(assessmentId = assessmentId, assessmentReportId = assessmentReportId)
  output <- .auditmanager$delete_assessment_report_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$delete_assessment_report <- auditmanager_delete_assessment_report

#' Deletes a custom control in Audit Manager
#'
#' @description
#' Deletes a custom control in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_delete_control/](https://www.paws-r-sdk.com/docs/auditmanager_delete_control/) for full documentation.
#'
#' @param controlId &#91;required&#93; The unique identifier for the control.
#'
#' @keywords internal
#'
#' @rdname auditmanager_delete_control
auditmanager_delete_control <- function(controlId) {
  op <- new_operation(
    name = "DeleteControl",
    http_method = "DELETE",
    http_path = "/controls/{controlId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$delete_control_input(controlId = controlId)
  output <- .auditmanager$delete_control_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$delete_control <- auditmanager_delete_control

#' Deregisters an account in Audit Manager
#'
#' @description
#' Deregisters an account in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_deregister_account/](https://www.paws-r-sdk.com/docs/auditmanager_deregister_account/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname auditmanager_deregister_account
auditmanager_deregister_account <- function() {
  op <- new_operation(
    name = "DeregisterAccount",
    http_method = "POST",
    http_path = "/account/deregisterAccount",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$deregister_account_input()
  output <- .auditmanager$deregister_account_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$deregister_account <- auditmanager_deregister_account

#' Removes the specified Amazon Web Services account as a delegated
#' administrator for Audit Manager
#'
#' @description
#' Removes the specified Amazon Web Services account as a delegated administrator for Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_deregister_organization_admin_account/](https://www.paws-r-sdk.com/docs/auditmanager_deregister_organization_admin_account/) for full documentation.
#'
#' @param adminAccountId The identifier for the administrator account.
#'
#' @keywords internal
#'
#' @rdname auditmanager_deregister_organization_admin_account
auditmanager_deregister_organization_admin_account <- function(adminAccountId = NULL) {
  op <- new_operation(
    name = "DeregisterOrganizationAdminAccount",
    http_method = "POST",
    http_path = "/account/deregisterOrganizationAdminAccount",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$deregister_organization_admin_account_input(adminAccountId = adminAccountId)
  output <- .auditmanager$deregister_organization_admin_account_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$deregister_organization_admin_account <- auditmanager_deregister_organization_admin_account

#' Disassociates an evidence folder from the specified assessment report in
#' Audit Manager
#'
#' @description
#' Disassociates an evidence folder from the specified assessment report in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_disassociate_assessment_report_evidence_folder/](https://www.paws-r-sdk.com/docs/auditmanager_disassociate_assessment_report_evidence_folder/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The unique identifier for the assessment.
#' @param evidenceFolderId &#91;required&#93; The unique identifier for the folder that the evidence is stored in.
#'
#' @keywords internal
#'
#' @rdname auditmanager_disassociate_assessment_report_evidence_folder
auditmanager_disassociate_assessment_report_evidence_folder <- function(assessmentId, evidenceFolderId) {
  op <- new_operation(
    name = "DisassociateAssessmentReportEvidenceFolder",
    http_method = "PUT",
    http_path = "/assessments/{assessmentId}/disassociateFromAssessmentReport",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$disassociate_assessment_report_evidence_folder_input(assessmentId = assessmentId, evidenceFolderId = evidenceFolderId)
  output <- .auditmanager$disassociate_assessment_report_evidence_folder_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$disassociate_assessment_report_evidence_folder <- auditmanager_disassociate_assessment_report_evidence_folder

#' Gets the registration status of an account in Audit Manager
#'
#' @description
#' Gets the registration status of an account in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_account_status/](https://www.paws-r-sdk.com/docs/auditmanager_get_account_status/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname auditmanager_get_account_status
auditmanager_get_account_status <- function() {
  op <- new_operation(
    name = "GetAccountStatus",
    http_method = "GET",
    http_path = "/account/status",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$get_account_status_input()
  output <- .auditmanager$get_account_status_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_account_status <- auditmanager_get_account_status

#' Gets information about a specified assessment
#'
#' @description
#' Gets information about a specified assessment.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_assessment/](https://www.paws-r-sdk.com/docs/auditmanager_get_assessment/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The unique identifier for the assessment.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_assessment
auditmanager_get_assessment <- function(assessmentId) {
  op <- new_operation(
    name = "GetAssessment",
    http_method = "GET",
    http_path = "/assessments/{assessmentId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$get_assessment_input(assessmentId = assessmentId)
  output <- .auditmanager$get_assessment_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_assessment <- auditmanager_get_assessment

#' Gets information about a specified framework
#'
#' @description
#' Gets information about a specified framework.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_assessment_framework/](https://www.paws-r-sdk.com/docs/auditmanager_get_assessment_framework/) for full documentation.
#'
#' @param frameworkId &#91;required&#93; The identifier for the framework.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_assessment_framework
auditmanager_get_assessment_framework <- function(frameworkId) {
  op <- new_operation(
    name = "GetAssessmentFramework",
    http_method = "GET",
    http_path = "/assessmentFrameworks/{frameworkId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$get_assessment_framework_input(frameworkId = frameworkId)
  output <- .auditmanager$get_assessment_framework_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_assessment_framework <- auditmanager_get_assessment_framework

#' Gets the URL of an assessment report in Audit Manager
#'
#' @description
#' Gets the URL of an assessment report in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_assessment_report_url/](https://www.paws-r-sdk.com/docs/auditmanager_get_assessment_report_url/) for full documentation.
#'
#' @param assessmentReportId &#91;required&#93; The unique identifier for the assessment report.
#' @param assessmentId &#91;required&#93; The unique identifier for the assessment.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_assessment_report_url
auditmanager_get_assessment_report_url <- function(assessmentReportId, assessmentId) {
  op <- new_operation(
    name = "GetAssessmentReportUrl",
    http_method = "GET",
    http_path = "/assessments/{assessmentId}/reports/{assessmentReportId}/url",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$get_assessment_report_url_input(assessmentReportId = assessmentReportId, assessmentId = assessmentId)
  output <- .auditmanager$get_assessment_report_url_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_assessment_report_url <- auditmanager_get_assessment_report_url

#' Gets a list of changelogs from Audit Manager
#'
#' @description
#' Gets a list of changelogs from Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_change_logs/](https://www.paws-r-sdk.com/docs/auditmanager_get_change_logs/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The unique identifier for the assessment.
#' @param controlSetId The unique identifier for the control set.
#' @param controlId The unique identifier for the control.
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_change_logs
auditmanager_get_change_logs <- function(assessmentId, controlSetId = NULL, controlId = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetChangeLogs",
    http_method = "GET",
    http_path = "/assessments/{assessmentId}/changelogs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$get_change_logs_input(assessmentId = assessmentId, controlSetId = controlSetId, controlId = controlId, nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$get_change_logs_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_change_logs <- auditmanager_get_change_logs

#' Gets information about a specified control
#'
#' @description
#' Gets information about a specified control.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_control/](https://www.paws-r-sdk.com/docs/auditmanager_get_control/) for full documentation.
#'
#' @param controlId &#91;required&#93; The identifier for the control.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_control
auditmanager_get_control <- function(controlId) {
  op <- new_operation(
    name = "GetControl",
    http_method = "GET",
    http_path = "/controls/{controlId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$get_control_input(controlId = controlId)
  output <- .auditmanager$get_control_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_control <- auditmanager_get_control

#' Gets a list of delegations from an audit owner to a delegate
#'
#' @description
#' Gets a list of delegations from an audit owner to a delegate.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_delegations/](https://www.paws-r-sdk.com/docs/auditmanager_get_delegations/) for full documentation.
#'
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_delegations
auditmanager_get_delegations <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetDelegations",
    http_method = "GET",
    http_path = "/delegations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$get_delegations_input(nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$get_delegations_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_delegations <- auditmanager_get_delegations

#' Gets information about a specified evidence item
#'
#' @description
#' Gets information about a specified evidence item.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_evidence/](https://www.paws-r-sdk.com/docs/auditmanager_get_evidence/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The unique identifier for the assessment.
#' @param controlSetId &#91;required&#93; The unique identifier for the control set.
#' @param evidenceFolderId &#91;required&#93; The unique identifier for the folder that the evidence is stored in.
#' @param evidenceId &#91;required&#93; The unique identifier for the evidence.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_evidence
auditmanager_get_evidence <- function(assessmentId, controlSetId, evidenceFolderId, evidenceId) {
  op <- new_operation(
    name = "GetEvidence",
    http_method = "GET",
    http_path = "/assessments/{assessmentId}/controlSets/{controlSetId}/evidenceFolders/{evidenceFolderId}/evidence/{evidenceId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$get_evidence_input(assessmentId = assessmentId, controlSetId = controlSetId, evidenceFolderId = evidenceFolderId, evidenceId = evidenceId)
  output <- .auditmanager$get_evidence_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_evidence <- auditmanager_get_evidence

#' Gets all evidence from a specified evidence folder in Audit Manager
#'
#' @description
#' Gets all evidence from a specified evidence folder in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_evidence_by_evidence_folder/](https://www.paws-r-sdk.com/docs/auditmanager_get_evidence_by_evidence_folder/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The identifier for the assessment.
#' @param controlSetId &#91;required&#93; The identifier for the control set.
#' @param evidenceFolderId &#91;required&#93; The unique identifier for the folder that the evidence is stored in.
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_evidence_by_evidence_folder
auditmanager_get_evidence_by_evidence_folder <- function(assessmentId, controlSetId, evidenceFolderId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetEvidenceByEvidenceFolder",
    http_method = "GET",
    http_path = "/assessments/{assessmentId}/controlSets/{controlSetId}/evidenceFolders/{evidenceFolderId}/evidence",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$get_evidence_by_evidence_folder_input(assessmentId = assessmentId, controlSetId = controlSetId, evidenceFolderId = evidenceFolderId, nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$get_evidence_by_evidence_folder_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_evidence_by_evidence_folder <- auditmanager_get_evidence_by_evidence_folder

#' Creates a presigned Amazon S3 URL that can be used to upload a file as
#' manual evidence
#'
#' @description
#' Creates a presigned Amazon S3 URL that can be used to upload a file as manual evidence. For instructions on how to use this operation, see [Upload a file from your browser](https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#how-to-upload-manual-evidence-files) in the *Audit Manager User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_evidence_file_upload_url/](https://www.paws-r-sdk.com/docs/auditmanager_get_evidence_file_upload_url/) for full documentation.
#'
#' @param fileName &#91;required&#93; The file that you want to upload. For a list of supported file formats,
#' see [Supported file types for manual
#' evidence](https://docs.aws.amazon.com/audit-manager/latest/userguide/upload-evidence.html#supported-manual-evidence-files)
#' in the *Audit Manager User Guide*.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_evidence_file_upload_url
auditmanager_get_evidence_file_upload_url <- function(fileName) {
  op <- new_operation(
    name = "GetEvidenceFileUploadUrl",
    http_method = "GET",
    http_path = "/evidenceFileUploadUrl",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$get_evidence_file_upload_url_input(fileName = fileName)
  output <- .auditmanager$get_evidence_file_upload_url_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_evidence_file_upload_url <- auditmanager_get_evidence_file_upload_url

#' Gets an evidence folder from a specified assessment in Audit Manager
#'
#' @description
#' Gets an evidence folder from a specified assessment in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_evidence_folder/](https://www.paws-r-sdk.com/docs/auditmanager_get_evidence_folder/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The unique identifier for the assessment.
#' @param controlSetId &#91;required&#93; The unique identifier for the control set.
#' @param evidenceFolderId &#91;required&#93; The unique identifier for the folder that the evidence is stored in.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_evidence_folder
auditmanager_get_evidence_folder <- function(assessmentId, controlSetId, evidenceFolderId) {
  op <- new_operation(
    name = "GetEvidenceFolder",
    http_method = "GET",
    http_path = "/assessments/{assessmentId}/controlSets/{controlSetId}/evidenceFolders/{evidenceFolderId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$get_evidence_folder_input(assessmentId = assessmentId, controlSetId = controlSetId, evidenceFolderId = evidenceFolderId)
  output <- .auditmanager$get_evidence_folder_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_evidence_folder <- auditmanager_get_evidence_folder

#' Gets the evidence folders from a specified assessment in Audit Manager
#'
#' @description
#' Gets the evidence folders from a specified assessment in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_evidence_folders_by_assessment/](https://www.paws-r-sdk.com/docs/auditmanager_get_evidence_folders_by_assessment/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The unique identifier for the assessment.
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_evidence_folders_by_assessment
auditmanager_get_evidence_folders_by_assessment <- function(assessmentId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetEvidenceFoldersByAssessment",
    http_method = "GET",
    http_path = "/assessments/{assessmentId}/evidenceFolders",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$get_evidence_folders_by_assessment_input(assessmentId = assessmentId, nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$get_evidence_folders_by_assessment_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_evidence_folders_by_assessment <- auditmanager_get_evidence_folders_by_assessment

#' Gets a list of evidence folders that are associated with a specified
#' control in an Audit Manager assessment
#'
#' @description
#' Gets a list of evidence folders that are associated with a specified control in an Audit Manager assessment.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_evidence_folders_by_assessment_control/](https://www.paws-r-sdk.com/docs/auditmanager_get_evidence_folders_by_assessment_control/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The identifier for the assessment.
#' @param controlSetId &#91;required&#93; The identifier for the control set.
#' @param controlId &#91;required&#93; The identifier for the control.
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_evidence_folders_by_assessment_control
auditmanager_get_evidence_folders_by_assessment_control <- function(assessmentId, controlSetId, controlId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetEvidenceFoldersByAssessmentControl",
    http_method = "GET",
    http_path = "/assessments/{assessmentId}/evidenceFolders-by-assessment-control/{controlSetId}/{controlId}",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$get_evidence_folders_by_assessment_control_input(assessmentId = assessmentId, controlSetId = controlSetId, controlId = controlId, nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$get_evidence_folders_by_assessment_control_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_evidence_folders_by_assessment_control <- auditmanager_get_evidence_folders_by_assessment_control

#' Gets the latest analytics data for all your current active assessments
#'
#' @description
#' Gets the latest analytics data for all your current active assessments.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_insights/](https://www.paws-r-sdk.com/docs/auditmanager_get_insights/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname auditmanager_get_insights
auditmanager_get_insights <- function() {
  op <- new_operation(
    name = "GetInsights",
    http_method = "GET",
    http_path = "/insights",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$get_insights_input()
  output <- .auditmanager$get_insights_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_insights <- auditmanager_get_insights

#' Gets the latest analytics data for a specific active assessment
#'
#' @description
#' Gets the latest analytics data for a specific active assessment.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_insights_by_assessment/](https://www.paws-r-sdk.com/docs/auditmanager_get_insights_by_assessment/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The unique identifier for the assessment.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_insights_by_assessment
auditmanager_get_insights_by_assessment <- function(assessmentId) {
  op <- new_operation(
    name = "GetInsightsByAssessment",
    http_method = "GET",
    http_path = "/insights/assessments/{assessmentId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$get_insights_by_assessment_input(assessmentId = assessmentId)
  output <- .auditmanager$get_insights_by_assessment_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_insights_by_assessment <- auditmanager_get_insights_by_assessment

#' Gets the name of the delegated Amazon Web Services administrator account
#' for a specified organization
#'
#' @description
#' Gets the name of the delegated Amazon Web Services administrator account for a specified organization.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_organization_admin_account/](https://www.paws-r-sdk.com/docs/auditmanager_get_organization_admin_account/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname auditmanager_get_organization_admin_account
auditmanager_get_organization_admin_account <- function() {
  op <- new_operation(
    name = "GetOrganizationAdminAccount",
    http_method = "GET",
    http_path = "/account/organizationAdminAccount",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$get_organization_admin_account_input()
  output <- .auditmanager$get_organization_admin_account_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_organization_admin_account <- auditmanager_get_organization_admin_account

#' Gets a list of the Amazon Web Services from which Audit Manager can
#' collect evidence
#'
#' @description
#' Gets a list of the Amazon Web Services from which Audit Manager can collect evidence.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_services_in_scope/](https://www.paws-r-sdk.com/docs/auditmanager_get_services_in_scope/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname auditmanager_get_services_in_scope
auditmanager_get_services_in_scope <- function() {
  op <- new_operation(
    name = "GetServicesInScope",
    http_method = "GET",
    http_path = "/services",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$get_services_in_scope_input()
  output <- .auditmanager$get_services_in_scope_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_services_in_scope <- auditmanager_get_services_in_scope

#' Gets the settings for a specified Amazon Web Services account
#'
#' @description
#' Gets the settings for a specified Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_get_settings/](https://www.paws-r-sdk.com/docs/auditmanager_get_settings/) for full documentation.
#'
#' @param attribute &#91;required&#93; The list of setting attribute enum values.
#'
#' @keywords internal
#'
#' @rdname auditmanager_get_settings
auditmanager_get_settings <- function(attribute) {
  op <- new_operation(
    name = "GetSettings",
    http_method = "GET",
    http_path = "/settings/{attribute}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$get_settings_input(attribute = attribute)
  output <- .auditmanager$get_settings_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$get_settings <- auditmanager_get_settings

#' Lists the latest analytics data for controls within a specific control
#' domain and a specific active assessment
#'
#' @description
#' Lists the latest analytics data for controls within a specific control domain and a specific active assessment.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_list_assessment_control_insights_by_control_domain/](https://www.paws-r-sdk.com/docs/auditmanager_list_assessment_control_insights_by_control_domain/) for full documentation.
#'
#' @param controlDomainId &#91;required&#93; The unique identifier for the control domain.
#' 
#' Audit Manager supports the control domains that are provided by Amazon
#' Web Services Control Catalog. For information about how to find a list
#' of available control domains, see
#' [`ListDomains`](https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListDomains.html)
#' in the Amazon Web Services Control Catalog API Reference.
#' @param assessmentId &#91;required&#93; The unique identifier for the active assessment.
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_list_asses_contr_insig_by_contr_domai
auditmanager_list_assessment_control_insights_by_control_domain <- function(controlDomainId, assessmentId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssessmentControlInsightsByControlDomain",
    http_method = "GET",
    http_path = "/insights/controls-by-assessment",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$list_assessment_control_insights_by_control_domain_input(controlDomainId = controlDomainId, assessmentId = assessmentId, nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$list_assessment_control_insights_by_control_domain_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$list_assessment_control_insights_by_control_domain <- auditmanager_list_assessment_control_insights_by_control_domain

#' Returns a list of sent or received share requests for custom frameworks
#' in Audit Manager
#'
#' @description
#' Returns a list of sent or received share requests for custom frameworks in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_list_assessment_framework_share_requests/](https://www.paws-r-sdk.com/docs/auditmanager_list_assessment_framework_share_requests/) for full documentation.
#'
#' @param requestType &#91;required&#93; Specifies whether the share request is a sent request or a received
#' request.
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_list_assessment_framework_share_requests
auditmanager_list_assessment_framework_share_requests <- function(requestType, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssessmentFrameworkShareRequests",
    http_method = "GET",
    http_path = "/assessmentFrameworkShareRequests",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$list_assessment_framework_share_requests_input(requestType = requestType, nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$list_assessment_framework_share_requests_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$list_assessment_framework_share_requests <- auditmanager_list_assessment_framework_share_requests

#' Returns a list of the frameworks that are available in the Audit Manager
#' framework library
#'
#' @description
#' Returns a list of the frameworks that are available in the Audit Manager framework library.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_list_assessment_frameworks/](https://www.paws-r-sdk.com/docs/auditmanager_list_assessment_frameworks/) for full documentation.
#'
#' @param frameworkType &#91;required&#93; The type of framework, such as a standard framework or a custom
#' framework.
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_list_assessment_frameworks
auditmanager_list_assessment_frameworks <- function(frameworkType, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssessmentFrameworks",
    http_method = "GET",
    http_path = "/assessmentFrameworks",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$list_assessment_frameworks_input(frameworkType = frameworkType, nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$list_assessment_frameworks_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$list_assessment_frameworks <- auditmanager_list_assessment_frameworks

#' Returns a list of assessment reports created in Audit Manager
#'
#' @description
#' Returns a list of assessment reports created in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_list_assessment_reports/](https://www.paws-r-sdk.com/docs/auditmanager_list_assessment_reports/) for full documentation.
#'
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_list_assessment_reports
auditmanager_list_assessment_reports <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssessmentReports",
    http_method = "GET",
    http_path = "/assessmentReports",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$list_assessment_reports_input(nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$list_assessment_reports_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$list_assessment_reports <- auditmanager_list_assessment_reports

#' Returns a list of current and past assessments from Audit Manager
#'
#' @description
#' Returns a list of current and past assessments from Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_list_assessments/](https://www.paws-r-sdk.com/docs/auditmanager_list_assessments/) for full documentation.
#'
#' @param status The current status of the assessment.
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_list_assessments
auditmanager_list_assessments <- function(status = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssessments",
    http_method = "GET",
    http_path = "/assessments",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$list_assessments_input(status = status, nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$list_assessments_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$list_assessments <- auditmanager_list_assessments

#' Lists the latest analytics data for control domains across all of your
#' active assessments
#'
#' @description
#' Lists the latest analytics data for control domains across all of your active assessments.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_list_control_domain_insights/](https://www.paws-r-sdk.com/docs/auditmanager_list_control_domain_insights/) for full documentation.
#'
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_list_control_domain_insights
auditmanager_list_control_domain_insights <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListControlDomainInsights",
    http_method = "GET",
    http_path = "/insights/control-domains",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$list_control_domain_insights_input(nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$list_control_domain_insights_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$list_control_domain_insights <- auditmanager_list_control_domain_insights

#' Lists analytics data for control domains within a specified active
#' assessment
#'
#' @description
#' Lists analytics data for control domains within a specified active assessment.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_list_control_domain_insights_by_assessment/](https://www.paws-r-sdk.com/docs/auditmanager_list_control_domain_insights_by_assessment/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The unique identifier for the active assessment.
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_list_control_domain_insights_by_assessment
auditmanager_list_control_domain_insights_by_assessment <- function(assessmentId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListControlDomainInsightsByAssessment",
    http_method = "GET",
    http_path = "/insights/control-domains-by-assessment",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$list_control_domain_insights_by_assessment_input(assessmentId = assessmentId, nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$list_control_domain_insights_by_assessment_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$list_control_domain_insights_by_assessment <- auditmanager_list_control_domain_insights_by_assessment

#' Lists the latest analytics data for controls within a specific control
#' domain across all active assessments
#'
#' @description
#' Lists the latest analytics data for controls within a specific control domain across all active assessments.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_list_control_insights_by_control_domain/](https://www.paws-r-sdk.com/docs/auditmanager_list_control_insights_by_control_domain/) for full documentation.
#'
#' @param controlDomainId &#91;required&#93; The unique identifier for the control domain.
#' 
#' Audit Manager supports the control domains that are provided by Amazon
#' Web Services Control Catalog. For information about how to find a list
#' of available control domains, see
#' [`ListDomains`](https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListDomains.html)
#' in the Amazon Web Services Control Catalog API Reference.
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_list_control_insights_by_control_domain
auditmanager_list_control_insights_by_control_domain <- function(controlDomainId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListControlInsightsByControlDomain",
    http_method = "GET",
    http_path = "/insights/controls",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$list_control_insights_by_control_domain_input(controlDomainId = controlDomainId, nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$list_control_insights_by_control_domain_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$list_control_insights_by_control_domain <- auditmanager_list_control_insights_by_control_domain

#' Returns a list of controls from Audit Manager
#'
#' @description
#' Returns a list of controls from Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_list_controls/](https://www.paws-r-sdk.com/docs/auditmanager_list_controls/) for full documentation.
#'
#' @param controlType &#91;required&#93; A filter that narrows the list of controls to a specific type.
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults The maximum number of results on a page or for an API request call.
#' @param controlCatalogId A filter that narrows the list of controls to a specific resource from
#' the Amazon Web Services Control Catalog.
#' 
#' To use this parameter, specify the ARN of the Control Catalog resource.
#' You can specify either a control domain, a control objective, or a
#' common control. For information about how to find the ARNs for these
#' resources, see
#' [`ListDomains`](https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListDomains.html)
#' ,
#' [`ListObjectives`](https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListObjectives.html)
#' , and
#' [`ListCommonControls`](https://docs.aws.amazon.com/controlcatalog/latest/APIReference/API_ListCommonControls.html)
#' .
#' 
#' You can only filter by one Control Catalog resource at a time.
#' Specifying multiple resource ARNs isn’t currently supported. If you want
#' to filter by more than one ARN, we recommend that you run the
#' [`list_controls`][auditmanager_list_controls] operation separately for
#' each ARN.
#' 
#' Alternatively, specify `UNCATEGORIZED` to list controls that aren't
#' mapped to a Control Catalog resource. For example, this operation might
#' return a list of custom controls that don't belong to any control domain
#' or control objective.
#'
#' @keywords internal
#'
#' @rdname auditmanager_list_controls
auditmanager_list_controls <- function(controlType, nextToken = NULL, maxResults = NULL, controlCatalogId = NULL) {
  op <- new_operation(
    name = "ListControls",
    http_method = "GET",
    http_path = "/controls",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$list_controls_input(controlType = controlType, nextToken = nextToken, maxResults = maxResults, controlCatalogId = controlCatalogId)
  output <- .auditmanager$list_controls_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$list_controls <- auditmanager_list_controls

#' Returns a list of keywords that are pre-mapped to the specified control
#' data source
#'
#' @description
#' Returns a list of keywords that are pre-mapped to the specified control data source.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_list_keywords_for_data_source/](https://www.paws-r-sdk.com/docs/auditmanager_list_keywords_for_data_source/) for full documentation.
#'
#' @param source &#91;required&#93; The control mapping data source that the keywords apply to.
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_list_keywords_for_data_source
auditmanager_list_keywords_for_data_source <- function(source, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListKeywordsForDataSource",
    http_method = "GET",
    http_path = "/dataSourceKeywords",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$list_keywords_for_data_source_input(source = source, nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$list_keywords_for_data_source_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$list_keywords_for_data_source <- auditmanager_list_keywords_for_data_source

#' Returns a list of all Audit Manager notifications
#'
#' @description
#' Returns a list of all Audit Manager notifications.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_list_notifications/](https://www.paws-r-sdk.com/docs/auditmanager_list_notifications/) for full documentation.
#'
#' @param nextToken The pagination token that's used to fetch the next set of results.
#' @param maxResults Represents the maximum number of results on a page or for an API request
#' call.
#'
#' @keywords internal
#'
#' @rdname auditmanager_list_notifications
auditmanager_list_notifications <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListNotifications",
    http_method = "GET",
    http_path = "/notifications",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .auditmanager$list_notifications_input(nextToken = nextToken, maxResults = maxResults)
  output <- .auditmanager$list_notifications_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$list_notifications <- auditmanager_list_notifications

#' Returns a list of tags for the specified resource in Audit Manager
#'
#' @description
#' Returns a list of tags for the specified resource in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/auditmanager_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname auditmanager_list_tags_for_resource
auditmanager_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .auditmanager$list_tags_for_resource_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$list_tags_for_resource <- auditmanager_list_tags_for_resource

#' Enables Audit Manager for the specified Amazon Web Services account
#'
#' @description
#' Enables Audit Manager for the specified Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_register_account/](https://www.paws-r-sdk.com/docs/auditmanager_register_account/) for full documentation.
#'
#' @param kmsKey The KMS key details.
#' @param delegatedAdminAccount The delegated administrator account for Audit Manager.
#'
#' @keywords internal
#'
#' @rdname auditmanager_register_account
auditmanager_register_account <- function(kmsKey = NULL, delegatedAdminAccount = NULL) {
  op <- new_operation(
    name = "RegisterAccount",
    http_method = "POST",
    http_path = "/account/registerAccount",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$register_account_input(kmsKey = kmsKey, delegatedAdminAccount = delegatedAdminAccount)
  output <- .auditmanager$register_account_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$register_account <- auditmanager_register_account

#' Enables an Amazon Web Services account within the organization as the
#' delegated administrator for Audit Manager
#'
#' @description
#' Enables an Amazon Web Services account within the organization as the delegated administrator for Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_register_organization_admin_account/](https://www.paws-r-sdk.com/docs/auditmanager_register_organization_admin_account/) for full documentation.
#'
#' @param adminAccountId &#91;required&#93; The identifier for the delegated administrator account.
#'
#' @keywords internal
#'
#' @rdname auditmanager_register_organization_admin_account
auditmanager_register_organization_admin_account <- function(adminAccountId) {
  op <- new_operation(
    name = "RegisterOrganizationAdminAccount",
    http_method = "POST",
    http_path = "/account/registerOrganizationAdminAccount",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$register_organization_admin_account_input(adminAccountId = adminAccountId)
  output <- .auditmanager$register_organization_admin_account_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$register_organization_admin_account <- auditmanager_register_organization_admin_account

#' Creates a share request for a custom framework in Audit Manager
#'
#' @description
#' Creates a share request for a custom framework in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_start_assessment_framework_share/](https://www.paws-r-sdk.com/docs/auditmanager_start_assessment_framework_share/) for full documentation.
#'
#' @param frameworkId &#91;required&#93; The unique identifier for the custom framework to be shared.
#' @param destinationAccount &#91;required&#93; The Amazon Web Services account of the recipient.
#' @param destinationRegion &#91;required&#93; The Amazon Web Services Region of the recipient.
#' @param comment An optional comment from the sender about the share request.
#'
#' @keywords internal
#'
#' @rdname auditmanager_start_assessment_framework_share
auditmanager_start_assessment_framework_share <- function(frameworkId, destinationAccount, destinationRegion, comment = NULL) {
  op <- new_operation(
    name = "StartAssessmentFrameworkShare",
    http_method = "POST",
    http_path = "/assessmentFrameworks/{frameworkId}/shareRequests",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$start_assessment_framework_share_input(frameworkId = frameworkId, destinationAccount = destinationAccount, destinationRegion = destinationRegion, comment = comment)
  output <- .auditmanager$start_assessment_framework_share_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$start_assessment_framework_share <- auditmanager_start_assessment_framework_share

#' Tags the specified resource in Audit Manager
#'
#' @description
#' Tags the specified resource in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_tag_resource/](https://www.paws-r-sdk.com/docs/auditmanager_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; The tags that are associated with the resource.
#'
#' @keywords internal
#'
#' @rdname auditmanager_tag_resource
auditmanager_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .auditmanager$tag_resource_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$tag_resource <- auditmanager_tag_resource

#' Removes a tag from a resource in Audit Manager
#'
#' @description
#' Removes a tag from a resource in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_untag_resource/](https://www.paws-r-sdk.com/docs/auditmanager_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the specified resource.
#' @param tagKeys &#91;required&#93; The name or key of the tag.
#'
#' @keywords internal
#'
#' @rdname auditmanager_untag_resource
auditmanager_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .auditmanager$untag_resource_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$untag_resource <- auditmanager_untag_resource

#' Edits an Audit Manager assessment
#'
#' @description
#' Edits an Audit Manager assessment.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_update_assessment/](https://www.paws-r-sdk.com/docs/auditmanager_update_assessment/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The unique identifier for the assessment.
#' @param assessmentName The name of the assessment to be updated.
#' @param assessmentDescription The description of the assessment.
#' @param scope &#91;required&#93; The scope of the assessment.
#' @param assessmentReportsDestination The assessment report storage destination for the assessment that's
#' being updated.
#' @param roles The list of roles for the assessment.
#'
#' @keywords internal
#'
#' @rdname auditmanager_update_assessment
auditmanager_update_assessment <- function(assessmentId, assessmentName = NULL, assessmentDescription = NULL, scope, assessmentReportsDestination = NULL, roles = NULL) {
  op <- new_operation(
    name = "UpdateAssessment",
    http_method = "PUT",
    http_path = "/assessments/{assessmentId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$update_assessment_input(assessmentId = assessmentId, assessmentName = assessmentName, assessmentDescription = assessmentDescription, scope = scope, assessmentReportsDestination = assessmentReportsDestination, roles = roles)
  output <- .auditmanager$update_assessment_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$update_assessment <- auditmanager_update_assessment

#' Updates a control within an assessment in Audit Manager
#'
#' @description
#' Updates a control within an assessment in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_update_assessment_control/](https://www.paws-r-sdk.com/docs/auditmanager_update_assessment_control/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The unique identifier for the assessment.
#' @param controlSetId &#91;required&#93; The unique identifier for the control set.
#' @param controlId &#91;required&#93; The unique identifier for the control.
#' @param controlStatus The status of the control.
#' @param commentBody The comment body text for the control.
#'
#' @keywords internal
#'
#' @rdname auditmanager_update_assessment_control
auditmanager_update_assessment_control <- function(assessmentId, controlSetId, controlId, controlStatus = NULL, commentBody = NULL) {
  op <- new_operation(
    name = "UpdateAssessmentControl",
    http_method = "PUT",
    http_path = "/assessments/{assessmentId}/controlSets/{controlSetId}/controls/{controlId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$update_assessment_control_input(assessmentId = assessmentId, controlSetId = controlSetId, controlId = controlId, controlStatus = controlStatus, commentBody = commentBody)
  output <- .auditmanager$update_assessment_control_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$update_assessment_control <- auditmanager_update_assessment_control

#' Updates the status of a control set in an Audit Manager assessment
#'
#' @description
#' Updates the status of a control set in an Audit Manager assessment.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_update_assessment_control_set_status/](https://www.paws-r-sdk.com/docs/auditmanager_update_assessment_control_set_status/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The unique identifier for the assessment.
#' @param controlSetId &#91;required&#93; The unique identifier for the control set.
#' @param status &#91;required&#93; The status of the control set that's being updated.
#' @param comment &#91;required&#93; The comment that's related to the status update.
#'
#' @keywords internal
#'
#' @rdname auditmanager_update_assessment_control_set_status
auditmanager_update_assessment_control_set_status <- function(assessmentId, controlSetId, status, comment) {
  op <- new_operation(
    name = "UpdateAssessmentControlSetStatus",
    http_method = "PUT",
    http_path = "/assessments/{assessmentId}/controlSets/{controlSetId}/status",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$update_assessment_control_set_status_input(assessmentId = assessmentId, controlSetId = controlSetId, status = status, comment = comment)
  output <- .auditmanager$update_assessment_control_set_status_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$update_assessment_control_set_status <- auditmanager_update_assessment_control_set_status

#' Updates a custom framework in Audit Manager
#'
#' @description
#' Updates a custom framework in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_update_assessment_framework/](https://www.paws-r-sdk.com/docs/auditmanager_update_assessment_framework/) for full documentation.
#'
#' @param frameworkId &#91;required&#93; The unique identifier for the framework.
#' @param name &#91;required&#93; The name of the framework to be updated.
#' @param description The description of the updated framework.
#' @param complianceType The compliance type that the new custom framework supports, such as CIS
#' or HIPAA.
#' @param controlSets &#91;required&#93; The control sets that are associated with the framework.
#'
#' @keywords internal
#'
#' @rdname auditmanager_update_assessment_framework
auditmanager_update_assessment_framework <- function(frameworkId, name, description = NULL, complianceType = NULL, controlSets) {
  op <- new_operation(
    name = "UpdateAssessmentFramework",
    http_method = "PUT",
    http_path = "/assessmentFrameworks/{frameworkId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$update_assessment_framework_input(frameworkId = frameworkId, name = name, description = description, complianceType = complianceType, controlSets = controlSets)
  output <- .auditmanager$update_assessment_framework_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$update_assessment_framework <- auditmanager_update_assessment_framework

#' Updates a share request for a custom framework in Audit Manager
#'
#' @description
#' Updates a share request for a custom framework in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_update_assessment_framework_share/](https://www.paws-r-sdk.com/docs/auditmanager_update_assessment_framework_share/) for full documentation.
#'
#' @param requestId &#91;required&#93; The unique identifier for the share request.
#' @param requestType &#91;required&#93; Specifies whether the share request is a sent request or a received
#' request.
#' @param action &#91;required&#93; Specifies the update action for the share request.
#'
#' @keywords internal
#'
#' @rdname auditmanager_update_assessment_framework_share
auditmanager_update_assessment_framework_share <- function(requestId, requestType, action) {
  op <- new_operation(
    name = "UpdateAssessmentFrameworkShare",
    http_method = "PUT",
    http_path = "/assessmentFrameworkShareRequests/{requestId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$update_assessment_framework_share_input(requestId = requestId, requestType = requestType, action = action)
  output <- .auditmanager$update_assessment_framework_share_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$update_assessment_framework_share <- auditmanager_update_assessment_framework_share

#' Updates the status of an assessment in Audit Manager
#'
#' @description
#' Updates the status of an assessment in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_update_assessment_status/](https://www.paws-r-sdk.com/docs/auditmanager_update_assessment_status/) for full documentation.
#'
#' @param assessmentId &#91;required&#93; The unique identifier for the assessment.
#' @param status &#91;required&#93; The current status of the assessment.
#'
#' @keywords internal
#'
#' @rdname auditmanager_update_assessment_status
auditmanager_update_assessment_status <- function(assessmentId, status) {
  op <- new_operation(
    name = "UpdateAssessmentStatus",
    http_method = "PUT",
    http_path = "/assessments/{assessmentId}/status",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$update_assessment_status_input(assessmentId = assessmentId, status = status)
  output <- .auditmanager$update_assessment_status_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$update_assessment_status <- auditmanager_update_assessment_status

#' Updates a custom control in Audit Manager
#'
#' @description
#' Updates a custom control in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_update_control/](https://www.paws-r-sdk.com/docs/auditmanager_update_control/) for full documentation.
#'
#' @param controlId &#91;required&#93; The identifier for the control.
#' @param name &#91;required&#93; The name of the updated control.
#' @param description The optional description of the control.
#' @param testingInformation The steps that you should follow to determine if the control is met.
#' @param actionPlanTitle The title of the action plan for remediating the control.
#' @param actionPlanInstructions The recommended actions to carry out if the control isn't fulfilled.
#' @param controlMappingSources &#91;required&#93; The data mapping sources for the control.
#'
#' @keywords internal
#'
#' @rdname auditmanager_update_control
auditmanager_update_control <- function(controlId, name, description = NULL, testingInformation = NULL, actionPlanTitle = NULL, actionPlanInstructions = NULL, controlMappingSources) {
  op <- new_operation(
    name = "UpdateControl",
    http_method = "PUT",
    http_path = "/controls/{controlId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$update_control_input(controlId = controlId, name = name, description = description, testingInformation = testingInformation, actionPlanTitle = actionPlanTitle, actionPlanInstructions = actionPlanInstructions, controlMappingSources = controlMappingSources)
  output <- .auditmanager$update_control_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$update_control <- auditmanager_update_control

#' Updates Audit Manager settings for the current account
#'
#' @description
#' Updates Audit Manager settings for the current account.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_update_settings/](https://www.paws-r-sdk.com/docs/auditmanager_update_settings/) for full documentation.
#'
#' @param snsTopic The Amazon Simple Notification Service (Amazon SNS) topic that Audit
#' Manager sends notifications to.
#' @param defaultAssessmentReportsDestination The default S3 destination bucket for storing assessment reports.
#' @param defaultProcessOwners A list of the default audit owners.
#' @param kmsKey The KMS key details.
#' @param evidenceFinderEnabled Specifies whether the evidence finder feature is enabled. Change this
#' attribute to enable or disable evidence finder.
#' 
#' When you use this attribute to disable evidence finder, Audit Manager
#' deletes the event data store that’s used to query your evidence data. As
#' a result, you can’t re-enable evidence finder and use the feature again.
#' Your only alternative is to
#' [deregister](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_DeregisterAccount.html)
#' and then
#' [re-register](https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_RegisterAccount.html)
#' Audit Manager.
#' @param deregistrationPolicy The deregistration policy for your Audit Manager data. You can use this
#' attribute to determine how your data is handled when you deregister
#' Audit Manager.
#' @param defaultExportDestination The default S3 destination bucket for storing evidence finder exports.
#'
#' @keywords internal
#'
#' @rdname auditmanager_update_settings
auditmanager_update_settings <- function(snsTopic = NULL, defaultAssessmentReportsDestination = NULL, defaultProcessOwners = NULL, kmsKey = NULL, evidenceFinderEnabled = NULL, deregistrationPolicy = NULL, defaultExportDestination = NULL) {
  op <- new_operation(
    name = "UpdateSettings",
    http_method = "PUT",
    http_path = "/settings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$update_settings_input(snsTopic = snsTopic, defaultAssessmentReportsDestination = defaultAssessmentReportsDestination, defaultProcessOwners = defaultProcessOwners, kmsKey = kmsKey, evidenceFinderEnabled = evidenceFinderEnabled, deregistrationPolicy = deregistrationPolicy, defaultExportDestination = defaultExportDestination)
  output <- .auditmanager$update_settings_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$update_settings <- auditmanager_update_settings

#' Validates the integrity of an assessment report in Audit Manager
#'
#' @description
#' Validates the integrity of an assessment report in Audit Manager.
#'
#' See [https://www.paws-r-sdk.com/docs/auditmanager_validate_assessment_report_integrity/](https://www.paws-r-sdk.com/docs/auditmanager_validate_assessment_report_integrity/) for full documentation.
#'
#' @param s3RelativePath &#91;required&#93; The relative path of the Amazon S3 bucket that the assessment report is
#' stored in.
#'
#' @keywords internal
#'
#' @rdname auditmanager_validate_assessment_report_integrity
auditmanager_validate_assessment_report_integrity <- function(s3RelativePath) {
  op <- new_operation(
    name = "ValidateAssessmentReportIntegrity",
    http_method = "POST",
    http_path = "/assessmentReports/integrity",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .auditmanager$validate_assessment_report_integrity_input(s3RelativePath = s3RelativePath)
  output <- .auditmanager$validate_assessment_report_integrity_output()
  config <- get_config()
  svc <- .auditmanager$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.auditmanager$operations$validate_assessment_report_integrity <- auditmanager_validate_assessment_report_integrity
