% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_put_integration_response}
\alias{apigateway_put_integration_response}
\title{Represents a put integration}
\usage{
apigateway_put_integration_response(restApiId, resourceId, httpMethod,
  statusCode, selectionPattern, responseParameters, responseTemplates,
  contentHandling)
}
\arguments{
\item{restApiId}{[required] [Required] The string identifier of the associated RestApi.}

\item{resourceId}{[required] [Required] Specifies a put integration response request's resource
identifier.}

\item{httpMethod}{[required] [Required] Specifies a put integration response request's HTTP method.}

\item{statusCode}{[required] [Required] Specifies the status code that is used to map the
integration response to an existing MethodResponse.}

\item{selectionPattern}{Specifies the selection pattern of a put integration response.}

\item{responseParameters}{A key-value map specifying response parameters that are passed to the
method response from the back end. The key is a method response header
parameter name and the mapped value is an integration response header
value, a static value enclosed within a pair of single quotes, or a JSON
expression from the integration response body. The mapping key must
match the pattern of \verb{method.response.header.\{name\}}, where \code{name} is a
valid and unique header name. The mapped non-static value must match the
pattern of \verb{integration.response.header.\{name\}} or
\verb{integration.response.body.\{JSON-expression\}}, where \code{name} must be a
valid and unique response header name and \code{JSON-expression} a valid JSON
expression without the \code{$} prefix.}

\item{responseTemplates}{Specifies a put integration response's templates.}

\item{contentHandling}{Specifies how to handle response payload content type conversions.
Supported values are \code{CONVERT_TO_BINARY} and \code{CONVERT_TO_TEXT}, with the
following behaviors:
\itemize{
\item \code{CONVERT_TO_BINARY}: Converts a response payload from a
Base64-encoded string to the corresponding binary blob.
\item \code{CONVERT_TO_TEXT}: Converts a response payload from a binary blob to
a Base64-encoded string.
}

If this property is not defined, the response payload will be passed
through from the integration response to the method response without
modification.}
}
\value{
A list with the following syntax:\preformatted{list(
  statusCode = "string",
  selectionPattern = "string",
  responseParameters = list(
    "string"
  ),
  responseTemplates = list(
    "string"
  ),
  contentHandling = "CONVERT_TO_BINARY"|"CONVERT_TO_TEXT"
)
}
}
\description{
Represents a put integration.
}
\section{Request syntax}{
\preformatted{svc$put_integration_response(
  restApiId = "string",
  resourceId = "string",
  httpMethod = "string",
  statusCode = "string",
  selectionPattern = "string",
  responseParameters = list(
    "string"
  ),
  responseTemplates = list(
    "string"
  ),
  contentHandling = "CONVERT_TO_BINARY"|"CONVERT_TO_TEXT"
)
}
}

\keyword{internal}
