% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_get_authorizers}
\alias{apigatewayv2_get_authorizers}
\title{Gets the Authorizers for an API}
\usage{
apigatewayv2_get_authorizers(ApiId, MaxResults, NextToken)
}
\arguments{
\item{ApiId}{[required] The API identifier.}

\item{MaxResults}{The maximum number of elements to be returned for this resource.}

\item{NextToken}{The next page of elements from this collection. Not valid for the last
element of the collection.}
}
\value{
A list with the following syntax:\preformatted{list(
  Items = list(
    list(
      AuthorizerCredentialsArn = "string",
      AuthorizerId = "string",
      AuthorizerPayloadFormatVersion = "string",
      AuthorizerResultTtlInSeconds = 123,
      AuthorizerType = "REQUEST"|"JWT",
      AuthorizerUri = "string",
      EnableSimpleResponses = TRUE|FALSE,
      IdentitySource = list(
        "string"
      ),
      IdentityValidationExpression = "string",
      JwtConfiguration = list(
        Audience = list(
          "string"
        ),
        Issuer = "string"
      ),
      Name = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets the Authorizers for an API.
}
\section{Request syntax}{
\preformatted{svc$get_authorizers(
  ApiId = "string",
  MaxResults = "string",
  NextToken = "string"
)
}
}

\keyword{internal}
