% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_list_cloud_front_origin_access_identities}
\alias{cloudfront_list_cloud_front_origin_access_identities}
\title{Lists origin access identities}
\usage{
cloudfront_list_cloud_front_origin_access_identities(Marker, MaxItems)
}
\arguments{
\item{Marker}{Use this when paginating results to indicate where to begin in your list
of origin access identities. The results include identities in the list
that occur after the marker. To get the next page of results, set the
\code{Marker} to the value of the \code{NextMarker} from the current page's
response (which is also the ID of the last identity on that page).}

\item{MaxItems}{The maximum number of origin access identities you want in the response
body.}
}
\value{
A list with the following syntax:\preformatted{list(
  CloudFrontOriginAccessIdentityList = list(
    Marker = "string",
    NextMarker = "string",
    MaxItems = 123,
    IsTruncated = TRUE|FALSE,
    Quantity = 123,
    Items = list(
      list(
        Id = "string",
        S3CanonicalUserId = "string",
        Comment = "string"
      )
    )
  )
)
}
}
\description{
Lists origin access identities.
}
\section{Request syntax}{
\preformatted{svc$list_cloud_front_origin_access_identities(
  Marker = "string",
  MaxItems = "string"
)
}
}

\keyword{internal}
