% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53domains_operations.R
\name{route53domains_update_domain_nameservers}
\alias{route53domains_update_domain_nameservers}
\title{This operation replaces the current set of name servers for the domain
with the specified set of name servers}
\usage{
route53domains_update_domain_nameservers(DomainName, FIAuthKey,
  Nameservers)
}
\arguments{
\item{DomainName}{[required] The name of the domain that you want to change name servers for.}

\item{FIAuthKey}{The authorization key for .fi domains}

\item{Nameservers}{[required] A list of new name servers for the domain.}
}
\value{
A list with the following syntax:\preformatted{list(
  OperationId = "string"
)
}
}
\description{
This operation replaces the current set of name servers for the domain
with the specified set of name servers. If you use Amazon Route 53 as
your DNS service, specify the four name servers in the delegation set
for the hosted zone for the domain.

If successful, this operation returns an operation ID that you can use
to track the progress and completion of the action. If the request is
not completed successfully, the domain registrant will be notified by
email.
}
\section{Request syntax}{
\preformatted{svc$update_domain_nameservers(
  DomainName = "string",
  FIAuthKey = "string",
  Nameservers = list(
    list(
      Name = "string",
      GlueIps = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
