% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_create_realtime_log_config}
\alias{cloudfront_create_realtime_log_config}
\title{Creates a real-time log configuration}
\usage{
cloudfront_create_realtime_log_config(EndPoints, Fields, Name,
  SamplingRate)
}
\arguments{
\item{EndPoints}{[required] Contains information about the Amazon Kinesis data stream where you are
sending real-time log data.}

\item{Fields}{[required] A list of fields to include in each real-time log record.

For more information about fields, see \href{https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields}{Real-time log configuration fields}
in the \emph{Amazon CloudFront Developer Guide}.}

\item{Name}{[required] A unique name to identify this real-time log configuration.}

\item{SamplingRate}{[required] The sampling rate for this real-time log configuration. The sampling
rate determines the percentage of viewer requests that are represented
in the real-time log data. You must provide an integer between 1 and
100, inclusive.}
}
\value{
A list with the following syntax:\preformatted{list(
  RealtimeLogConfig = list(
    ARN = "string",
    Name = "string",
    SamplingRate = 123,
    EndPoints = list(
      list(
        StreamType = "string",
        KinesisStreamConfig = list(
          RoleARN = "string",
          StreamARN = "string"
        )
      )
    ),
    Fields = list(
      "string"
    )
  )
)
}
}
\description{
Creates a real-time log configuration.

After you create a real-time log configuration, you can attach it to one
or more cache behaviors to send real-time log data to the specified
Amazon Kinesis data stream.

For more information about real-time log configurations, see \href{https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html}{Real-time logs}
in the \emph{Amazon CloudFront Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_realtime_log_config(
  EndPoints = list(
    list(
      StreamType = "string",
      KinesisStreamConfig = list(
        RoleARN = "string",
        StreamARN = "string"
      )
    )
  ),
  Fields = list(
    "string"
  ),
  Name = "string",
  SamplingRate = 123
)
}
}

\keyword{internal}
