% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_create_stage}
\alias{apigatewayv2_create_stage}
\title{Creates a Stage for an API}
\usage{
apigatewayv2_create_stage(AccessLogSettings, ApiId, ClientCertificateId,
  DefaultRouteSettings, DeploymentId, Description, RouteSettings,
  StageName, StageVariables, Tags)
}
\arguments{
\item{AccessLogSettings}{Settings for logging access in this stage.}

\item{ApiId}{[required] The API identifier.}

\item{ClientCertificateId}{The identifier of a client certificate for a Stage.}

\item{DefaultRouteSettings}{The default route settings for the stage.}

\item{DeploymentId}{The deployment identifier of the API stage.}

\item{Description}{The description for the API stage.}

\item{RouteSettings}{Route settings for the stage.}

\item{StageName}{[required] The name of the stage.}

\item{StageVariables}{A map that defines the stage variables for a Stage. Variable names can
have alphanumeric and underscore characters, and the values must match
[A-Za-z0-9-.\_~:/?\#&=,]+.}

\item{Tags}{The key-value map of strings. The valid character set is
[a-zA-Z+-=.\_:/]. The tag key can be up to 128 characters and must not
start with aws:. The tag value can be up to 256 characters..}
}
\description{
Creates a Stage for an API.
}
\section{Request syntax}{
\preformatted{svc$create_stage(
  AccessLogSettings = list(
    DestinationArn = "string",
    Format = "string"
  ),
  ApiId = "string",
  ClientCertificateId = "string",
  DefaultRouteSettings = list(
    DataTraceEnabled = TRUE|FALSE,
    DetailedMetricsEnabled = TRUE|FALSE,
    LoggingLevel = "ERROR"|"INFO"|"false",
    ThrottlingBurstLimit = 123,
    ThrottlingRateLimit = 123.0
  ),
  DeploymentId = "string",
  Description = "string",
  RouteSettings = list(
    list(
      DataTraceEnabled = TRUE|FALSE,
      DetailedMetricsEnabled = TRUE|FALSE,
      LoggingLevel = "ERROR"|"INFO"|"false",
      ThrottlingBurstLimit = 123,
      ThrottlingRateLimit = 123.0
    )
  ),
  StageName = "string",
  StageVariables = list(
    "string"
  ),
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
