% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_create_transit_virtual_interface}
\alias{directconnect_create_transit_virtual_interface}
\title{Creates a transit virtual interface}
\usage{
directconnect_create_transit_virtual_interface(connectionId,
  newTransitVirtualInterface)
}
\arguments{
\item{connectionId}{[required] The ID of the connection.}

\item{newTransitVirtualInterface}{[required] Information about the transit virtual interface.}
}
\description{
Creates a transit virtual interface. A transit virtual interface should
be used to access one or more transit gateways associated with Direct
Connect gateways. A transit virtual interface enables the connection of
multiple VPCs attached to a transit gateway to a Direct Connect gateway.
}
\details{
If you associate your transit gateway with one or more Direct Connect
gateways, the Autonomous System Number (ASN) used by the transit gateway
and the Direct Connect gateway must be different. For example, if you
use the default ASN 64512 for both your the transit gateway and Direct
Connect gateway, the association request fails.

Setting the MTU of a virtual interface to 8500 (jumbo frames) can cause
an update to the underlying physical connection if it wasn\'t updated to
support jumbo frames. Updating the connection disrupts network
connectivity for all virtual interfaces associated with the connection
for up to 30 seconds. To check whether your connection supports jumbo
frames, call DescribeConnections. To check whether your virtual
interface supports jumbo frames, call DescribeVirtualInterfaces.
}
\section{Request syntax}{
\preformatted{svc$create_transit_virtual_interface(
  connectionId = "string",
  newTransitVirtualInterface = list(
    virtualInterfaceName = "string",
    vlan = 123,
    asn = 123,
    mtu = 123,
    authKey = "string",
    amazonAddress = "string",
    customerAddress = "string",
    addressFamily = "ipv4"|"ipv6",
    directConnectGatewayId = "string",
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    )
  )
)
}
}

\keyword{internal}
