% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_provision_byoip_cidr}
\alias{globalaccelerator_provision_byoip_cidr}
\title{Provisions an IP address range to use with your Amazon Web Services
resources through bring your own IP addresses (BYOIP) and creates a
corresponding address pool}
\usage{
globalaccelerator_provision_byoip_cidr(Cidr, CidrAuthorizationContext)
}
\arguments{
\item{Cidr}{[required] The public IPv4 address range, in CIDR notation. The most specific IP
prefix that you can specify is /24. The address range cannot overlap
with another address range that you've brought to this or another
Region.}

\item{CidrAuthorizationContext}{[required] A signed document that proves that you are authorized to bring the
specified IP address range to Amazon using BYOIP.}
}
\description{
Provisions an IP address range to use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be advertised using \href{https://docs.aws.amazon.com/global-accelerator/latest/api/}{AdvertiseByoipCidr}.

See \url{https://www.paws-r-sdk.com/docs/globalaccelerator_provision_byoip_cidr/} for full documentation.
}
\keyword{internal}
