# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' AWS Security Token Service
#'
#' @description
#' The AWS Security Token Service (STS) is a web service that enables you
#' to request temporary, limited-privilege credentials for AWS Identity and
#' Access Management (IAM) users or for users that you authenticate
#' (federated users). This guide provides descriptions of the STS API. For
#' more detailed information about using this service, go to [Temporary
#' Security
#' Credentials](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp.html).
#' 
#' As an alternative to using the API, you can use one of the AWS SDKs,
#' which consist of libraries and sample code for various programming
#' languages and platforms (Java, Ruby, .NET, iOS, Android, etc.). The SDKs
#' provide a convenient way to create programmatic access to STS. For
#' example, the SDKs take care of cryptographically signing requests,
#' managing errors, and retrying requests automatically. For information
#' about the AWS SDKs, including how to download and install them, see the
#' [Tools for Amazon Web Services page](http://aws.amazon.com/tools/).
#' 
#' For information about setting up signatures and authorization through
#' the API, go to [Signing AWS API
#' Requests](http://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html)
#' in the *AWS General Reference*. For general information about the Query
#' API, go to [Making Query
#' Requests](http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
#' in *Using IAM*. For information about using security tokens with other
#' AWS products, go to [AWS Services That Work with
#' IAM](http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html)
#' in the *IAM User Guide*.
#' 
#' If you\'re new to AWS and need additional technical information about a
#' specific AWS product, you can find the product\'s technical
#' documentation at <http://aws.amazon.com/documentation/>.
#' 
#' **Endpoints**
#' 
#' The AWS Security Token Service (STS) has a default endpoint of
#' https://sts.amazonaws.com that maps to the US East (N. Virginia) region.
#' Additional regions are available and are activated by default. For more
#' information, see [Activating and Deactivating AWS STS in an AWS
#' Region](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
#' in the *IAM User Guide*.
#' 
#' For information about STS endpoints, see [Regions and
#' Endpoints](http://docs.aws.amazon.com/general/latest/gr/rande.html#sts_region)
#' in the *AWS General Reference*.
#' 
#' **Recording API requests**
#' 
#' STS supports AWS CloudTrail, which is a service that records AWS calls
#' for your AWS account and delivers log files to an Amazon S3 bucket. By
#' using information collected by CloudTrail, you can determine what
#' requests were successfully made to STS, who made the request, when it
#' was made, and so on. To learn more about CloudTrail, including how to
#' turn it on and find your log files, see the [AWS CloudTrail User
#' Guide](http://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html).
#'
#' @examples
#' # 
#' \donttest{svc <- sts()
#' svc$assume_role(
#'   DurationSeconds = 3600L,
#'   ExternalId = "123ABC",
#'   Policy = "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Sid\":\"Stmt1\",\"Effect\":...",
#'   RoleArn = "arn:aws:iam::123456789012:role/demo",
#'   RoleSessionName = "Bob"
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=sts_assume_role]{assume_role} \tab Returns a set of temporary security credentials (consisting of an access key ID, a secret access key, and a security token) that you can use to access AWS resources that you might not normally have access to \cr
#'  \link[=sts_assume_role_with_saml]{assume_role_with_saml} \tab Returns a set of temporary security credentials for users who have been authenticated via a SAML authentication response \cr
#'  \link[=sts_assume_role_with_web_identity]{assume_role_with_web_identity} \tab Returns a set of temporary security credentials for users who have been authenticated in a mobile or web application with a web identity provider, such as Amazon Cognito, Login with Amazon, Facebook, Google, or any OpenID Connect-compatible identity provider\cr
#'  \link[=sts_decode_authorization_message]{decode_authorization_message} \tab Decodes additional information about the authorization status of a request from an encoded message returned in response to an AWS request \cr
#'  \link[=sts_get_caller_identity]{get_caller_identity} \tab Returns details about the IAM identity whose credentials are used to call the API \cr
#'  \link[=sts_get_federation_token]{get_federation_token} \tab Returns a set of temporary security credentials (consisting of an access key ID, a secret access key, and a security token) for a federated user \cr
#'  \link[=sts_get_session_token]{get_session_token} \tab Returns a set of temporary credentials for an AWS account or IAM user 
#' }
#'
#' @rdname sts
#' @export
sts <- function() {
  .sts$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.sts <- list()

.sts$operations <- list()

.sts$metadata <- list(
  service_name = "sts",
  endpoints = list("*" = "https://sts.amazonaws.com", "us-gov-*" = "sts.{region}.amazonaws.com"),
  service_id = "STS",
  api_version = "2011-06-15",
  signing_name = NULL,
  json_version = "",
  target_prefix = ""
)

.sts$handlers <- new_handlers("query", "v4")

.sts$service <- function() {
  new_service(.sts$metadata, .sts$handlers)
}
